import java.awt.*;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.net.*;

class PldSimPanel extends JPanel 
  implements MouseMotionListener{  

    
  PldSimPanel(PldSimFunctions FunctionsPanel, int in, int out){

	
      
      //this.setOpaque(false);
      this.setBackground(new Color(255,255,255));
      FunctionsPanel.setBackground(new Color(255,255,255));
      this.setForeground(new Color(0,0,100));
    fp = FunctionsPanel;
    ins = in;
    outs = out;
    int yChange = 0;
    int y2Change = 0;
    int index = 0;
    // This will set the string values that each connection represent
    for(int x = 0; x < 48; x++){
      if (x <= 5)
        L[x] = Letters[0];   
      else if (x <= 11)
	L[x] = Letters[1];	
      else if (x <= 17)
	L[x] = Letters[2];	
      else if (x <= 23)
	L[x] = Letters[3];	
      else if (x <= 29)
	L[x] = Letters[4];	
      else if (x <= 35)
	L[x] = Letters[5];	
      else if (x <= 41)
	L[x] = Letters[6];	
      else
  	L[x] = Letters[7];
      CURRNCONNECTIONS=ins*12 + outs*6 ;
      //fp.Clear.setFocusPainted(true);
      fp.Clear.requestFocus();
    }

     for (int i = 0; i < MAXNCONNECTIONS; i++)
	isConnected[i] = false;
        
     // This while loop initialize and saves all the connections staring points
	while (index < MAXNCONNECTIONS){

	  if (index < (MAXNCONNECTIONS/3) * 2){
              
	    // set AND matrix connections 	
	    connections[index] = new Point(170, 10 + yChange);
	    connections[index + 1] = new Point(230, 10 + yChange);
	    connections[index + 2] = new Point(290, 10 + yChange);
	    connections[index + 3] = new Point(350, 10 + yChange);
	    connections[index + 4] = new Point(410, 10 + yChange);
	    connections[index + 5] = new Point(470, 10 + yChange);
	    connections[index + 6] = new Point(170, 50 + yChange);
	    connections[index + 7] = new Point(230, 50 + yChange);
	    connections[index + 8] = new Point(290, 50 + yChange);
	    connections[index + 9] = new Point(350, 50 + yChange);
	    connections[index + 10] = new Point(410, 50 + yChange);
	    connections[index + 11] = new Point(470, 50 + yChange);
	    yChange = yChange + 80;
	    index = index + 12;
            y2Change = (ins - 2) * 80;
	  }
	  else{
            // OR matrix connections
	    connections[index] = new Point(170, 230 + y2Change);
	    connections[index + 1] = new Point(230, 230 + y2Change);
	    connections[index + 2] = new Point(290, 230 + y2Change);
	    connections[index + 3] = new Point(350, 230 + y2Change);
	    connections[index + 4] = new Point(410, 230 + y2Change);
	    connections[index + 5] = new Point(470, 230 + y2Change);
	    y2Change = y2Change + 40;
	    index = index + 6;
	  } 
 	}
  
      addMouseListener(new MouseAdapter()
	// This method start when the mouse is pressed in the panel and revises if the 
	// point where the mouse was click is whitin one of the connection area 
	// if it is will call other methods to connect or disconnect the connection
         {  public void mousePressed(MouseEvent evt) 
            {  
               int x = evt.getX();
               int y = evt.getY();
	       // Check the mouse point is with in a connection range
               currentConnection = findConnection(x, y);  
	       // connnect and disconnect connections according to the acquire information
	       // and the connection status 
               if (currentConnection >= 0 && !isConnected[currentConnection]){
	          Graphics g = getGraphics();
		  connect(g, currentConnection);  //creating connection
		  g.dispose();
	       }	
               else if(currentConnection >= 0 && isConnected[currentConnection]){
	          Graphics g = getGraphics();
                  disconnect(g, currentConnection); // disconnection connection
  		  g.dispose();

	       }
               fp.Clear.requestFocus();
            }
         });
      addMouseMotionListener(this);
  }

  // This method draws the PLD
  public void paintComponent(Graphics screen) {
	
    
    if( isOpaque() ) { super.paintComponent( screen ); }
    screen.setColor(new Color(0,0,100));
  //Tiling the Background...
        /*	int CurrX=0;
	int CurrY=0;
	while(CurrX<this.getWidth()){
		while(CurrY<this.getHeight()){
			Bg.paintIcon(this,screen,CurrX,CurrY);
			CurrY+=Bg.getIconHeight();
		}
		CurrX+=Bg.getIconWidth();
		CurrY=0;
	}
	
        */

    int x[] = {85, 85, 115};
    int points = x.length;
    int ydif = 0;
    int y2dif = 0;
    int y3dif = 0;
    for(int k = 0; k < ins; k++){
      int y[] = {00 + ydif, 35 + ydif, 15 + ydif};
      Polygon poly = new Polygon(x, y, points);
      //AND Matrix
      screen.setColor(new Color(255,0,0));
      screen.drawString(Inputs[0 + k], 40, 15 + ydif);  // input name
      
      screen.setColor(new Color(0,0,100));
      screen.drawLine(55, 15 + ydif, 85, 15 + ydif);    // input line
      screen.setColor(new Color(0,150,200));
      screen.drawPolygon(poly);  //Buffer
      screen.drawRoundRect(115, 13 + ydif, 4, 4, 2, 2);
      screen.setColor(new Color(0,0,100));
      
      // Positive horizontal lines
      screen.drawLine(120, 15 + ydif, 170, 15 + ydif);
      screen.drawLine(180, 15 + ydif, 230, 15 + ydif);
      screen.drawLine(240, 15 + ydif, 290, 15 + ydif);
      screen.drawLine(300, 15 + ydif, 350, 15 + ydif);
      screen.drawLine(360, 15 + ydif, 410, 15 + ydif);
      screen.drawLine(420, 15 + ydif, 470, 15 + ydif);
      screen.drawLine(480, 15 + ydif, 530, 15 + ydif);

      // vertical lines
      screen.drawLine(75, 15 + ydif, 75, 55 + ydif);
      screen.drawLine(175, 20 + ydif, 175, 50 + ydif);
      screen.drawLine(235, 20 + ydif, 235, 50 + ydif);
      screen.drawLine(295, 20 + ydif, 295, 50 + ydif);
      screen.drawLine(355, 20 + ydif, 355, 50 + ydif);
      screen.drawLine(415, 20 + ydif, 415, 50 + ydif);
      screen.drawLine(475, 20 + ydif, 475, 50 + ydif);

      // Negative horizontal lines
      screen.drawLine(75, 55 + ydif, 170, 55 + ydif);
      screen.drawLine(180, 55 + ydif, 230, 55 + ydif);
      screen.drawLine(240, 55 + ydif, 290, 55 + ydif);
      screen.drawLine(300, 55 + ydif, 350, 55 + ydif);
      screen.drawLine(360, 55 + ydif, 410, 55 + ydif);
      screen.drawLine(420, 55 + ydif, 470, 55 + ydif);
      screen.drawLine(480, 55 + ydif, 530, 55 + ydif);

      // Vertical lines
      screen.drawLine(175, 60 + ydif, 175, 90 + ydif);
      screen.drawLine(235, 60 + ydif, 235, 90 + ydif);
      screen.drawLine(295, 60 + ydif, 295, 90 + ydif);
      screen.drawLine(355, 60 + ydif, 355, 90 + ydif);
      screen.drawLine(415, 60 + ydif, 415, 90 + ydif);
      screen.drawLine(475, 60 + ydif, 475, 90 + ydif);

      // Positive connections
      screen.drawRect(170, 10 + ydif, 10, 10);
      screen.drawRect(230, 10 + ydif, 10, 10);
      screen.drawRect(290, 10 + ydif, 10, 10);
      screen.drawRect(350, 10 + ydif, 10, 10);
      screen.drawRect(410, 10 + ydif, 10, 10);
      screen.drawRect(470, 10 + ydif, 10, 10);

      screen.drawRect(170, 50 + ydif, 10, 10);
      screen.drawRect(230, 50 + ydif, 10, 10);
      screen.drawRect(290, 50 + ydif, 10, 10);
      screen.drawRect(350, 50 + ydif, 10, 10);
      screen.drawRect(410, 50 + ydif, 10, 10);
      screen.drawRect(470, 50 + ydif, 10, 10);

      ydif = ydif + 80;
    }
    y2dif = (ins - 2) * 80;

    // And Gates
    screen.setColor(new Color(150,150,150));
    screen.drawLine(155, 170 + y2dif, 195, 170 + y2dif);
    screen.drawLine(215, 170 + y2dif, 255, 170 + y2dif);
    screen.drawLine(275, 170 + y2dif, 315, 170 + y2dif); 
    screen.drawLine(335, 170 + y2dif, 375, 170 + y2dif);
    screen.drawLine(395, 170 + y2dif, 435, 170 + y2dif); 
    screen.drawLine(455, 170 + y2dif, 495, 170 + y2dif);

    screen.drawArc(155, 145 + y2dif, 40, 55, 180, 180);
    screen.drawArc(215, 145 + y2dif, 40, 55, 180, 180);
    screen.drawArc(275, 145 + y2dif, 40, 55, 180, 180);
    screen.drawArc(335, 145 + y2dif, 40, 55, 180, 180);
    screen.drawArc(395, 145 + y2dif, 40, 55, 180, 180);
    screen.drawArc(455, 145 + y2dif, 40, 55, 180, 180);
    screen.setColor(new Color(0,0,100));
    // OR matrix
    y3dif = y3dif + y2dif;
    for(int i2 = 0; i2 < outs; i2++){
      //And Outputs
      screen.drawLine(175, 200 + y3dif, 175, 230 + y3dif);
      screen.drawLine(235, 200 + y3dif, 235, 230 + y3dif);
      screen.drawLine(295, 200 + y3dif, 295, 230 + y3dif);
      screen.drawLine(355, 200 + y3dif, 355, 230 + y3dif);
      screen.drawLine(415, 200 + y3dif, 415, 230 + y3dif);
      screen.drawLine(475, 200 + y3dif, 475, 230 + y3dif);

      // OR matrix horizontal
      screen.drawLine(125, 235 + y3dif, 170, 235 + y3dif);
      screen.drawLine(180, 235 + y3dif, 230, 235 + y3dif);
      screen.drawLine(240, 235 + y3dif, 290, 235 + y3dif);
      screen.drawLine(300, 235 + y3dif, 350, 235 + y3dif);
      screen.drawLine(360, 235 + y3dif, 410, 235 + y3dif);
      screen.drawLine(420, 235 + y3dif, 470, 235 + y3dif);
      screen.drawLine(480, 235 + y3dif, 530, 235 + y3dif);

      // OR matirx connections
      screen.drawRect(170, 230 + y3dif, 10, 10);
      screen.drawRect(230, 230 + y3dif, 10, 10);
      screen.drawRect(290, 230 + y3dif, 10, 10);
      screen.drawRect(350, 230 + y3dif, 10, 10);
      screen.drawRect(410, 230 + y3dif, 10, 10);
      screen.drawRect(470, 230 + y3dif, 10, 10);

      //OR Gates
      screen.setColor(new Color(0,150,0));
      screen.drawArc(490, 220 + y3dif, 40, 30, 90, -180);
      screen.drawArc(455, 220 + y3dif, 110, 30, 90, -180);
      screen.drawLine(565, 235 + y3dif, 585, 235 + y3dif);
      screen.setColor(new Color(0,0,100));
    y3dif = y3dif + 40;
    }
    //All connections
    screen.setColor(new Color(0,0,0));
    for(int ii=0;ii<MAXNCONNECTIONS;ii++){
    if (isConnected[ii]){
        screen.fillRect(connections[ii].x + 1, connections[ii].y + 1, 
         CONNECTIONLENGTH - 1, 
         CONNECTIONLENGTH - 1); //Drawing Connection
    }
    }
    screen.setColor(new Color(0,0,100));
    //fp.Clear.setFocusPainted(true);
    //fp.Clear.requestFocus();
}
  //This method checks whether or not a point is with in a connection range
  public int findConnection(int x, int y)
  {  for (int i = 0; i < MAXNCONNECTIONS; i++)
         if (connections[i].x <= x && 
               x <= connections[i].x + CONNECTIONLENGTH
               && connections[i].y <= y 
               && y <= connections[i].y + CONNECTIONLENGTH){
             if((i<ins*12) || (i>=48 && i<(48+outs*6)))
                return i;
         }
      return -1;
  }

  
  // This method creates the PLD's connections
  public void connect(Graphics g, int i)
  {  g.setColor(new Color(0,0,10));
       g.fillRect(connections[i].x + 1, connections[i].y + 1, 
         CONNECTIONLENGTH - 1, 
         CONNECTIONLENGTH - 1);
      isConnected[i] = true;
      outChange();
   }
   // This method creates the Pld's disconnections
   public void disconnect(Graphics g, int i)
   {  g.setXORMode(getBackground());
      g.fillRect(connections[i].x + 1, connections[i].y + 1, 
         CONNECTIONLENGTH - 1, 
         CONNECTIONLENGTH - 1);
      isConnected[i] = false;
      outChange();

   }
   // This method changes the mouse pointer while crossing a Pld connection
   public void mouseMoved(MouseEvent evt) 
   {  int x = evt.getX();
      int y = evt.getY();

      if (findConnection(x, y) >=  0) 
         setCursor(Cursor.getPredefinedCursor
            (Cursor.HAND_CURSOR)); 
      else 
         setCursor(Cursor.getDefaultCursor());
   }
   // This method must be added in order to use the mouseMoved method 
   public void mouseDragged(MouseEvent evt){}
  // This method will create and change the Pld's output 
  // according to the changes made 
  public void outChange()
  {  int j = 0;    
     
     for(int clear = 0; clear < 6; clear++)
       AND[clear] = "";

     while(j < 48){
       for (int x = 0; x < 6; x++){ 
        if (isConnected[j + x])
          AND[x] = AND[x] + L[j + x];
       } // end for
	j = j + 6;
     } // end while

    for(int clear2 = 0; clear2 < 4; clear2++){
      Function[clear2] = "";
      andCounter[clear2] = 0;
    }
    // create functions
    int f = 48; 
    while(f < 72){
      for(int u = 0; u < 4; u++){
        for(int n = 0; n < 6; n++){
          if (isConnected[f + n] && andCounter[u] == 0){
            Function[u] = Function[u] + AND[n];
	    andCounter[u] = andCounter[u] + 1;
          }
          else if (isConnected[f + n]){
            Function[u] = Function[u] + " + " + AND[n];
	    andCounter[u] = andCounter[u] + 1;
          }
        } // end for
        f = f + 6;
      } // end for
    } // end while
   // Put new functions in the textboxes
   for(int T = 0; T < outs; T++){
     fp.tfield[T].setText(Function[T]);
     //fp.tfield[T].setEditable(false);
   }
    
    //fp.Clear.setFocusPainted(true);
  } // end outChange

  public void Reset(){
      for(int i=0;i<MAXNCONNECTIONS;i++){
                    isConnected[i] = false;
                }
                outChange();
                repaint();
                fp.Clear.requestFocus();
  }
      
   PldSimFunctions fp;
   private String Inputs[] = {"A", "B", "C", "D"};  // inputs names
   private int ins;      			    // inputs require by the user
   private int outs;				    // outputs require by the user	
   private static final int CONNECTIONLENGTH = 10;  // connection's range
   private static final int MAXNCONNECTIONS = 72;   // maximun number of connection
   private static int CURRNCONNECTIONS = 0;   // number of connections currently used
   private Point connections[] = new Point[MAXNCONNECTIONS];  // connection starting point
   private boolean isConnected[] = new boolean[MAXNCONNECTIONS]; // connection status
   private int currentConnection = -1;
   private String Letters[] = {"A'" ,"A", "B'", "B", "C'", "C", "D'", "D"}; 
   private String L[] = new String[48]; // connection outputs
   private String AND[] = new String[6];  
   private String Function[] = new String[4];
   private int andCounter[] = new int[4];
}

class PldSimFunctions extends JPanel {
    
public void paintComponent(Graphics screen) {
    if( isOpaque() ) { super.paintComponent( screen ); }
}
  PldSimFunctions(int spNum, int tbNum ) {
      
        Clear.setSize(new Dimension(100,30));
        

        //this.setOpaque(false);
        //this.setBackground(new Color(255,255,255));
	Box bv = Box.createVerticalBox();
        bv.setOpaque(false);
        Box bh = Box.createHorizontalBox();
        bh.setOpaque(false);
	Box bh1 = Box.createHorizontalBox();
        bh1.setOpaque(false);
	Box bh2 = Box.createHorizontalBox();
        bh2.setOpaque(false);
	Box bh3 = Box.createHorizontalBox();
        bh3.setOpaque(false);
	Box bh4 = Box.createHorizontalBox();
        bh4.setOpaque(false);
         
        bh.add(Clear);
        bh.add(About);
        bh.add(Help);

        bh.add(Box.createHorizontalGlue());
        bh.add(Box.createHorizontalStrut(120)); 
	bv.add(Box.createGlue());
	bv.add(Box.createVerticalStrut((spNum) * 80 - 10)); 
	bv.add(bh);
	bv.add(Box.createVerticalStrut(19)); 
        
	// Here we create and set positions of the panel's labels and textboxes
	for(int i2 = 0; i2 < tbNum; i2++){
          tfield[i2] = new JLabel("");//(33);
          tfield[i2].setSize(new Dimension(200,30));
          tfield[i2].setForeground(new Color(255,0,0));
          
          switch (i2) {
	      case 0: 
	  	bh1.add(new JLabel(Fun[i2]));
          	bh1.add(tfield[i2]);
                bh1.add(Box.createHorizontalGlue());
                //bh1.add(Box.createHorizontalStrut()); 
		bv.add(Box.createGlue());
		bv.add(Box.createVerticalStrut(29)); 
	  	bv.add(bh1);
		bv.add(Box.createVerticalStrut(25)); 
		break;
	      case 1: 
                bh2.add(new JLabel(Fun[i2]));
          	bh2.add(tfield[i2]);
                bh2.add(Box.createHorizontalGlue()); 
	  	bv.add(bh2);
		bv.add(Box.createVerticalStrut(25)); 
		bv.add(Box.createGlue());
		break;
	      case 2: 
	  	bh3.add(new JLabel(Fun[i2]));
          	bh3.add(tfield[i2]);
                bh3.add(Box.createHorizontalGlue()); 
	  	bv.add(bh3);
		bv.add(Box.createVerticalStrut(25)); 
		bv.add(Box.createGlue());
		break;
	      case 3: 
	  	bh4.add(new JLabel(Fun[i2]));
          	bh4.add(tfield[i2]);
                bh4.add(Box.createHorizontalGlue()); 
	  	bv.add(bh4);
		break;
	    }
        }
        add(bv);       
        
    }

  public JButton Clear = new JButton("Reset");
  public JButton About = new JButton("About");
  public JButton Help = new JButton("Help");
  JLabel tfield[] = new JLabel[4];  // outputs
  private String Fun[] = {"F1 = ", "F2 = ", "F3 = ", "F4 = "};  // output labels

}



public class PldSim extends javax.swing.JApplet
{
  public void init(){
    int nInputs = 0;
    int nOutputs = 0;
    try {
	UIManager.setLookAndFeel(
	    UIManager.getSystemLookAndFeelClassName());
    } catch (Exception e) {
        System.err.println("couldn't use the system "
			 + "look and feel: " + e);
    }

    // Recieve the Pld's number of inputs from the user 
    String numOfInputs = (String)JOptionPane.showInputDialog(null,
    				 "How many inputs do you want in your PLD?",
                         	 "Enter the number of inputs",
				 JOptionPane.QUESTION_MESSAGE,
			 	 null,
				 new String[] { "2", "3", "4" }, 
			 	 "2");

    // Recieve the Pld's number of output from the user 
    String numOfOutputs = (String)JOptionPane.showInputDialog(null,
			  	  "How many outputs do you want in your PLD?",
			  	  "Enter the number of inputs",
			  	  JOptionPane.QUESTION_MESSAGE,
                             	  null,
				  new String[] { "2", "3", "4" }, 
				  "2");
	
     nInputs = stringToInt(numOfInputs);
     nOutputs = stringToInt(numOfOutputs);
  
    functions = new PldSimFunctions(nInputs, nOutputs);
    pld= new PldSimPanel(functions, nInputs, nOutputs);

    
    functions.Clear.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                Reset();
            }
        });
        
    functions.Clear.addKeyListener(new KeyAdapter(){
            public void keyPressed(KeyEvent evt){
                if(evt.getKeyChar()==' ' || evt.getKeyChar()=='\n'){
                    Reset();
                }
            }
        });
        
    functions.Help.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                URL codeBaseURL = getCodeBase();
                URL helpURL;

                try
                {
                        helpURL = new URL( codeBaseURL.toString() + "help.html" );
                        getAppletContext().showDocument( helpURL, "_blank" );
                }
                catch ( Exception e ) { }
                }
        });
    functions.About.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                new AboutDialogue().show();
            }
        });
        
    Container contentPane = getContentPane();
    
    functions.setBorder(new EmptyBorder(0,0,0,0));
    JScrollPane Scrolling = new JScrollPane(functions){
            public void paintComponent(Graphics screen) {
	                if( isOpaque() ) { super.paintComponent( screen ); }
            }
    };
    Scrolling.setOpaque(false);
    Scrolling.getViewport().setOpaque(false);
    Scrolling.setBackground(new Color(255,255,255));
    Scrolling.setBorder(new EmptyBorder(0,0,0,0));
    JPanel BG=new JPanel();
    //contentPane.setLayout(new FlowLayout());
    BG.setLayout(new BorderLayout());
    BG.add("East", Scrolling);
    BG.add("Center", pld);
    contentPane.add(BG);
    this.setBackground(Color.white);
  }
  
  
    // This method changes a string representation of a integer to integer
    int stringToInt(String num){
	
	if (num.equals("2")) 
	  return 2;
	else if (num.equals("3")) 
	  return 3;	
	else if (num.equals("4")) 
	  return 4;
	
	return 0;
    }  
   
    void Reset(){
        pld.Reset();
    }
    PldSimPanel pld;
    PldSimFunctions functions;
    
         class AboutDialogue extends javax.swing.JFrame implements HyperlinkListener {
    
    /** Creates new form About */
    public AboutDialogue() {
        initComponents();
        this.setSize(new java.awt.Dimension(500, 350));
        this.setBackground(Color.white);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension DialogSize = getSize();
        Point DialogLocation = new Point( ( screenSize.width
                  - DialogSize.width ) / 2, ( screenSize.height -
                  DialogSize.height ) / 2 );

        setLocation( DialogLocation );
    }
    
    //Listens for hyperlink clicks
    public void hyperlinkUpdate(HyperlinkEvent event) {
    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        try
         {
            getAppletContext().showDocument( event.getURL(), "_blank" );
         }
         catch ( Exception e ) { }
    }
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        AboutLabel = new javax.swing.JLabel();
        LowerPanel = new javax.swing.JPanel();
        OkButton = new javax.swing.JButton();
        CentralPane = new javax.swing.JScrollPane();
        MainText = new javax.swing.JEditorPane();

        setTitle("About The Programmable Logic Device Simulator");
        setBackground(Color.white);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        AboutLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        AboutLabel.setText("About The Programmable Logic Device Simulator");
        AboutLabel.setMaximumSize(new java.awt.Dimension(41, 55));
        AboutLabel.setMinimumSize(new java.awt.Dimension(41, 55));
        AboutLabel.setPreferredSize(new java.awt.Dimension(41, 35));
        AboutLabel.setOpaque(false);
        AboutLabel.setBackground(Color.white);
        getContentPane().add(AboutLabel, java.awt.BorderLayout.NORTH);

        LowerPanel.setPreferredSize(new java.awt.Dimension(10, 45));
        LowerPanel.setOpaque(false);
        LowerPanel.setBackground(Color.white);
        OkButton.setText("Ok");
        OkButton.setPreferredSize(new java.awt.Dimension(100, 26));
        OkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OkButtonActionPerformed(evt);
            }
        });

        LowerPanel.add(OkButton);

        getContentPane().add(LowerPanel, java.awt.BorderLayout.SOUTH);

        CentralPane.setPreferredSize(new java.awt.Dimension(177, 150));
        CentralPane.getViewport().setOpaque(false);
        String AboutText="<html>\n<body><b>The Programmable Logic Device Simulator</b><br><br>Copyright 2001-2003, New Jersey Institute of Technology, Newark, NJ, USA<br><br>\n";
        AboutText+="This program and its source code are made freely available under<br> the terms of the GNU General Public License.  Terms<br> of this license can be found at <a href='http://www.gnu.org'>www.gnu.org</a>.<br><br>\n";
        AboutText+="The latest version of this program and its source code, as well as<br> other simulators developed for use with the textbook <i>Computer Systems<br> Organization and Architecture</i>, can be found at <a href='www.awl.com/carpinelli'>www.awl.com/carpinelli</a>.<br><br>\n";
        AboutText+="Development of this program was funded in part by the National<br> Science Foundation through the <a href='http://www.gatewaycoalition.org/'>Gateway Engineering Education Coalition</a>.<br> Additional funding was supplied by the <a href='http://www.njcmr.org/'>New Jersey Center for Multimedia Research</a>.<br><br>\n";
        AboutText+="Developers: Antonio Colon, Aleksandr Livshits, and John D. Carpinelli.\n</body></html>";
        MainText.setEditable(false);
        MainText.setContentType("text/html");
        MainText.setText(AboutText);
        MainText.setCaretPosition(0);
        //MainText.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        MainText.setOpaque(false);
        MainText.setBackground(Color.white);
        MainText.addHyperlinkListener(this);
        CentralPane.setViewportView(MainText);
        

        getContentPane().add(CentralPane, java.awt.BorderLayout.CENTER);

        pack();
    }

    private void OkButtonActionPerformed(java.awt.event.ActionEvent evt) {
        // Add your handling code here:
        this.hide();
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        System.exit(0);
    }
    
    
    // Variables declaration - do not modify
    private javax.swing.JButton OkButton;
    private javax.swing.JPanel LowerPanel;
    private javax.swing.JLabel AboutLabel;
    private javax.swing.JScrollPane CentralPane;
    private javax.swing.JEditorPane MainText;
    // End of variables declaration
    
  }

}