/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Assembler {
    public static final String NOP = new String("NOP");
    public static final String LDAC = new String("LDAC");
    public static final String STAC = new String("STAC");
    public static final String MVAC = new String("MVAC");
    public static final String MOVR = new String("MOVR");
    public static final String JUMP = new String("JUMP");
    public static final String JMPZ = new String("JMPZ");
    public static final String JPNZ = new String("JPNZ");
    public static final String ADD = new String("ADD");
    public static final String SUB = new String("SUB");
    public static final String INAC = new String("INAC");
    public static final String CLAC = new String("CLAC");
    public static final String AND = new String("AND");
    public static final String OR = new String("OR");
    public static final String XOR = new String("XOR");
    public static final String NOT = new String("NOT");
    public static final String END = new String("END");
    public static final String ORG = new String("ORG");
    public static final String DB = new String("DB");
    public static final String DW = new String("DW");

    public static AssemblyResults assemble(String string, int n, Box box, CPU cPU, Memory memory) {
        Object object;
        Object[] objectArray;
        AssemblySourceProgram assemblySourceProgram = new AssemblySourceProgram(string);
        int n2 = n;
        Vector<AssemblyError> vector = new Vector<AssemblyError>();
        int n3 = 0;
        int n4 = 1;
        while (n4 <= assemblySourceProgram.sourceLineLength()) {
            box.showStatus("Assembling . . . Checking line " + n4);
            objectArray = assemblySourceProgram.getSourceLineByLineNumber(n4);
            if (objectArray != null && objectArray.sourceTokenLength() > 0) {
                object = objectArray.getSourceTokenStringArray();
                int n5 = 0;
                if (Assembler.IsLabel((String)object[0])) {
                    n5 = 1;
                }
                if (ORG.equalsIgnoreCase((String)object[0 + n5])) {
                    if (((Object)object).length - n5 < 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "ORG expects one operand"));
                    } else if (((Object)object).length - n5 > 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "ORG does not accept more than one operand"));
                    } else if (!AssemblyInstruction.isAddress((String)object[1 + n5])) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "Specified address is invalid"));
                    }
                } else if (DB.equalsIgnoreCase((String)object[0 + n5])) {
                    if (((Object)object).length - n5 < 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "DB expects one operand"));
                    } else if (((Object)object).length - n5 > 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "DB does not accept more than one operand"));
                    } else if (AssemblyInstruction.toByteShort((String)object[1 + n5]) == -1) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "Specified byte constant is invalid"));
                    }
                } else if (DW.equalsIgnoreCase((String)object[0 + n5])) {
                    if (((Object)object).length - n5 < 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "DW expects one operand"));
                    } else if (((Object)object).length - n5 > 2) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "DW does not accept more than one operand"));
                    } else if (AssemblyInstruction.toWordInteger((String)object[1 + n5]) == -1) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, "Specified word constant is invalid"));
                    }
                } else if (AssemblyInstruction.isMnemonic((String)object[0 + n5])) {
                    if (AssemblyInstruction.expectsOperands((String)object[0 + n5]) == 1) {
                        if (((Object)object).length - n5 < 2) {
                            ++n3;
                            vector.addElement(new AssemblyError(n4, ((String)object[0 + n5]).toUpperCase() + " expects " + "one operand"));
                        } else if (((Object)object).length - n5 > 2) {
                            ++n3;
                            vector.addElement(new AssemblyError(n4, ((String)object[0 + n5]).toUpperCase() + " does not " + "accept more than one operand"));
                        } else if (!AssemblyInstruction.isAddress((String)object[1 + n5]) && !Assembler.LabelExists((String)object[1 + n5], assemblySourceProgram)) {
                            ++n3;
                            vector.addElement(new AssemblyError(n4, "Specified address is invalid"));
                        }
                    } else if (((Object)object).length - n5 > 1) {
                        ++n3;
                        vector.addElement(new AssemblyError(n4, ((String)object[0 + n5]).toUpperCase() + " does not " + "accept any operands"));
                    }
                } else {
                    ++n3;
                    vector.addElement(new AssemblyError(n4, "Specified mnemonic is invalid"));
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            box.showStatus("Assembling . . . " + n3 + " error(s) " + "encountered");
        } else {
            int n6 = 1;
            while (n6 <= assemblySourceProgram.sourceLineLength()) {
                box.showStatus("Assembling . . . Assembling line " + n6);
                object = assemblySourceProgram.getSourceLineByLineNumber(n6);
                if (object != null && ((AssemblySourceLine)object).toString() != "" && ((AssemblySourceLine)object).sourceTokenLength() > 0) {
                    String[] stringArray = ((AssemblySourceLine)object).getSourceTokenStringArray();
                    int n7 = 0;
                    if (Assembler.IsLabel(stringArray[0])) {
                        n7 = 1;
                    }
                    if (ORG.equalsIgnoreCase(stringArray[0 + n7])) {
                        n2 = AssemblyInstruction.toAddressInteger(stringArray[1 + n7]);
                    } else if (DB.equalsIgnoreCase(stringArray[0 + n7])) {
                        short s = AssemblyInstruction.toByteShort(stringArray[1 + n7]);
                        memory.write(n2, s);
                        ++n2;
                    } else if (DW.equalsIgnoreCase(stringArray[0 + n7])) {
                        short[] sArray = AssemblyInstruction.toWordCode(AssemblyInstruction.toWordInteger(stringArray[1 + n7]));
                        memory.write(n2, sArray[0]);
                        memory.write(n2 + 1, sArray[1]);
                        n2 += 2;
                    } else {
                        assemblySourceProgram.setSourceLineAddressByLineNumber(n2, n6);
                        memory.write(n2, AssemblyInstruction.toMnemonicCode(stringArray[0 + n7]));
                        if (AssemblyInstruction.expectsOperands(stringArray[0 + n7]) == 1) {
                            short[] sArray = Assembler.LabelExists(stringArray[1 + n7], assemblySourceProgram) ? AssemblyInstruction.toAddressCode(Assembler.GetLabelAddress(stringArray[1 + n7], assemblySourceProgram)) : AssemblyInstruction.toAddressCode(AssemblyInstruction.toAddressInteger(stringArray[1 + n7]));
                            memory.write(n2 + 1, sArray[0]);
                            memory.write(n2 + 2, sArray[1]);
                            n2 += 2;
                        }
                        ++n2;
                    }
                }
                ++n6;
            }
        }
        cPU.getMemory().repaint();
        objectArray = new AssemblyError[vector.size()];
        vector.copyInto(objectArray);
        box.showStatus("Assembly Complete");
        return new AssemblyResults((AssemblyError[])objectArray, assemblySourceProgram);
    }

    public static String[] toBinaryNybble(short s) {
        String string = Integer.toString(s / 16, 2);
        String string2 = Integer.toString(s % 16, 2);
        while (string.length() < 4) {
            string = "0" + string;
        }
        while (string2.length() < 4) {
            string2 = "0" + string2;
        }
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    private static boolean IsLabel(String string) {
        return string.indexOf(58) != -1 && string.indexOf(58) == string.length() - 1 && string.length() > 1;
    }

    private static boolean LabelExists(String string, AssemblySourceProgram assemblySourceProgram) {
        int n = 1;
        while (n <= assemblySourceProgram.sourceLineLength()) {
            AssemblySourceLine assemblySourceLine = assemblySourceProgram.getSourceLineByLineNumber(n);
            if (assemblySourceLine != null && assemblySourceLine.GetLabel().toLowerCase().equals(string.toLowerCase() + ":")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static int GetLabelAddress(String string, AssemblySourceProgram assemblySourceProgram) {
        if (Assembler.LabelExists(string, assemblySourceProgram)) {
            int n = 0;
            int n2 = 1;
            while (n2 <= assemblySourceProgram.sourceLineLength()) {
                AssemblySourceLine assemblySourceLine = assemblySourceProgram.getSourceLineByLineNumber(n2);
                if (assemblySourceLine != null && assemblySourceLine.GetLabel().toLowerCase().equals(string.toLowerCase() + ":")) {
                    return n;
                }
                if (assemblySourceLine != null && assemblySourceLine.sourceTokenLength() > 0) {
                    String[] stringArray = assemblySourceLine.getSourceTokenStringArray();
                    int n3 = 0;
                    if (Assembler.IsLabel(stringArray[0])) {
                        n3 = 1;
                    }
                    if (ORG.equalsIgnoreCase(stringArray[0 + n3])) {
                        n = AssemblyInstruction.toAddressInteger(stringArray[1 + n3]);
                    } else if (DB.equalsIgnoreCase(stringArray[0 + n3])) {
                        ++n;
                    } else if (DW.equalsIgnoreCase(stringArray[0 + n3])) {
                        n += 2;
                    } else {
                        assemblySourceProgram.setSourceLineAddressByLineNumber(n, n2);
                        if (AssemblyInstruction.expectsOperands(stringArray[0 + n3]) == 1) {
                            n += 2;
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }
}

