/*
 * Decompiled with CFR 0.152.
 */
public class AssemblyInstruction {
    public static final String NOP = new String("NOP");
    public static final String LDAC = new String("LDAC");
    public static final String STAC = new String("STAC");
    public static final String MVAC = new String("MVAC");
    public static final String MOVR = new String("MOVR");
    public static final String JUMP = new String("JUMP");
    public static final String JMPZ = new String("JMPZ");
    public static final String JPNZ = new String("JPNZ");
    public static final String ADD = new String("ADD");
    public static final String SUB = new String("SUB");
    public static final String INAC = new String("INAC");
    public static final String CLAC = new String("CLAC");
    public static final String AND = new String("AND");
    public static final String OR = new String("OR");
    public static final String XOR = new String("XOR");
    public static final String NOT = new String("NOT");
    public static final String END = new String("END");
    public static final short opcodeNOP = 0;
    public static final short opcodeLDAC = 1;
    public static final short opcodeSTAC = 2;
    public static final short opcodeMVAC = 3;
    public static final short opcodeMOVR = 4;
    public static final short opcodeJUMP = 5;
    public static final short opcodeJMPZ = 6;
    public static final short opcodeJPNZ = 7;
    public static final short opcodeADD = 8;
    public static final short opcodeSUB = 9;
    public static final short opcodeINAC = 10;
    public static final short opcodeCLAC = 11;
    public static final short opcodeAND = 12;
    public static final short opcodeOR = 13;
    public static final short opcodeXOR = 14;
    public static final short opcodeNOT = 15;
    public static final short opcodeEND = 255;

    public static short toMnemonicCode(String string) {
        if (NOP.equalsIgnoreCase(string)) {
            return 0;
        }
        if (LDAC.equalsIgnoreCase(string)) {
            return 1;
        }
        if (STAC.equalsIgnoreCase(string)) {
            return 2;
        }
        if (MVAC.equalsIgnoreCase(string)) {
            return 3;
        }
        if (MOVR.equalsIgnoreCase(string)) {
            return 4;
        }
        if (JUMP.equalsIgnoreCase(string)) {
            return 5;
        }
        if (JMPZ.equalsIgnoreCase(string)) {
            return 6;
        }
        if (JPNZ.equalsIgnoreCase(string)) {
            return 7;
        }
        if (ADD.equalsIgnoreCase(string)) {
            return 8;
        }
        if (SUB.equalsIgnoreCase(string)) {
            return 9;
        }
        if (INAC.equalsIgnoreCase(string)) {
            return 10;
        }
        if (CLAC.equalsIgnoreCase(string)) {
            return 11;
        }
        if (AND.equalsIgnoreCase(string)) {
            return 12;
        }
        if (OR.equalsIgnoreCase(string)) {
            return 13;
        }
        if (XOR.equalsIgnoreCase(string)) {
            return 14;
        }
        if (NOT.equalsIgnoreCase(string)) {
            return 15;
        }
        if (END.equalsIgnoreCase(string)) {
            return 255;
        }
        return -1;
    }

    public static String toMnemonic(short s) {
        switch (s) {
            case 0: {
                return NOP;
            }
            case 1: {
                return LDAC;
            }
            case 2: {
                return STAC;
            }
            case 3: {
                return MVAC;
            }
            case 4: {
                return MOVR;
            }
            case 5: {
                return JUMP;
            }
            case 6: {
                return JMPZ;
            }
            case 7: {
                return JPNZ;
            }
            case 8: {
                return ADD;
            }
            case 9: {
                return SUB;
            }
            case 10: {
                return INAC;
            }
            case 11: {
                return CLAC;
            }
            case 12: {
                return AND;
            }
            case 13: {
                return OR;
            }
            case 14: {
                return XOR;
            }
            case 15: {
                return NOT;
            }
            case 255: {
                return END;
            }
        }
        return null;
    }

    public static short[] toInstructionCode(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        if (stringArray[0] != null && (stringArray[0].equalsIgnoreCase(NOP) || stringArray[0].equalsIgnoreCase(MVAC) || stringArray[0].equalsIgnoreCase(MOVR) || stringArray[0].equalsIgnoreCase(ADD) || stringArray[0].equalsIgnoreCase(SUB) || stringArray[0].equalsIgnoreCase(INAC) || stringArray[0].equalsIgnoreCase(CLAC) || stringArray[0].equalsIgnoreCase(AND) || stringArray[0].equalsIgnoreCase(OR) || stringArray[0].equalsIgnoreCase(XOR) || stringArray[0].equalsIgnoreCase(NOT) || stringArray[0].equalsIgnoreCase(END)) && stringArray.length < 2) {
            short[] sArray = new short[]{AssemblyInstruction.toMnemonicCode(stringArray[0])};
            return sArray;
        }
        if (stringArray[0] != null && (stringArray[0].equalsIgnoreCase(LDAC) || stringArray[0].equalsIgnoreCase(STAC) || stringArray[0].equalsIgnoreCase(JUMP) || stringArray[0].equalsIgnoreCase(JMPZ) || stringArray[0].equalsIgnoreCase(JPNZ)) && stringArray.length < 3 && AssemblyInstruction.isAddress(stringArray[1])) {
            short[] sArray = new short[3];
            short[] sArray2 = AssemblyInstruction.toAddressCode(AssemblyInstruction.toAddressInteger(stringArray[1]));
            sArray[0] = AssemblyInstruction.toMnemonicCode(stringArray[0]);
            sArray[1] = sArray2[0];
            sArray[2] = sArray2[1];
            return sArray;
        }
        return null;
    }

    public static int toAddressInteger(String string) {
        int n;
        if (string != null && !string.equals("")) {
            char c = string.charAt(string.length() - 1);
            int n2 = AssemblyInstruction.toRadix(c);
            if (n2 != -1) {
                string = string.substring(0, string.length() - 1);
            } else {
                n2 = 10;
            }
            try {
                n = Integer.valueOf(string, n2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        } else {
            return -1;
        }
        if (AssemblyInstruction.isAddress(n)) {
            return n;
        }
        return -1;
    }

    public static short[] toAddressCode(int n) {
        if (AssemblyInstruction.isAddress(n)) {
            short[] sArray = new short[]{(short)(n % 256), (short)(n / 256 % 256)};
            return sArray;
        }
        return null;
    }

    public static int toRadix(char c) {
        if ((c = Character.toLowerCase(c)) == 'b') {
            return 2;
        }
        if (c == 'o' || c == 'q') {
            return 8;
        }
        if (c == 'd') {
            return 10;
        }
        if (c == 'h') {
            return 16;
        }
        return -1;
    }

    public static boolean isConstantByte(short s) {
        return s >= 0 && s <= 255;
    }

    public static boolean isConstantWord(int n) {
        return n >= 0 && n <= 65535;
    }

    public static boolean isMnemonic(String string) {
        return NOP.equalsIgnoreCase(string) || LDAC.equalsIgnoreCase(string) || STAC.equalsIgnoreCase(string) || MVAC.equalsIgnoreCase(string) || MOVR.equalsIgnoreCase(string) || JUMP.equalsIgnoreCase(string) || JMPZ.equalsIgnoreCase(string) || JPNZ.equalsIgnoreCase(string) || ADD.equalsIgnoreCase(string) || SUB.equalsIgnoreCase(string) || INAC.equalsIgnoreCase(string) || CLAC.equalsIgnoreCase(string) || AND.equalsIgnoreCase(string) || OR.equalsIgnoreCase(string) || XOR.equalsIgnoreCase(string) || NOT.equalsIgnoreCase(string) || END.equalsIgnoreCase(string);
    }

    public static boolean isAddress(int n) {
        return n >= 0 && n <= 65535;
    }

    public static boolean isByte(short s) {
        return s >= 0 && s <= 255;
    }

    public static boolean isWord(int n) {
        return n >= 0 && n <= 65535;
    }

    public static boolean isAddress(String string) {
        return AssemblyInstruction.toAddressInteger(string) != -1;
    }

    public static boolean isValidOperands(String string, String[] stringArray) {
        if (string.equalsIgnoreCase(NOP) || string.equalsIgnoreCase(MVAC) || string.equalsIgnoreCase(MOVR) || string.equalsIgnoreCase(ADD) || string.equalsIgnoreCase(SUB) || string.equalsIgnoreCase(INAC) || string.equalsIgnoreCase(CLAC) || string.equalsIgnoreCase(AND) || string.equalsIgnoreCase(OR) || string.equalsIgnoreCase(XOR) || string.equalsIgnoreCase(NOT) || string.equalsIgnoreCase(END)) {
            return stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("");
        }
        if (string.equalsIgnoreCase(LDAC) || string.equalsIgnoreCase(STAC) || string.equalsIgnoreCase(JUMP) || string.equalsIgnoreCase(JMPZ) || string.equalsIgnoreCase(JPNZ)) {
            return stringArray != null && stringArray.length == 1 && AssemblyInstruction.isAddress(stringArray[0]);
        }
        return false;
    }

    public static int expectsOperands(String string) {
        if (string.equalsIgnoreCase(NOP) || string.equalsIgnoreCase(MVAC) || string.equalsIgnoreCase(MOVR) || string.equalsIgnoreCase(ADD) || string.equalsIgnoreCase(SUB) || string.equalsIgnoreCase(INAC) || string.equalsIgnoreCase(CLAC) || string.equalsIgnoreCase(AND) || string.equalsIgnoreCase(OR) || string.equalsIgnoreCase(XOR) || string.equalsIgnoreCase(NOT) || string.equalsIgnoreCase(END)) {
            return 0;
        }
        if (string.equalsIgnoreCase(LDAC) || string.equalsIgnoreCase(STAC) || string.equalsIgnoreCase(JUMP) || string.equalsIgnoreCase(JMPZ) || string.equalsIgnoreCase(JPNZ)) {
            return 1;
        }
        return -1;
    }

    public static short toByteShort(String string) {
        short s;
        if (string != null && !string.equals("")) {
            char c = string.charAt(string.length() - 1);
            int n = AssemblyInstruction.toRadix(c);
            if (n != -1) {
                string = string.substring(0, string.length() - 1);
            } else {
                n = 10;
            }
            try {
                s = Short.valueOf(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        } else {
            return -1;
        }
        if (AssemblyInstruction.isByte(s)) {
            return s;
        }
        return -1;
    }

    public static int toWordInteger(String string) {
        int n;
        if (string != null && !string.equals("")) {
            char c = string.charAt(string.length() - 1);
            int n2 = AssemblyInstruction.toRadix(c);
            if (n2 != -1) {
                string = string.substring(0, string.length() - 1);
            } else {
                n2 = 10;
            }
            try {
                n = Integer.valueOf(string, n2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        } else {
            return -1;
        }
        if (AssemblyInstruction.isWord(n)) {
            return n;
        }
        return -1;
    }

    public static short[] toWordCode(int n) {
        if (AssemblyInstruction.isWord(n)) {
            short[] sArray = new short[]{(short)(n % 256), (short)(n / 256 % 256)};
            return sArray;
        }
        return null;
    }

    public static String toNumberString(long l, int n, int n2) {
        String string = Long.toString(l, n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(string.length() - n2, string.length());
    }
}

