/*
 * Decompiled with CFR 0.152.
 */
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;

public class AssemblySourceProgram {
    private AssemblySourceLine[] sourceLineArray;
    private String sourceString;
    private boolean empty = true;

    public AssemblySourceProgram(String string) {
        this.sourceString = string;
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 9);
        streamTokenizer.wordChars(11, 12);
        streamTokenizer.wordChars(14, 65535);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.eolIsSignificant(true);
        Vector<AssemblySourceLine> vector = new Vector<AssemblySourceLine>();
        String string2 = "";
        int n = 0;
        int n2 = streamTokenizer.lineno();
        try {
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype == -3) {
                    string2 = streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype != 10) continue;
                AssemblySourceLine assemblySourceLine = this.findSourceLine(string2, n, n2);
                vector.addElement(assemblySourceLine);
                if (assemblySourceLine.sourceTokenLength() > 0) {
                    this.empty = true;
                }
                string2 = "";
                n2 = streamTokenizer.lineno();
                n = assemblySourceLine.getSubstringRange().getEndIndex();
                if (n == this.sourceString.indexOf("\r\n", n)) {
                    n += 2;
                    continue;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
        }
        if (string2 != "") {
            n2 = streamTokenizer.lineno();
            vector.addElement(this.findSourceLine(string2, n, n2));
        }
        this.sourceLineArray = new AssemblySourceLine[vector.size()];
        vector.copyInto(this.sourceLineArray);
    }

    public AssemblySourceLine getSourceLineByLineNumber(int n) {
        if (n > 0 && n <= this.sourceLineArray.length) {
            return this.sourceLineArray[n - 1];
        }
        return null;
    }

    public AssemblySourceLine getSourceLineByAddress(int n) {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.sourceLineArray.length) {
                if (n == this.sourceLineArray[n2].getAddress()) {
                    return this.sourceLineArray[n2];
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    public void setSourceLineAddressByLineNumber(int n, int n2) {
        if (n2 > 0 && n2 <= this.sourceLineArray.length) {
            this.sourceLineArray[n2 - 1].setAddress(n);
        }
    }

    public int sourceLineLength() {
        return this.sourceLineArray.length;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private AssemblySourceLine findSourceLine(String string, int n, int n2) {
        int n3 = this.sourceString.indexOf(string, n);
        int n4 = n3 + string.length();
        SubstringRange substringRange = new SubstringRange(n3, n4);
        return new AssemblySourceLine(this.sourceString, substringRange, n2);
    }
}

