/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Box
extends Applet
implements ActionListener {
    String AR = new String("0000000000000000");
    String PC = new String("0000000000000000");
    String DR = new String("00000000");
    String TR = new String("00000000");
    String IR = new String("00000000");
    String R = new String("00000000");
    String AC = new String("00000000");
    String Z = new String("0");
    long ARint = 0L;
    long PCint = 0L;
    long DRint = 0L;
    long TRint = 0L;
    long IRint = 0L;
    long Rint = 0L;
    long ACint = 0L;
    long Zint = 0L;
    public CheckboxGroup selectCU = new CheckboxGroup();
    public Checkbox hardWiredCU = new Checkbox("Hardwired", true, this.selectCU);
    public Checkbox microCodedCU = new Checkbox("Microprogrammed", false, this.selectCU);
    public Button assembleButton = new Button("       Assemble      ");
    public Button viewResultsButton = new Button("  View Results  ");
    private TextArea programBox;
    private Button viewCPUButton = new Button("   View Register Section   ");
    private Button viewTraceButton = new Button("   View Trace   ");
    private Button viewMemoryButton = new Button(" View Memory  ");
    private Button helpButton = new Button("  Help  ");
    private Button aboutButton = new Button("  About  ");
    private Button viewControlUnitButton = new Button("View Control Unit");
    private Button clearMemoryButton = new Button("  Clear Memory  ");
    private Button viewBreakpointsButton = new Button("View Breakpoints");
    private Label label = new Label("Memory Location:");
    private Label space = new Label("");
    private Label space2 = new Label("                    ");
    private Label cuType = new Label("Control Unit Type");
    private Label space3 = new Label("        ");
    private TextField memoryLocation = new TextField(5);
    private AssemblyResults results;
    private AssemblyResultsDialog resultsDialog = null;
    private CPU CPUBox;
    static String newline = System.getProperty("line.separator");
    public TraceResults traceDialog;

    public void init() {
        FlowLayout flowLayout = new FlowLayout(1, 10, 30);
        this.programBox = new TextArea(18, 36);
        this.memoryLocation.setText("0");
        this.setLayout(flowLayout);
        this.setBackground(Color.white);
        this.add(this.programBox);
        this.add(this.label);
        this.add(this.memoryLocation);
        this.add(this.space2);
        this.add(this.cuType);
        this.add(this.hardWiredCU);
        this.add(this.microCodedCU);
        this.add(this.space3);
        this.add(this.space);
        this.add(this.assembleButton);
        this.add(this.viewResultsButton);
        this.add(this.viewTraceButton);
        this.add(this.viewCPUButton);
        this.add(this.viewMemoryButton);
        this.add(this.viewControlUnitButton);
        this.add(this.clearMemoryButton);
        this.add(this.viewBreakpointsButton);
        this.add(this.helpButton);
        this.add(this.aboutButton);
        this.assembleButton.addActionListener(this);
        this.viewResultsButton.setEnabled(false);
        this.viewResultsButton.addActionListener(this);
        this.viewCPUButton.addActionListener(this);
        this.viewTraceButton.addActionListener(this);
        this.viewMemoryButton.addActionListener(this);
        this.viewControlUnitButton.addActionListener(this);
        this.clearMemoryButton.addActionListener(this);
        this.viewBreakpointsButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.aboutButton.addActionListener(this);
        this.CPUBox = new CPU(this, "Register Section");
        this.hardWiredCU.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Box.this.CPUBox.isRunning() && Box.this.hardWiredCU.getState()) {
                    System.out.println("DEBUG ==> hw cu selected");
                    if (((Box)Box.this).CPUBox.mcu.isShowing()) {
                        ((Box)Box.this).CPUBox.controlUnit.setVisible(true);
                        ((Box)Box.this).CPUBox.mcu.setVisible(false);
                    }
                    ((Box)Box.this).CPUBox.controlUnit.setActive(true);
                    ((Box)Box.this).CPUBox.mcu.setActive(false);
                    Box.this.CPUBox.setControlUnitType(CPU.CU_HARDWIRED);
                }
            }
        });
        this.microCodedCU.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!Box.this.CPUBox.isRunning() && Box.this.microCodedCU.getState()) {
                    System.out.println("DEBUG ==> mc cu selected");
                    if (((Box)Box.this).CPUBox.controlUnit.isShowing()) {
                        ((Box)Box.this).CPUBox.controlUnit.setVisible(false);
                        ((Box)Box.this).CPUBox.mcu.setVisible(true);
                    }
                    ((Box)Box.this).CPUBox.controlUnit.setActive(false);
                    ((Box)Box.this).CPUBox.mcu.setActive(true);
                    Box.this.CPUBox.setControlUnitType(CPU.CU_MICROCODED);
                }
            }
        });
    }

    public void stop() {
    }

    public void destroy() {
        this.CPUBox.dispose();
        if (this.resultsDialog != null) {
            this.resultsDialog.dispose();
        }
    }

    public void paint(Graphics graphics) {
        Font font = new Font("SansSerif", 1, 12);
        graphics.setFont(font);
        graphics.drawString("Please Enter Code Below", 90, 20);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.assembleButton) {
            if (!this.CPUBox.isRunning()) {
                int n = AssemblyInstruction.toWordInteger(this.memoryLocation.getText());
                if (n != -1) {
                    if (this.resultsDialog != null && this.resultsDialog.isShowing()) {
                        this.resultsDialog.dispose();
                    }
                    this.results = Assembler.assemble(this.programBox.getText(), n, this, this.CPUBox, this.CPUBox.getMemory());
                    AssemblyError[] assemblyErrorArray = this.results.getErrors();
                    if (assemblyErrorArray.length > 0) {
                        this.programBox.select(this.FindNthRowStart(assemblyErrorArray[0].getLineNumber(), this.programBox.getText()), this.FindNthRowEnd(assemblyErrorArray[0].getLineNumber(), this.programBox.getText()) + 1);
                    }
                    this.resultsDialog = new AssemblyResultsDialog(this.getFrame(), "Assembly Results", false, this.results);
                    this.traceDialog = new TraceResults(this.getFrame(), "Trace Results");
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension dimension2 = this.resultsDialog.getSize();
                    Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                    this.resultsDialog.setLocation(point);
                    this.resultsDialog.setVisible(true);
                    this.CPUBox.getBreakpoints().refreshBreakpointList();
                    this.traceDialog.setLocation(point);
                    this.viewResultsButton.setEnabled(true);
                } else {
                    this.showStatus("Invalid memory location!");
                }
            } else {
                this.showStatus("CPU is running!");
            }
        } else if (object == this.viewResultsButton) {
            if (this.resultsDialog != null) {
                this.resultsDialog.setVisible(true);
            } else {
                this.showStatus("No results to report!");
            }
        } else if (object == this.viewTraceButton) {
            if (this.resultsDialog != null) {
                this.traceDialog.setVisible(true);
            } else {
                this.showStatus("No results to report!");
            }
        } else if (object == this.viewCPUButton) {
            this.CPUBox.setVisible(true);
        } else if (object == this.viewMemoryButton) {
            this.CPUBox.getMemory().setVisible(true);
        } else if (object == this.viewControlUnitButton) {
            if (this.selectCU.getSelectedCheckbox().equals(this.hardWiredCU)) {
                this.CPUBox.mcu.setVisible(false);
                this.CPUBox.mcu.setActive(false);
                this.CPUBox.controlUnit.setVisible(true);
                this.CPUBox.controlUnit.setActive(true);
            } else if (this.selectCU.getSelectedCheckbox().equals(this.microCodedCU)) {
                this.CPUBox.controlUnit.setVisible(false);
                this.CPUBox.controlUnit.setActive(false);
                this.CPUBox.mcu.setVisible(true);
                this.CPUBox.mcu.setActive(true);
            }
        } else if (object == this.viewTraceButton) {
            if (this.resultsDialog != null) {
                this.traceDialog.setVisible(true);
            } else {
                this.showStatus("No results to report!");
            }
        } else if (object == this.clearMemoryButton) {
            if (!this.CPUBox.isRunning()) {
                Memory memory = this.CPUBox.getMemory();
                memory.clear();
                if (memory.isShowing()) {
                    memory.repaint();
                }
            }
        } else if (object == this.viewBreakpointsButton) {
            this.CPUBox.getBreakpoints().setVisible(true);
        } else if (object == this.helpButton) {
            URL uRL = this.getCodeBase();
            try {
                URL uRL2 = new URL(uRL.toString() + "help/index.html");
                this.getAppletContext().showDocument(uRL2, "_blank");
            }
            catch (Exception exception) {}
        } else if (object == this.aboutButton) {
            new AboutDialogue().show();
        }
    }

    public AssemblyResults getAssemblyResults() {
        return this.results;
    }

    public CPU getCPU() {
        return this.CPUBox;
    }

    public void disableComponents() {
        this.assembleButton.setEnabled(false);
        this.hardWiredCU.setEnabled(false);
        this.microCodedCU.setEnabled(false);
        this.clearMemoryButton.setEnabled(false);
    }

    public void enableComponents() {
        this.assembleButton.setEnabled(true);
        this.hardWiredCU.setEnabled(true);
        this.microCodedCU.setEnabled(true);
        this.clearMemoryButton.setEnabled(true);
    }

    public Frame getFrame() {
        Container container = this;
        Frame frame = null;
        while ((container = container.getParent()) != null) {
            if (!(container instanceof Frame)) continue;
            frame = (Frame)container;
        }
        return frame;
    }

    public int FindNthRowStart(int n, String string) {
        if (n == 1) {
            return 0;
        }
        int n2 = -1;
        int n3 = 1;
        while (n3 != n) {
            n2 = string.indexOf("\n", n2 + 1);
            ++n3;
        }
        return n2 + 1;
    }

    public int FindNthRowEnd(int n, String string) {
        int n2 = -1;
        int n3 = 1;
        while (n3 != n + 1) {
            n2 = string.indexOf("\n", n2 + 1);
            ++n3;
        }
        if (n2 == -1) {
            return string.length() - 1;
        }
        return n2 - 1;
    }

    class AboutDialogue
    extends JFrame
    implements HyperlinkListener {
        private JButton OkButton;
        private JPanel LowerPanel;
        private JLabel AboutLabel;
        private JScrollPane CentralPane;
        private JEditorPane MainText;

        public AboutDialogue() {
            this.initComponents();
            this.setSize(new Dimension(500, 350));
            this.setBackground(Color.white);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.setLocation(point);
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            block2: {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block2;
                try {
                    Box.this.getAppletContext().showDocument(hyperlinkEvent.getURL(), "_blank");
                }
                catch (Exception exception) {}
            }
        }

        private void initComponents() {
            this.AboutLabel = new JLabel();
            this.LowerPanel = new JPanel();
            this.OkButton = new JButton();
            this.CentralPane = new JScrollPane();
            this.MainText = new JEditorPane();
            this.setTitle("About The Relatively Simple CPU Simulator");
            this.setBackground(Color.white);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ AboutDialogue this$1;
                {
                    this.this$1 = aboutDialogue;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    AboutDialogue.access$100(this.this$1, windowEvent);
                }
            });
            this.AboutLabel.setHorizontalAlignment(0);
            this.AboutLabel.setText("About The Relatively Simple CPU Simulator");
            this.AboutLabel.setMaximumSize(new Dimension(41, 55));
            this.AboutLabel.setMinimumSize(new Dimension(41, 55));
            this.AboutLabel.setPreferredSize(new Dimension(41, 35));
            this.AboutLabel.setOpaque(false);
            this.AboutLabel.setBackground(Color.white);
            this.getContentPane().add((Component)this.AboutLabel, "North");
            this.LowerPanel.setPreferredSize(new Dimension(10, 45));
            this.LowerPanel.setOpaque(false);
            this.LowerPanel.setBackground(Color.white);
            this.OkButton.setText("Ok");
            this.OkButton.setPreferredSize(new Dimension(100, 26));
            this.OkButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ AboutDialogue this$1;
                {
                    this.this$1 = aboutDialogue;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    AboutDialogue.access$200(this.this$1, actionEvent);
                }
            });
            this.LowerPanel.add(this.OkButton);
            this.getContentPane().add((Component)this.LowerPanel, "South");
            this.CentralPane.setPreferredSize(new Dimension(177, 150));
            this.CentralPane.getViewport().setOpaque(false);
            this.CentralPane.getVerticalScrollBar().setValue(0);
            String string = "<html>\n<body><b>The Relatively Simple CPU Simulator</b><br><br>Copyright 1999-2003, New Jersey Institute of Technology, Newark, NJ, USA<br><br>\n";
            string = string + "This program and its source code are made freely available under<br> the terms of the GNU General Public License.  Terms<br> of this license can be found at <a href='http://www.gnu.org'>www.gnu.org</a>.<br><br>\n";
            string = string + "The latest version of this program and its source code, as well as<br> other simulators developed for use with the textbook <i>Computer Systems<br> Organization and Architecture</i>, can be found at <a href='http://www.awl.com/carpinelli'>www.awl.com/carpinelli</a>.<br><br>\n";
            string = string + "Development of this program was funded in part by the National<br> Science Foundation through the <a href='http://www.gatewaycoalition.org/'>Gateway Engineering Education Coalition</a>.<br>  Additional funding was supplied by a Provost\u2019s Challenge grant from the <a href='http://www.njit.edu'>New Jersey Institute of Technology</a>.<br><br>\n";
            string = string + "Developers: Aamish Kapadia, Raymond Bobrowski, Leo Hendriks,<br> Benedicto Catalan, Aleksandr Livshits, and John D. Carpinelli.\n</body></html>";
            this.MainText.setEditable(false);
            this.MainText.setContentType("text/html");
            this.MainText.setText(string);
            this.MainText.setCaretPosition(0);
            this.MainText.setOpaque(false);
            this.MainText.setBackground(Color.white);
            this.MainText.addHyperlinkListener(this);
            this.CentralPane.setViewportView(this.MainText);
            this.getContentPane().add((Component)this.CentralPane, "Center");
            this.pack();
        }

        private void OkButtonActionPerformed(ActionEvent actionEvent) {
            this.hide();
        }

        private void exitForm(WindowEvent windowEvent) {
            System.exit(0);
        }

        static /* synthetic */ void access$100(AboutDialogue aboutDialogue, WindowEvent windowEvent) {
            aboutDialogue.exitForm(windowEvent);
        }

        static /* synthetic */ void access$200(AboutDialogue aboutDialogue, ActionEvent actionEvent) {
            aboutDialogue.OkButtonActionPerformed(actionEvent);
        }
    }
}

