/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class McodeControlUnit
extends Frame
implements ActionListener {
    private static final int COND_MASK = 0x60000000;
    private static final int BT_MASK = 0x10000000;
    private static final int OPER_MASK = 0xFFFFFC0;
    private static final int ARPC_MASK = 0x8000000;
    private static final int ARIN_MASK = 0x4000000;
    private static final int ARDT_MASK = 0x2000000;
    private static final int PCIN_MASK = 0x1000000;
    private static final int PCDT_MASK = 0x800000;
    private static final int DRM_MASK = 0x400000;
    private static final int DRAC_MASK = 0x200000;
    private static final int IRDR_MASK = 0x100000;
    private static final int RAC_MASK = 524288;
    private static final int ZALU_MASK = 262144;
    private static final int TRDR_MASK = 131072;
    private static final int ACDR_MASK = 65536;
    private static final int ACR_MASK = 32768;
    private static final int PLUS_MASK = 16384;
    private static final int MINU_MASK = 8192;
    private static final int ACIN_MASK = 4096;
    private static final int ACZO_MASK = 2048;
    private static final int AND_MASK = 1024;
    private static final int OR_MASK = 512;
    private static final int XOR_MASK = 256;
    private static final int NOT_MASK = 128;
    private static final int MDR_MASK = 64;
    private static final int ADDR_MASK = 63;
    private static final int COND_1 = 0;
    private static final int COND_Z = 0x20000000;
    private static final int COND_NOT_Z = 0x40000000;
    private static final int COND_X = 0x60000000;
    private static final int BT_JUMP = 0;
    private static final int BT_MAP = 0x10000000;
    private static final int OPER_ARPC = 0x8000000;
    private static final int OPER_ARIN = 0x4000000;
    private static final int OPER_ARDT = 0x2000000;
    private static final int OPER_PCIN = 0x1000000;
    private static final int OPER_PCDT = 0x800000;
    private static final int OPER_DRM = 0x400000;
    private static final int OPER_DRAC = 0x200000;
    private static final int OPER_IRDR = 0x100000;
    private static final int OPER_RAC = 524288;
    private static final int OPER_ZALU = 262144;
    private static final int OPER_TRDR = 131072;
    private static final int OPER_ACDR = 65536;
    private static final int OPER_ACR = 32768;
    private static final int OPER_PLUS = 16384;
    private static final int OPER_MINU = 8192;
    private static final int OPER_ACIN = 4096;
    private static final int OPER_ACZO = 2048;
    private static final int OPER_AND = 1024;
    private static final int OPER_OR = 512;
    private static final int OPER_XOR = 256;
    private static final int OPER_NOT = 128;
    private static final int OPER_MDR = 64;
    private static final int ADDR_X = 63;
    private CPU cpu;
    private byte irMap;
    private byte addressMux;
    private byte addressRegister;
    private byte logicSelect;
    private byte conditionMuxSelect;
    private int currentOperations;
    private byte currentAddress;
    private boolean currentARPC;
    private boolean currentARIN;
    private boolean currentARDT;
    private boolean currentPCIN;
    private boolean currentPCDT;
    private boolean currentDRM;
    private boolean currentDRAC;
    private boolean currentIRDR;
    private boolean currentRAC;
    private boolean currentZALU;
    private boolean currentTRDR;
    private boolean currentACDR;
    private boolean currentACR;
    private boolean currentPLUS;
    private boolean currentMINU;
    private boolean currentACIN;
    private boolean currentACZO;
    private boolean currentAND;
    private boolean currentOR;
    private boolean currentXOR;
    private boolean currentNOT;
    private boolean currentMDR;
    private boolean conditionMuxOutput;
    private boolean logicBTInput;
    private boolean logicConditionInput;
    private boolean hw1Enabled;
    private boolean zEnabled;
    private boolean notZEnabled;
    private boolean clkEnabled;
    private boolean irPathEnabled;
    private boolean nextAddrEnabled;
    private boolean currAddrP1Enabled;
    private boolean irMapEnabled;
    private boolean[] oldDotEnabled = new boolean[4];
    private boolean[] currentDotEnabled = new boolean[4];
    private Point[] oldDotLocation = new Point[4];
    private Point[] currentDotLocation = new Point[4];
    private boolean skipAnimation;
    private boolean justUpdatedCurrentAddress;
    private int animationIndex;
    private boolean animUpdCurrAddrDone;
    private boolean animUpdCurrOperDone;
    private boolean animUpdCurrLogSelBTDone;
    private boolean animUpdCurrLogSelCondDone;
    private boolean animUpdAddrMuxDone;
    private boolean animUpdIRMapDone;
    private boolean active;
    private int[] microcode = new int[]{1, 0x8000002, 20971523, 2014314559, 0x5400005, 21102598, 0x2000007, 4194337, 88080393, 21102602, 0x200000B, 0x200022, 524289, -1, -1, -1, 32769, -1, -1, -1, 71303189, 4325398, 0x800001, -1, 1073741865, 71303194, 4325403, 0x800001, 0x2000002D, 71303198, 4325407, 0x800001, 278529, 65537, 65, -1, 270337, -1, -1, -1, 266241, 16777258, 0x1000001, -1, 264193, 16777262, 0x1000001, -1, 263169, -1, -1, -1, 262657, -1, -1, -1, 262401, -1, -1, -1, 262273, -1, -1};
    private Menu fileMenu;
    private MenuItem closeWindowMenuItem;
    private ScrollPane mcuCanvasScrollPane;
    private Canvas mcuCanvas = new Canvas(){
        private Image offScreenImage = null;

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return new Dimension(335, 460);
        }

        public void invalidate() {
            super.invalidate();
            this.offScreenImage = null;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.offScreenImage == null) {
                this.offScreenImage = this.createImage(335, 460);
            }
            Graphics graphics2 = this.offScreenImage.getGraphics();
            graphics2.setClip(graphics.getClip());
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, 335, 500);
            Font font = new Font("SansSerif", 1, 12);
            Font font2 = new Font("SansSerif", 0, 11);
            Font font3 = new Font("SansSerif", 0, 9);
            graphics2.setFont(font3);
            graphics2.setColor(Color.black);
            graphics2.drawRect(45, 95, 60, 60);
            graphics2.drawRect(45, 210, 60, 60);
            graphics2.drawString("S", 72, 265);
            graphics2.drawRect(125, 185, 140, 35);
            graphics2.drawRect(125, 260, 140, 60);
            graphics2.drawRect(125, 100, 140, 50);
            graphics2.drawRect(285, 152, 30, 30);
            graphics2.drawRect(125, 35, 50, 30);
            graphics2.drawLine(150, 65, 150, 100);
            graphics2.drawLine(150, 100, 145, 95);
            graphics2.drawLine(150, 100, 155, 95);
            graphics2.drawLine(195, 150, 195, 185);
            graphics2.drawLine(195, 185, 190, 180);
            graphics2.drawLine(195, 185, 200, 180);
            graphics2.drawLine(195, 220, 195, 260);
            graphics2.fillOval(194, 240, 4, 4);
            graphics2.drawLine(195, 260, 190, 255);
            graphics2.drawLine(195, 260, 200, 255);
            graphics2.drawLine(194, 242, 300, 242);
            graphics2.drawLine(300, 242, 300, 182);
            graphics2.drawLine(300, 182, 295, 187);
            graphics2.drawLine(300, 182, 305, 187);
            graphics2.drawLine(300, 152, 300, 85);
            graphics2.drawLine(300, 85, 240, 85);
            graphics2.drawLine(240, 85, 240, 100);
            graphics2.drawLine(240, 100, 235, 95);
            graphics2.drawLine(240, 100, 245, 95);
            graphics2.drawLine(75, 155, 75, 210);
            graphics2.drawLine(75, 155, 70, 160);
            graphics2.drawLine(75, 155, 80, 160);
            graphics2.drawString("Cond.", 132, 319);
            graphics2.drawString("BT", 170, 319);
            graphics2.drawString("mOPs", 195, 319);
            graphics2.drawString("ADDR", 230, 319);
            graphics2.drawLine(75, 270, 75, 350);
            graphics2.drawLine(75, 350, 145, 350);
            graphics2.drawLine(145, 350, 145, 320);
            graphics2.drawLine(75, 270, 70, 275);
            graphics2.drawLine(75, 270, 80, 275);
            graphics2.drawLine(175, 365, 175, 320);
            graphics2.drawLine(175, 365, 10, 365);
            graphics2.drawLine(10, 365, 10, 123);
            graphics2.drawLine(10, 123, 45, 123);
            graphics2.drawLine(45, 123, 40, 118);
            graphics2.drawLine(45, 123, 40, 128);
            graphics2.drawLine(105, 115, 125, 115);
            graphics2.drawLine(125, 115, 120, 110);
            graphics2.drawLine(125, 115, 120, 120);
            graphics2.drawLine(105, 140, 125, 140);
            graphics2.drawLine(125, 140, 120, 135);
            graphics2.drawLine(125, 140, 120, 145);
            graphics2.drawLine(208, 320, 208, 375);
            graphics2.drawLine(208, 375, 203, 370);
            graphics2.drawLine(208, 375, 213, 370);
            graphics2.drawLine(242, 365, 242, 320);
            graphics2.drawLine(242, 365, 325, 365);
            graphics2.drawLine(325, 365, 325, 65);
            graphics2.drawLine(325, 65, 195, 65);
            graphics2.drawLine(195, 65, 195, 100);
            graphics2.drawLine(195, 100, 190, 95);
            graphics2.drawLine(195, 100, 200, 95);
            graphics2.drawString("S1", 129, 120);
            graphics2.drawString("S0", 129, 144);
            this.paintIRPath(graphics2);
            this.paintAddressMuxSignals(graphics2);
            this.paintClock(graphics2);
            this.paintConditionMuxSignals(graphics2);
            this.paintCurrentSignals(graphics2);
            graphics2.setFont(font);
            graphics2.setColor(Color.black);
            graphics2.drawString("+1", 292, 172);
            graphics2.drawString("MAP", 138, 50);
            graphics2.drawString("REGISTER", 165, 202);
            graphics2.drawString("Microcode", 165, 274);
            graphics2.drawString("Memory", 171, 288);
            graphics2.drawString("MUX", 67, 243);
            graphics2.drawString("MUX", 183, 129);
            graphics2.drawString("Logic", 60, 130);
            graphics2.setFont(font2);
            this.paintIRMapValue(graphics2);
            this.paintAddressRegisterValue(graphics2);
            this.paintCurrentConditionValue(graphics2);
            this.paintCurrentBTValue(graphics2);
            this.paintCurrentNextAddressValue(graphics2);
            this.paintAddressMuxValue(graphics2);
            this.paintUpperLogicSelectValue(graphics2);
            this.paintLowerLogicSelectValue(graphics2);
            this.paintDots(graphics2);
            graphics.drawImage(this.offScreenImage, 0, 0, this);
            graphics2.dispose();
        }

        public void paintIRPath(Graphics graphics) {
            graphics.setColor(McodeControlUnit.this.irPathEnabled ? Color.red : Color.black);
            graphics.drawString("IR[3..0]00", 129, 15);
            graphics.drawLine(150, 20, 150, 35);
            graphics.drawLine(150, 35, 145, 30);
            graphics.drawLine(150, 35, 155, 30);
        }

        public void paintAddressMuxValue(Graphics graphics) {
            graphics.drawString(AssemblyInstruction.toNumberString(McodeControlUnit.this.addressMux, 2, 6), 178, 145);
        }

        public void paintUpperLogicSelectValue(Graphics graphics) {
            graphics.drawString(AssemblyInstruction.toNumberString((McodeControlUnit.this.logicSelect & 2) >> 1, 2, 1), 97, 120);
        }

        public void paintLowerLogicSelectValue(Graphics graphics) {
            graphics.drawString(AssemblyInstruction.toNumberString(McodeControlUnit.this.logicSelect & 1, 2, 1), 97, 144);
        }

        public void paintAddressRegisterValue(Graphics graphics) {
            graphics.drawString(AssemblyInstruction.toNumberString(McodeControlUnit.this.addressRegister, 2, 6), 178, 216);
        }

        public void paintCurrentNextAddressValue(Graphics graphics) {
            int n = McodeControlUnit.this.microcode[McodeControlUnit.this.currentAddress];
            int n2 = n & 0x3F;
            if (n2 == 63) {
                graphics.drawString("XXXXXX", 222, 308);
            } else {
                graphics.drawString(AssemblyInstruction.toNumberString(n2, 2, 6), 226, 308);
            }
        }

        public void paintCurrentBTValue(Graphics graphics) {
            int n = McodeControlUnit.this.microcode[McodeControlUnit.this.currentAddress];
            int n2 = n & 0x10000000;
            graphics.drawString(AssemblyInstruction.toNumberString(n2 >> 28, 2, 1), 173, 308);
        }

        public void paintCurrentConditionValue(Graphics graphics) {
            int n = McodeControlUnit.this.microcode[McodeControlUnit.this.currentAddress];
            int n2 = n & 0x60000000;
            if (n2 == 0x60000000) {
                graphics.drawString("XX", 138, 308);
            } else {
                graphics.drawString(AssemblyInstruction.toNumberString(n2 >> 29, 2, 2), 138, 308);
            }
        }

        public void paintIRMapValue(Graphics graphics) {
            graphics.drawString(AssemblyInstruction.toNumberString(McodeControlUnit.this.irMap, 2, 6), 133, 63);
        }

        public void paintCurrentSignals(Graphics graphics) {
            graphics.setColor(McodeControlUnit.this.currentARPC ? Color.red : Color.black);
            graphics.drawString("ARPC", 140, 385);
            graphics.setColor(McodeControlUnit.this.currentARIN ? Color.red : Color.black);
            graphics.drawString("ARIN", 140, 395);
            graphics.setColor(McodeControlUnit.this.currentARDT ? Color.red : Color.black);
            graphics.drawString("ARDT", 140, 405);
            graphics.setColor(McodeControlUnit.this.currentPCIN ? Color.red : Color.black);
            graphics.drawString("PCIN", 140, 415);
            graphics.setColor(McodeControlUnit.this.currentPCDT ? Color.red : Color.black);
            graphics.drawString("PCDT", 140, 425);
            graphics.setColor(McodeControlUnit.this.currentDRM ? Color.red : Color.black);
            graphics.drawString("DRM", 175, 385);
            graphics.setColor(McodeControlUnit.this.currentDRAC ? Color.red : Color.black);
            graphics.drawString("DRAC", 175, 395);
            graphics.setColor(McodeControlUnit.this.currentIRDR ? Color.red : Color.black);
            graphics.drawString("IRDR", 175, 405);
            graphics.setColor(McodeControlUnit.this.currentRAC ? Color.red : Color.black);
            graphics.drawString("RAC", 175, 415);
            graphics.setColor(McodeControlUnit.this.currentZALU ? Color.red : Color.black);
            graphics.drawString("ZALU", 175, 425);
            graphics.setColor(McodeControlUnit.this.currentTRDR ? Color.red : Color.black);
            graphics.drawString("TRDR", 175, 435);
            graphics.setColor(McodeControlUnit.this.currentACDR ? Color.red : Color.black);
            graphics.drawString("ACDR", 216, 385);
            graphics.setColor(McodeControlUnit.this.currentACR ? Color.red : Color.black);
            graphics.drawString("ACR", 216, 395);
            graphics.setColor(McodeControlUnit.this.currentPLUS ? Color.red : Color.black);
            graphics.drawString("PLUS", 216, 405);
            graphics.setColor(McodeControlUnit.this.currentMINU ? Color.red : Color.black);
            graphics.drawString("MINU", 216, 415);
            graphics.setColor(McodeControlUnit.this.currentACIN ? Color.red : Color.black);
            graphics.drawString("ACIN", 216, 425);
            graphics.setColor(McodeControlUnit.this.currentACZO ? Color.red : Color.black);
            graphics.drawString("ACZO", 216, 435);
            graphics.setColor(McodeControlUnit.this.currentAND ? Color.red : Color.black);
            graphics.drawString("AND", 252, 385);
            graphics.setColor(McodeControlUnit.this.currentOR ? Color.red : Color.black);
            graphics.drawString("OR", 252, 395);
            graphics.setColor(McodeControlUnit.this.currentXOR ? Color.red : Color.black);
            graphics.drawString("XOR", 252, 405);
            graphics.setColor(McodeControlUnit.this.currentNOT ? Color.red : Color.black);
            graphics.drawString("NOT", 252, 415);
            graphics.setColor(McodeControlUnit.this.currentMDR ? Color.red : Color.black);
            graphics.drawString("MDR", 252, 425);
        }

        public void paintConditionMuxSignals(Graphics graphics) {
            graphics.setColor(McodeControlUnit.this.hw1Enabled ? Color.red : Color.black);
            graphics.drawString("0", 49, 225);
            graphics.drawLine(45, 221, 31, 221);
            graphics.drawString("1", 24, 225);
            graphics.setColor(McodeControlUnit.this.zEnabled ? Color.red : Color.black);
            graphics.drawString("1", 49, 245);
            graphics.drawLine(45, 241, 31, 241);
            graphics.drawString("Z", 24, 245);
            graphics.setColor(McodeControlUnit.this.notZEnabled ? Color.red : Color.black);
            graphics.drawString("2", 49, 265);
            graphics.drawLine(45, 262, 31, 262);
            graphics.drawString("Z", 24, 265);
            graphics.drawString("/", 20, 265);
        }

        public void paintAddressMuxSignals(Graphics graphics) {
            graphics.setColor(McodeControlUnit.this.currAddrP1Enabled ? Color.red : Color.black);
            graphics.drawString("0", 239, 112);
            graphics.setColor(McodeControlUnit.this.nextAddrEnabled ? Color.red : Color.black);
            graphics.drawString("1", 195, 112);
            graphics.setColor(McodeControlUnit.this.irMapEnabled ? Color.red : Color.black);
            graphics.drawString("2", 148, 112);
        }

        public void paintClock(Graphics graphics) {
            graphics.setColor(McodeControlUnit.this.clkEnabled ? Color.red : Color.black);
            graphics.drawString("CLK", 132, 240);
            graphics.drawLine(140, 230, 140, 220);
            graphics.drawLine(140, 215, 137, 220);
            graphics.drawLine(140, 215, 143, 220);
        }

        public void paintDots(Graphics graphics) {
            graphics.setColor(Color.red);
            int n = 0;
            while (n < McodeControlUnit.this.currentDotLocation.length) {
                if (McodeControlUnit.this.currentDotEnabled[n]) {
                    graphics.fillRect(((McodeControlUnit)McodeControlUnit.this).currentDotLocation[n].x - 3, ((McodeControlUnit)McodeControlUnit.this).currentDotLocation[n].y - 3, 7, 7);
                }
                ++n;
            }
        }
    };

    public McodeControlUnit(CPU cPU, String string) {
        super(string);
        this.cpu = cPU;
        this.active = false;
        this.skipAnimation = false;
        this.currentDotEnabled[0] = false;
        this.currentDotEnabled[1] = false;
        this.currentDotEnabled[2] = false;
        this.currentDotEnabled[3] = false;
        this.reset();
        MenuBar menuBar = new MenuBar();
        this.fileMenu = new Menu("File");
        this.closeWindowMenuItem = new MenuItem("Close Window");
        this.closeWindowMenuItem.addActionListener(this);
        this.fileMenu.add(this.closeWindowMenuItem);
        menuBar.add(this.fileMenu);
        this.setMenuBar(menuBar);
        this.add(this.mcuCanvas);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                McodeControlUnit.this.setVisible(false);
            }
        });
        this.pack();
    }

    public boolean getSkipAnimation() {
        return this.skipAnimation;
    }

    public void setSkipAnimation(boolean bl) {
        this.skipAnimation = bl;
    }

    public void reset() {
        this.clear();
        this.addressRegister = 0;
        this.updateCurrentAddress();
        this.updateCurrentOperations();
        this.updateCurrentSignals();
        this.updateConditionMuxSelect();
        this.updateConditionMuxSignals();
        this.updateLogicBTInput();
        this.updateLogicConditionInput();
        this.updateLogicSelect();
        this.updateIRMap();
        this.updateAddressMuxSignals();
        this.updateAddressMux();
        this.justUpdatedCurrentAddress = false;
        this.animationIndex = 0;
        this.animUpdCurrAddrDone = false;
        this.animUpdCurrOperDone = false;
        this.animUpdCurrLogSelBTDone = false;
        this.animUpdCurrLogSelCondDone = false;
        this.animUpdAddrMuxDone = false;
        this.animUpdIRMapDone = false;
    }

    public void clear() {
        this.hw1Enabled = false;
        this.zEnabled = false;
        this.notZEnabled = false;
        this.clkEnabled = false;
        this.irPathEnabled = false;
        this.currAddrP1Enabled = false;
        this.nextAddrEnabled = false;
        this.irMapEnabled = false;
        this.currentARPC = false;
        this.currentARIN = false;
        this.currentARDT = false;
        this.currentPCIN = false;
        this.currentPCDT = false;
        this.currentDRM = false;
        this.currentDRAC = false;
        this.currentIRDR = false;
        this.currentRAC = false;
        this.currentZALU = false;
        this.currentTRDR = false;
        this.currentACDR = false;
        this.currentACR = false;
        this.currentPLUS = false;
        this.currentMINU = false;
        this.currentACIN = false;
        this.currentACZO = false;
        this.currentAND = false;
        this.currentOR = false;
        this.currentXOR = false;
        this.currentNOT = false;
        this.currentMDR = false;
        this.setDot(0, false, null);
        this.setDot(1, false, null);
        this.setDot(2, false, null);
        this.setDot(3, false, null);
    }

    public void canvasRepaint() {
        this.mcuCanvas.repaint();
    }

    public void canvasRepaint(int n) {
        this.mcuCanvas.repaint(n);
    }

    public void executeCycle() {
        if (this.skipAnimation || !this.active || !this.isShowing()) {
            this.animationIndex = 0;
            this.clear();
            this.cpu.setCurrentCLK(true);
            this.clkEnabled = true;
            if (!this.justUpdatedCurrentAddress) {
                this.updateAddressRegister();
                this.updateCurrentAddress();
            }
            this.updateCurrentOperations();
            this.updateCurrentSignals();
            this.updateConditionMuxSelect();
            this.updateConditionMuxSignals();
            this.updateLogicBTInput();
            this.updateLogicConditionInput();
            this.updateLogicSelect();
            this.updateAddressMuxSignals();
            this.updateAddressMux();
            this.animUpdCurrAddrDone = false;
            this.animUpdCurrOperDone = false;
            this.animUpdCurrLogSelBTDone = false;
            this.animUpdCurrLogSelCondDone = false;
            this.animUpdAddrMuxDone = false;
            this.justUpdatedCurrentAddress = false;
            this.cpu.setStallAnimationCounter(false);
        } else {
            this.cpu.setStallAnimationCounter(!this.executeAnimationCycle());
            this.canvasRepaint();
        }
    }

    public byte updateIRMap() {
        this.irMap = CPU.theBox.IRint == 255L ? (byte)0 : (byte)((CPU.theBox.IRint & 0xFL) << 2);
        return this.irMap;
    }

    public byte updateConditionMuxSelect() {
        int n = this.microcode[this.currentAddress];
        int n2 = n & 0x60000000;
        this.conditionMuxSelect = n2 == 0 ? (byte)0 : (n2 == 0x20000000 ? (byte)1 : (n2 == 0x40000000 ? (byte)2 : (byte)-1));
        return this.conditionMuxSelect;
    }

    public void updateConditionMuxSignals() {
        if (this.conditionMuxSelect == 0) {
            this.hw1Enabled = true;
            this.zEnabled = false;
            this.notZEnabled = false;
        } else if (this.conditionMuxSelect == 1) {
            this.hw1Enabled = false;
            this.zEnabled = true;
            this.notZEnabled = false;
        } else if (this.conditionMuxSelect == 2) {
            this.hw1Enabled = false;
            this.zEnabled = false;
            this.notZEnabled = true;
        } else {
            this.hw1Enabled = false;
            this.zEnabled = false;
            this.notZEnabled = false;
        }
    }

    public boolean updateLogicBTInput() {
        int n = this.microcode[this.currentAddress];
        int n2 = n & 0x10000000;
        this.logicBTInput = n2 != 0;
        return this.logicBTInput;
    }

    public boolean updateLogicConditionInput() {
        this.logicConditionInput = this.conditionMuxSelect == 0 ? true : (this.conditionMuxSelect == 1 ? CPU.theBox.Zint != 0L : (this.conditionMuxSelect == 2 ? CPU.theBox.Zint == 0L : false));
        return this.logicConditionInput;
    }

    public byte updateLogicSelect() {
        if (!this.logicBTInput && !this.logicConditionInput) {
            this.logicSelect = 0;
        } else if (!this.logicBTInput && this.logicConditionInput) {
            this.logicSelect = 1;
        } else if (this.logicBTInput) {
            this.logicSelect = (byte)2;
        }
        return this.logicSelect;
    }

    public void updateAddressMuxSignals() {
        if (this.logicSelect == 0) {
            this.currAddrP1Enabled = true;
            this.nextAddrEnabled = false;
            this.irMapEnabled = false;
        } else if (this.logicSelect == 1) {
            this.currAddrP1Enabled = false;
            this.nextAddrEnabled = true;
            this.irMapEnabled = false;
        } else if (this.logicSelect == 2) {
            this.currAddrP1Enabled = false;
            this.nextAddrEnabled = false;
            this.irMapEnabled = true;
        }
    }

    public byte updateAddressMux() {
        if (this.logicSelect == 0) {
            this.addressMux = (byte)(this.addressRegister + 1);
        } else if (this.logicSelect == 1) {
            int n = this.microcode[this.currentAddress];
            int n2 = n & 0x3F;
            this.addressMux = (byte)n2;
        } else if (this.logicSelect == 2) {
            int n = this.microcode[this.currentAddress];
            int n3 = n & 0x3F;
            this.addressMux = this.irMap;
        }
        return this.addressMux;
    }

    public byte updateAddressRegister() {
        this.addressRegister = this.addressMux;
        return this.addressRegister;
    }

    public byte updateCurrentAddress() {
        this.currentAddress = this.addressRegister;
        return this.currentAddress;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeWindowMenuItem) {
            this.setVisible(false);
        }
    }

    public int updateCurrentOperations() {
        int n = this.microcode[this.currentAddress];
        this.currentOperations = n & 0xFFFFFC0;
        this.currentARPC = (this.currentOperations & 0x8000000) == 0x8000000;
        this.currentARIN = (this.currentOperations & 0x4000000) == 0x4000000;
        this.currentARDT = (this.currentOperations & 0x2000000) == 0x2000000;
        this.currentPCIN = (this.currentOperations & 0x1000000) == 0x1000000;
        this.currentPCDT = (this.currentOperations & 0x800000) == 0x800000;
        this.currentDRM = (this.currentOperations & 0x400000) == 0x400000;
        this.currentDRAC = (this.currentOperations & 0x200000) == 0x200000;
        this.currentIRDR = (this.currentOperations & 0x100000) == 0x100000;
        this.currentRAC = (this.currentOperations & 0x80000) == 524288;
        this.currentZALU = (this.currentOperations & 0x40000) == 262144;
        this.currentTRDR = (this.currentOperations & 0x20000) == 131072;
        this.currentACDR = (this.currentOperations & 0x10000) == 65536;
        this.currentACR = (this.currentOperations & 0x8000) == 32768;
        this.currentPLUS = (this.currentOperations & 0x4000) == 16384;
        this.currentMINU = (this.currentOperations & 0x2000) == 8192;
        this.currentACIN = (this.currentOperations & 0x1000) == 4096;
        this.currentACZO = (this.currentOperations & 0x800) == 2048;
        this.currentAND = (this.currentOperations & 0x400) == 1024;
        this.currentOR = (this.currentOperations & 0x200) == 512;
        this.currentXOR = (this.currentOperations & 0x100) == 256;
        this.currentNOT = (this.currentOperations & 0x80) == 128;
        this.currentMDR = (this.currentOperations & 0x40) == 64;
        return this.currentOperations;
    }

    public void updateCurrentSignals() {
        this.cpu.setCurrentARLOAD(this.currentARPC | this.currentARDT);
        this.cpu.setCurrentARINC(this.currentARIN);
        this.cpu.setCurrentPCLOAD(this.currentPCDT);
        this.cpu.setCurrentPCINC(this.currentPCIN);
        this.cpu.setCurrentPCBUS(this.currentARPC);
        this.cpu.setCurrentDRHBUS(this.currentARDT | this.currentPCDT);
        this.cpu.setCurrentDRLBUS(this.currentACDR | this.currentMDR);
        this.cpu.setCurrentDRLOAD(this.currentDRM | this.currentDRAC);
        this.cpu.setCurrentTRLOAD(this.currentTRDR);
        this.cpu.setCurrentTRBUS(this.currentARDT | this.currentPCDT);
        this.cpu.setCurrentIRLOAD(this.currentIRDR);
        this.cpu.setCurrentRLOAD(this.currentRAC);
        this.cpu.setCurrentRBUS(this.currentACR | this.currentPLUS | this.currentMINU | this.currentAND | this.currentOR | this.currentXOR);
        this.cpu.setCurrentACLOAD(this.currentACDR | this.currentACR | this.currentPLUS | this.currentMINU | this.currentACIN | this.currentACZO | this.currentAND | this.currentOR | this.currentXOR | this.currentNOT);
        this.cpu.setCurrentACBUS(this.currentDRAC | this.currentRAC);
        this.cpu.setCurrentALUS(this.currentACDR | this.currentACR | this.currentPLUS | this.currentMINU | this.currentACIN | this.currentACZO | this.currentAND | this.currentOR | this.currentXOR | this.currentNOT);
        this.cpu.setCurrentZLOAD(this.currentPLUS | this.currentMINU | this.currentACIN | this.currentACZO | this.currentAND | this.currentOR | this.currentXOR | this.currentNOT);
        this.cpu.setCurrentWRITE(this.currentMDR);
        this.cpu.setCurrentBUSMEM(this.currentMDR);
        this.cpu.setCurrentREAD(this.currentDRM);
        this.cpu.setCurrentMEMBUS(this.currentDRM);
    }

    public boolean executeAnimationCycle() {
        if (!this.animUpdCurrAddrDone) {
            this.animUpdCurrAddrDone = this.animUpdCurrAddr();
            System.out.println("DEBUG ==> animUpdCurrAddrDone: " + this.animUpdCurrAddrDone);
        }
        if (!this.animUpdCurrOperDone) {
            this.animUpdCurrOperDone = this.animUpdCurrOper();
            System.out.println("DEBUG ==> animUpdCurrOperDone: " + this.animUpdCurrOperDone);
        }
        if (!this.animUpdCurrLogSelBTDone) {
            this.animUpdCurrLogSelBTDone = this.animUpdCurrLogSelBT();
            System.out.println("DEBUG ==> animUpdCurrLogSelBTDone: " + this.animUpdCurrLogSelBTDone);
        }
        if (!this.animUpdCurrLogSelCondDone) {
            this.animUpdCurrLogSelCondDone = this.animUpdCurrLogSelCond();
            System.out.println("DEBUG ==> animUpdCurrLogSelCondDone: " + this.animUpdCurrLogSelCondDone);
        }
        if (!this.animUpdAddrMuxDone) {
            this.animUpdAddrMuxDone = this.animUpdAddrMux();
            System.out.println("DEBUG ==> animUpdAddrMuxDone: " + this.animUpdAddrMuxDone);
        }
        if (this.animUpdCurrAddrDone && this.animUpdCurrOperDone && this.animUpdCurrLogSelBTDone && this.animUpdCurrLogSelCondDone && this.animUpdAddrMuxDone) {
            this.justUpdatedCurrentAddress = false;
            this.animationIndex = 0;
            this.animUpdCurrAddrDone = false;
            this.animUpdCurrOperDone = false;
            this.animUpdCurrLogSelBTDone = false;
            this.animUpdCurrLogSelCondDone = false;
            this.animUpdAddrMuxDone = false;
            return true;
        }
        ++this.animationIndex;
        return false;
    }

    public boolean animUpdCurrAddr() {
        if (this.animationIndex == 0) {
            Point point = new Point(195, 150);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 1) {
            Point point = new Point(195, 185);
            this.setDot(0, true, point);
            this.cpu.setCurrentCLK(true);
            this.clkEnabled = true;
            this.updateAddressRegister();
        } else if (this.animationIndex == 2) {
            Point point = new Point(195, 220);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 3) {
            Point point = new Point(195, 260);
            this.setDot(0, true, point);
            this.updateCurrentAddress();
            this.justUpdatedCurrentAddress = true;
        } else if (this.animationIndex == 4) {
            this.setDot(0, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdCurrOper() {
        if (this.animationIndex == 4) {
            Point point = new Point(208, 320);
            this.setDot(3, true, point);
        } else if (this.animationIndex == 5) {
            Point point = new Point(208, 375);
            this.setDot(3, true, point);
            this.updateCurrentOperations();
            this.updateCurrentSignals();
        } else if (this.animationIndex == 6) {
            this.setDot(3, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdCurrLogSelBT() {
        if (this.animationIndex == 4) {
            Point point = new Point(175, 320);
            this.setDot(1, true, point);
        } else if (this.animationIndex == 5) {
            Point point = new Point(175, 365);
            this.setDot(1, true, point);
        } else if (this.animationIndex == 6) {
            Point point = new Point(10, 365);
            this.setDot(1, true, point);
        } else if (this.animationIndex == 7) {
            Point point = new Point(10, 244);
            this.setDot(1, true, point);
        } else if (this.animationIndex == 8) {
            Point point = new Point(10, 123);
            this.setDot(1, true, point);
        } else if (this.animationIndex == 9) {
            Point point = new Point(45, 123);
            this.setDot(1, true, point);
            this.updateLogicBTInput();
            this.updateLogicSelect();
            this.updateAddressMuxSignals();
        } else if (this.animationIndex == 10) {
            this.setDot(1, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdCurrLogSelCond() {
        if (this.animationIndex == 4) {
            Point point = new Point(145, 320);
            this.setDot(2, true, point);
        } else if (this.animationIndex == 5) {
            Point point = new Point(145, 350);
            this.setDot(2, true, point);
        } else if (this.animationIndex == 6) {
            Point point = new Point(75, 350);
            this.setDot(2, true, point);
        } else if (this.animationIndex == 7) {
            Point point = new Point(75, 270);
            this.setDot(2, true, point);
            this.updateConditionMuxSelect();
            this.updateConditionMuxSignals();
        } else if (this.animationIndex == 8) {
            Point point = new Point(75, 210);
            this.setDot(2, true, point);
        } else if (this.animationIndex == 9) {
            Point point = new Point(75, 155);
            this.setDot(2, true, point);
            this.updateLogicConditionInput();
            this.updateLogicSelect();
            this.updateAddressMuxSignals();
        } else if (this.animationIndex == 10) {
            this.setDot(2, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdAddrMux() {
        if (this.logicSelect == 0) {
            return this.animUpdAddrMuxCAP1();
        }
        if (this.logicSelect == 1) {
            return this.animUpdAddrMuxMC();
        }
        return this.animUpdAddrMuxIR();
    }

    public boolean animUpdAddrMuxCAP1() {
        if (this.animationIndex == 10) {
            Point point = new Point(195, 220);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 11) {
            Point point = new Point(195, 242);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 12) {
            Point point = new Point(300, 242);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 13) {
            Point point = new Point(300, 182);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 14) {
            Point point = new Point(300, 152);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 15) {
            Point point = new Point(300, 85);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 16) {
            Point point = new Point(240, 85);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 17) {
            Point point = new Point(240, 100);
            this.setDot(0, true, point);
            this.updateAddressMux();
        } else if (this.animationIndex == 18) {
            this.setDot(0, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdAddrMuxMC() {
        if (this.animationIndex == 10) {
            Point point = new Point(242, 320);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 11) {
            Point point = new Point(242, 365);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 12) {
            Point point = new Point(325, 365);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 13) {
            Point point = new Point(325, 65);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 14) {
            Point point = new Point(195, 65);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 15) {
            Point point = new Point(195, 100);
            this.setDot(0, true, point);
            this.updateAddressMux();
        } else if (this.animationIndex == 16) {
            this.setDot(0, false, null);
            return true;
        }
        return false;
    }

    public boolean animUpdAddrMuxIR() {
        if (this.animationIndex == 10) {
            Point point = new Point(150, 65);
            this.setDot(0, true, point);
        } else if (this.animationIndex == 11) {
            Point point = new Point(150, 100);
            this.setDot(0, true, point);
            this.updateAddressMux();
        } else if (this.animationIndex == 12) {
            this.setDot(0, false, null);
            return true;
        }
        return false;
    }

    public void executeUpdIRMapCycle() {
        if (this.animationIndex == 0) {
            this.animationIndex = 9;
        }
        if (!this.animUpdIRMapDone) {
            this.animUpdIRMapDone = this.animUpdIRMap();
        }
        if (!this.animUpdAddrMuxDone) {
            this.animUpdAddrMuxDone = this.animUpdAddrMuxIR();
        }
        if (this.animUpdIRMapDone && this.animUpdAddrMuxDone) {
            this.animUpdIRMapDone = false;
            this.animUpdAddrMuxDone = false;
            this.animationIndex = 0;
        } else {
            ++this.animationIndex;
        }
        if (!this.skipAnimation) {
            this.canvasRepaint();
        }
    }

    public boolean animUpdIRMap() {
        if (this.animationIndex == 9) {
            this.irPathEnabled = true;
            this.updateIRMap();
        } else if (this.animationIndex == 10) {
            this.irPathEnabled = false;
            return true;
        }
        return false;
    }

    public void setDot(int n, boolean bl, Point point) {
        this.oldDotEnabled[n] = this.currentDotEnabled[n];
        this.currentDotEnabled[n] = bl;
        if (bl) {
            this.oldDotLocation[n] = this.currentDotLocation[n];
            this.currentDotLocation[n] = point;
        }
    }

    public void setCLKEnabled(boolean bl) {
        this.clkEnabled = bl;
    }

    public boolean getCLKEnabled() {
        return this.clkEnabled;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }
}

