/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Memory
extends Frame
implements AdjustmentListener,
ActionListener {
    private int scrollvalue = 0;
    private int showType = 0;
    private int top;
    private int bottom;
    private Scrollbar vert;
    private Menu editMenu;
    private MenuItem editMemoryMenuItem;
    private MenuItem fillMemoryMenuItem;
    private MenuItem clearMemoryMenuItem;
    private CPU CPUBox;
    private EditMemoryDialog editMemory;
    private FillMemoryDialog fillMemory;
    private short[] contents = new short[65536];
    public static final int MEMORY_SIZE = 65536;

    public Memory(Frame frame, String string) {
        super(string);
        this.CPUBox = (CPU)frame;
        this.clear();
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("Type");
        menu.add(new MenuItem("View memory in HEX"));
        menu.add(new MenuItem("View memory in BINARY"));
        this.editMemoryMenuItem = new MenuItem("Edit Memory");
        this.editMemoryMenuItem.addActionListener(this);
        this.fillMemoryMenuItem = new MenuItem("Fill Memory");
        this.fillMemoryMenuItem.addActionListener(this);
        this.clearMemoryMenuItem = new MenuItem("Clear Memory");
        this.clearMemoryMenuItem.addActionListener(this);
        this.editMenu = new Menu("Edit");
        this.editMenu.add(this.editMemoryMenuItem);
        this.editMenu.add(this.fillMemoryMenuItem);
        this.editMenu.add(this.clearMemoryMenuItem);
        Menu menu2 = new Menu("View");
        menu2.add(new MenuItem("Address 0000h - 07FFh (0 - 2047)"));
        menu2.add(new MenuItem("Address 0800h - 0FFFh (2048 - 4095)"));
        menu2.add(new MenuItem("Address 1000h - 17FFh (4096 - 6143)"));
        menu2.add(new MenuItem("Address 1800h - 1FFFh (6144 - 8191)"));
        menu2.add(new MenuItem("Address 2000h - 27FFh (8192 - 10239)"));
        menu2.add(new MenuItem("Address 28FFh - 2FFFh (10240 - 12287)"));
        menu2.add(new MenuItem("Address 3000h - 37FFh (12288 - 14335)"));
        menu2.add(new MenuItem("Address 3800h - 3FFFh (14336 - 16383)"));
        menu2.add(new MenuItem("Address 4000h - 47FFh (16384 - 18431)"));
        menu2.add(new MenuItem("Address 4800h - 4FFFh (18432 - 20479)"));
        menu2.add(new MenuItem("Address 5000h - 57FFh (20480 - 22527)"));
        menu2.add(new MenuItem("Address 5800h - 5FFFh (22528 - 24575)"));
        menu2.add(new MenuItem("Address 6000h - 67FFh (24576 - 26623)"));
        menu2.add(new MenuItem("Address 6800h - 6FFFh (26624 - 28671)"));
        menu2.add(new MenuItem("Address 7000h - 77FFh (28672 - 30719)"));
        menu2.add(new MenuItem("Address 7800h - 7FFFh (30720 - 32767)"));
        menu2.add(new MenuItem("Address 8000h - 87FFh (32768 - 34815)"));
        menu2.add(new MenuItem("Address 8800h - 8FFFh (34816 - 36863)"));
        menu2.add(new MenuItem("Address 9000h - 97FFh (36864 - 38911)"));
        menu2.add(new MenuItem("Address 9800h - 9FFFh (38912 - 40959)"));
        menu2.add(new MenuItem("Address A000h - A7FFh (40960 - 43007)"));
        menu2.add(new MenuItem("Address A800h - AFFFh (43008 - 45055)"));
        menu2.add(new MenuItem("Address B000h - B7FFh (45056 - 47103)"));
        menu2.add(new MenuItem("Address B800h - BFFFh (47104 - 49151)"));
        menu2.add(new MenuItem("Address C000h - C7FFh (49152 - 51199)"));
        menu2.add(new MenuItem("Address C800h - CFFFh (51200 - 53247)"));
        menu2.add(new MenuItem("Address D000h - D7FFh (53248 - 55295)"));
        menu2.add(new MenuItem("Address D800h - DFFFh (55296 - 57343)"));
        menu2.add(new MenuItem("Address E000h - E7FFh (57344 - 59391)"));
        menu2.add(new MenuItem("Address E800h - EFFFh (59392 - 61439)"));
        menu2.add(new MenuItem("Address F000h - F7FFh (61440 - 63487)"));
        menu2.add(new MenuItem("Address F800h - FFFFh (63488 - 65535)"));
        menu2.addSeparator();
        menu2.add(new MenuItem("Close Window"));
        menuBar.add(menu2);
        menuBar.add(this.editMenu);
        menuBar.add(menu);
        this.vert = new Scrollbar(1, 0, 0, 0, 669);
        this.add("East", this.vert);
        this.vert.addAdjustmentListener(this);
        this.top = 0;
        this.bottom = 2048;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Memory.this.setVisible(false);
            }
        });
        this.setSize(315, 295);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scrollvalue = 15 * this.vert.getValue();
        this.repaint();
    }

    public boolean action(Event event, Object object) {
        if (object.equals("Address 0000h - 07FFh (0 - 2047)")) {
            this.top = 0;
            this.bottom = 2048;
            this.repaint();
            return true;
        }
        if (object.equals("Address 0800h - 0FFFh (2048 - 4095)")) {
            this.top = 2048;
            this.bottom = 4096;
            this.repaint();
            return true;
        }
        if (object.equals("Address 1000h - 17FFh (4096 - 6143)")) {
            this.top = 4096;
            this.bottom = 6144;
            this.repaint();
            return true;
        }
        if (object.equals("Address 1800h - 1FFFh (6144 - 8191)")) {
            this.top = 6144;
            this.bottom = 8192;
            this.repaint();
            return true;
        }
        if (object.equals("Address 2000h - 27FFh (8192 - 10239)")) {
            this.top = 8192;
            this.bottom = 10240;
            this.repaint();
            return true;
        }
        if (object.equals("Address 28FFh - 2FFFh (10240 - 12287)")) {
            this.top = 10240;
            this.bottom = 12288;
            this.repaint();
            return true;
        }
        if (object.equals("Address 3000h - 37FFh (12288 - 14335)")) {
            this.top = 12288;
            this.bottom = 14336;
            this.repaint();
            return true;
        }
        if (object.equals("Address 3800h - 3FFFh (14336 - 16383)")) {
            this.top = 14336;
            this.bottom = 16384;
            this.repaint();
            return true;
        }
        if (object.equals("Address 4000h - 47FFh (16384 - 18431)")) {
            this.top = 16384;
            this.bottom = 18432;
            this.repaint();
            return true;
        }
        if (object.equals("Address 4800h - 4FFFh (18432 - 20479)")) {
            this.top = 18432;
            this.bottom = 20480;
            this.repaint();
            return true;
        }
        if (object.equals("Address 5000h - 57FFh (20480 - 22527)")) {
            this.top = 20480;
            this.bottom = 22528;
            this.repaint();
            return true;
        }
        if (object.equals("Address 5800h - 5FFFh (22528 - 24575)")) {
            this.top = 22528;
            this.bottom = 24576;
            this.repaint();
            return true;
        }
        if (object.equals("Address 6000h - 67FFh (24576 - 26623)")) {
            this.top = 24576;
            this.bottom = 26624;
            this.repaint();
            return true;
        }
        if (object.equals("Address 6800h - 6FFFh (26624 - 28671)")) {
            this.top = 26624;
            this.bottom = 28672;
            this.repaint();
            return true;
        }
        if (object.equals("Address 7000h - 77FFh (28672 - 30719)")) {
            this.top = 28672;
            this.bottom = 30720;
            this.repaint();
            return true;
        }
        if (object.equals("Address 7800h - 7FFFh (30720 - 32767)")) {
            this.top = 30720;
            this.bottom = 32768;
            this.repaint();
            return true;
        }
        if (object.equals("Address 8000h - 87FFh (32768 - 34815)")) {
            this.top = 32768;
            this.bottom = 34816;
            this.repaint();
            return true;
        }
        if (object.equals("Address 8800h - 8FFFh (34816 - 36863)")) {
            this.top = 34816;
            this.bottom = 36864;
            this.repaint();
            return true;
        }
        if (object.equals("Address 9000h - 97FFh (36864 - 38911)")) {
            this.top = 36864;
            this.bottom = 38912;
            this.repaint();
            return true;
        }
        if (object.equals("Address 9800h - 9FFFh (38912 - 40959)")) {
            this.top = 38912;
            this.bottom = 40960;
            this.repaint();
            return true;
        }
        if (object.equals("Address A000h - A7FFh (40960 - 43007)")) {
            this.top = 40960;
            this.bottom = 43008;
            this.repaint();
            return true;
        }
        if (object.equals("Address A800h - AFFFh (43008 - 45055)")) {
            this.top = 43008;
            this.bottom = 45056;
            this.repaint();
            return true;
        }
        if (object.equals("Address B000h - B7FFh (45056 - 47103)")) {
            this.top = 45056;
            this.bottom = 47104;
            this.repaint();
            return true;
        }
        if (object.equals("Address B800h - BFFFh (47104 - 49151)")) {
            this.top = 47104;
            this.bottom = 49152;
            this.repaint();
            return true;
        }
        if (object.equals("Address C000h - C7FFh (49152 - 51199)")) {
            this.top = 49152;
            this.bottom = 51200;
            this.repaint();
            return true;
        }
        if (object.equals("Address C800h - CFFFh (51200 - 53247)")) {
            this.top = 51200;
            this.bottom = 53248;
            this.repaint();
            return true;
        }
        if (object.equals("Address D000h - D7FFh (53248 - 55295)")) {
            this.top = 53248;
            this.bottom = 55296;
            this.repaint();
            return true;
        }
        if (object.equals("Address D800h - DFFFh (55296 - 57343)")) {
            this.top = 55296;
            this.bottom = 57344;
            this.repaint();
            return true;
        }
        if (object.equals("Address E000h - E7FFh (57344 - 59391)")) {
            this.top = 57344;
            this.bottom = 59392;
            this.repaint();
            return true;
        }
        if (object.equals("Address E800h - EFFFh (59392 - 61439)")) {
            this.top = 59392;
            this.bottom = 61440;
            this.repaint();
            return true;
        }
        if (object.equals("Address F000h - F7FFh (61440 - 63487)")) {
            this.top = 61440;
            this.bottom = 63488;
            this.repaint();
            return true;
        }
        if (object.equals("Address F800h - FFFFh (63488 - 65535)")) {
            this.top = 63488;
            this.bottom = 65536;
            this.repaint();
            return true;
        }
        if (object.equals("Close Window")) {
            this.setVisible(false);
            return true;
        }
        if (object.equals("View memory in HEX")) {
            this.showType = 1;
            this.repaint();
            return true;
        }
        if (object.equals("View memory in BINARY")) {
            this.showType = 0;
            this.repaint();
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.editMemoryMenuItem) {
            this.editMemory = new EditMemoryDialog(this, "Edit Memory", true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.editMemory.getSize();
            Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.editMemory.setLocation(point);
            this.editMemory.setVisible(true);
        } else if (object == this.fillMemoryMenuItem) {
            this.fillMemory = new FillMemoryDialog(this, "Fill Memory", true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.fillMemory.getSize();
            Point point = new Point((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
            this.fillMemory.setLocation(point);
            this.fillMemory.setVisible(true);
        } else if (object == this.clearMemoryMenuItem) {
            this.clear();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Font font = new Font("SansSerif", 1, 11);
        Font font2 = new Font("SansSerif", 0, 11);
        boolean bl = this.showType == 0;
        int n = this.top;
        while (n < this.bottom) {
            int n2 = 5 * n - this.scrollvalue + 65 - 5 * this.top;
            int n3 = bl ? 2 : 16;
            int n4 = bl ? 4 : 1;
            graphics.setFont(font);
            graphics.drawString(n + ":", 5, n2);
            int n5 = 0;
            while (n5 < 4) {
                long l = (this.contents[n + n5] & 0xF0) >> 4;
                long l2 = this.contents[n + n5] & 0xF;
                if (n + n5 == this.CPUBox.simulationStartNumber) {
                    graphics.setFont(font);
                } else {
                    graphics.setFont(font2);
                }
                graphics.drawString(AssemblyInstruction.toNumberString(l, n3, n4).toUpperCase() + "  " + AssemblyInstruction.toNumberString(l2, n3, n4).toUpperCase(), 47 + 62 * n5, n2);
                ++n5;
            }
            n += 4;
        }
    }

    public void clear() {
        int n = 0;
        while (n < 65536) {
            this.contents[n] = 0;
            ++n;
        }
    }

    public void dispose() {
        this.editMemory.dispose();
        this.fillMemory.dispose();
        super.dispose();
    }

    public short read(int n) {
        if (n < 0 || n >= 65536) {
            return -1;
        }
        return this.contents[n];
    }

    public boolean write(int n, short s) {
        if (n < 0 || n >= 65536 || s < 0 || s > 255) {
            return false;
        }
        this.contents[n] = s;
        return true;
    }

    public String[] readBinaryNybbleStringArray(int n) {
        return Memory.toBinaryNybbleStringArray(this.read(n));
    }

    public boolean writeBinaryNybbleStringArray(int n, String[] stringArray) {
        short s = Memory.fromBinaryNybbleStringArray(stringArray);
        return this.write(n, s);
    }

    public static short fromBinaryNybbleStringArray(String[] stringArray) {
        if (stringArray != null && stringArray.length == 2) {
            try {
                int n = Integer.valueOf(stringArray[0], 2);
                int n2 = Integer.valueOf(stringArray[1], 2);
                return (short)(n * 16 + n2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static String[] toBinaryNybbleStringArray(short s) {
        if (s >= 0 && s <= 255) {
            String string = AssemblyInstruction.toNumberString(s / 16, 2, 4);
            String string2 = AssemblyInstruction.toNumberString(s % 16, 2, 4);
            String[] stringArray = new String[]{string, string2};
            return stringArray;
        }
        return null;
    }

    public void disableComponents() {
        if (this.editMemory != null) {
            this.editMemory.dispose();
        }
        if (this.fillMemory != null) {
            this.fillMemory.dispose();
        }
        this.editMenu.setEnabled(false);
        this.editMemoryMenuItem.setEnabled(false);
        this.fillMemoryMenuItem.setEnabled(false);
        this.clearMemoryMenuItem.setEnabled(false);
    }

    public void enableComponents() {
        this.editMenu.setEnabled(true);
        this.editMemoryMenuItem.setEnabled(true);
        this.fillMemoryMenuItem.setEnabled(true);
        this.clearMemoryMenuItem.setEnabled(true);
    }
}

