import java.awt.*;
import java.awt.event.*;

public
class AssemblyResultsDialog
   extends Dialog
   implements ActionListener
{

   public AssemblyResultsDialog( Frame parent, String title, boolean modal,
      AssemblyResults results )
   {
      super( parent, title, modal );

      AssemblyError[] errors = results.getErrors();

      setLayout( new GridBagLayout() );

      GridBagConstraints gbc = new GridBagConstraints();

      if ( ( errors == null ) || ( errors.length == 0 ) )
      {
         Label successLabel = new Label( "Assembly successful.", Label.
            CENTER );

         successLabel.setFont( new Font( "SansSerif", Font.BOLD, 12 ) );

         gbc.anchor = GridBagConstraints.CENTER;
         gbc.fill = GridBagConstraints.NONE;
         gbc.insets = new Insets( 5, 5, 5, 5 );
         gbc.weightx = 0;
         gbc.weighty = 0;
         gbc.gridx = 0;
         gbc.gridy = 0;
         gbc.gridwidth = GridBagConstraints.REMAINDER;
         gbc.gridheight = 2;

         add( successLabel, gbc );

         okButton = new Button( "OK" );

         gbc.gridx = 0;
         gbc.gridy = 2;
         gbc.gridwidth = GridBagConstraints.REMAINDER;
         gbc.gridheight = GridBagConstraints.REMAINDER;

         add( okButton, gbc );

         okButton.addActionListener( this );
      }
      else
      {
         Label errorLabel = new Label( "There are " + errors.length +
            " error(s):", Label.CENTER );
        
         errorLabel.setFont( new Font( "SansSerif", Font.BOLD, 12 ) );

         gbc.anchor = GridBagConstraints.CENTER;
         gbc.fill = GridBagConstraints.NONE;
         gbc.insets = new Insets( 5, 5, 5, 5 );
         gbc.weightx = 0;
         gbc.weighty = 0;
         gbc.gridx = 0;
         gbc.gridy = 0;
         gbc.gridwidth = GridBagConstraints.REMAINDER;
         gbc.gridheight = 2;

         add( errorLabel, gbc );

         List errorList = new List( 5 );

         for ( int index = 0; index < errors.length; index++ )
         {
            AssemblyError err = errors[ index ];

            errorList.add( "Line " + err.getLineNumber() + ": " + err.
               getString() );
         }

         gbc.gridx = 0;
         gbc.gridy = 2;
         gbc.gridwidth = GridBagConstraints.REMAINDER;
         gbc.gridheight = 9;

         add( errorList, gbc );

         okButton = new Button( "OK" );

         gbc.gridx = 0;
         gbc.gridy = 11;
         gbc.gridwidth = GridBagConstraints.REMAINDER;
         gbc.gridheight = GridBagConstraints.REMAINDER;

         add( okButton, gbc );
         okButton.addActionListener( this );
      }

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  dispose();
               }

            }

         );

      setResizable( false );
      pack();
   }

   public void actionPerformed( ActionEvent evt )
   {
      Object eventSource = evt.getSource();

      if ( eventSource == okButton )
      {
         dispose();
      }

   }

   private Button okButton;
}


