import java.io.*;
import java.util.*;

public
class AssemblySourceLine
{

   public AssemblySourceLine( String source, SubstringRange range, int
      line )
   {
      this( source, range, line, -1 );
   }

   public AssemblySourceLine( String source, SubstringRange range, int
      line, int addr )
   {
      sourceString = source;
      sourceSubstringRange = new SubstringRange( range );
      setLineNumber( line );
      setAddress( addr );

      StreamTokenizer parser = new StreamTokenizer( new StringReader(
         toString() ) );

      parser.resetSyntax();
      parser.wordChars( '\u0021', '\uffff' );
      parser.whitespaceChars( '\u0000', '\u0020' );
      parser.commentChar( ';' );

      Vector tokenVector = new Vector();
      int searchIndex = sourceSubstringRange.getBeginIndex();

      try
      {

         while ( parser.nextToken() == StreamTokenizer.TT_WORD )
         {
            SubstringRange tokenSubstringRange =
               findSourceTokenSubstringRange( parser.sval, searchIndex );

            tokenVector.addElement( tokenSubstringRange );
            searchIndex = tokenSubstringRange.getEndIndex();
         }

      }
      catch ( Exception e )
      {
         System.out.println( "Caught exception: " + e );
      }

      if ( tokenVector.size() > 0 )
      {
         sourceTokenArray = new SubstringRange[ tokenVector.size() ];
         tokenVector.copyInto( sourceTokenArray );
      }
      else
      {
         sourceTokenArray = null;
      }

   }

   public String toString()
   {
      return ( sourceString.substring( sourceSubstringRange.
         getBeginIndex(), sourceSubstringRange.getEndIndex() ) );
   }

   public SubstringRange getSubstringRange()
   {
      return ( new SubstringRange( sourceSubstringRange ) );
   }

   public int getLineNumber()
   {
      return ( lineNumber );
   }

   public int getAddress()
   {
      return ( address );
   }

   public void setLineNumber( int line )
   {

      if ( line > 0 )
      {
         lineNumber = line;
      }
      else
      {
         lineNumber = 0;
      }

   }

   public void setAddress( int addr )
   {

      if ( addr >= 0 )
      {
         address = addr;
      }
      else
      {
         address = -1;
      }

   }

   public String[] getSourceTokenStringArray()
   {

      if ( sourceTokenArray != null )
      {
         String[] returnArray = new String[ sourceTokenArray.length ];

         for ( int index = 0; index < sourceTokenArray.length; index++ )
         {
            returnArray[ index ] = sourceString.substring(
               sourceTokenArray[ index ].getBeginIndex(),
               sourceTokenArray[ index ].getEndIndex() );
         }

         return ( returnArray );
      }
      else
      {
         return ( null );
      }

   }

   public SubstringRange[] getSourceTokenSubstringRangeArray()
   {

      if ( sourceTokenArray != null )
      {
         SubstringRange[] returnArray = new SubstringRange[
            sourceTokenArray.length ];

         System.arraycopy( sourceTokenArray, 0, returnArray, 0,
            sourceTokenArray.length );

         return ( returnArray );
      }
      else
      {
         return ( null );
      }

   }

   public int sourceTokenLength()
   {

      if ( sourceTokenArray != null )
      {
         return ( sourceTokenArray.length );
      }
      else
      {
         return ( 0 );
      }

   }

   
   public boolean ContainsLabel(){
            String[] tokens = getSourceTokenStringArray();
            if(IsLabel(tokens[0])){
                    return true;
            }else{
                    return false;
            }
   }
   
   public String GetLabel(){
           if(getSourceTokenStringArray()!=null){
            String[] tokens = getSourceTokenStringArray();
            if(IsLabel(tokens[0])){
                    return tokens[0];
            }else{
                    return new String("");
            }
           }
           return new String("");
   }
   
   //Needed in order to find a label
   private boolean IsLabel(String token){
           if(token.indexOf(':')!=-1 && token.indexOf(':')==token.length()-1 && token.length()>1){
                   return true;
           }else{
                   return false;
           }
   }
   
   private SubstringRange findSourceTokenSubstringRange( String
      sourceToken, int searchIndex )
   {
      int beginIndex = sourceString.indexOf( sourceToken, searchIndex );
      int endIndex = beginIndex + sourceToken.length();

      return ( new SubstringRange( beginIndex, endIndex ) );
   }
   
   

   private String sourceString;
   private SubstringRange sourceSubstringRange;
   private SubstringRange[] sourceTokenArray;
   private int lineNumber;
   private int address;
}