import java.awt.*;
import java.awt.event.*;
import java.util.*;

public
class Breakpoints
   extends Frame
   implements ActionListener
{

   public Breakpoints( Box b, CPU c, String title )
   {
      super( title );

      box = b;
      cpu = c;

      setLayout( new GridBagLayout() );

      GridBagConstraints gbc = new GridBagConstraints();

      gbc.anchor = GridBagConstraints.WEST;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 0, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth = 10;
      gbc.gridheight = 2;

      Label breakpointListLabel = new Label( "Breakpoints:" );

      breakpointListLabel.setFont( new Font( "SansSerif", Font.PLAIN +
         Font.BOLD, 12 ) );
      add( breakpointListLabel, gbc );

      gbc.anchor = GridBagConstraints.CENTER;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 0, 5, 5, 5 );
      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.gridwidth = 9;
      gbc.gridheight = 9;

      breakpointList = new java.awt.List( 5, true );
      add( breakpointList, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 5, 5, 5, 5 );
      gbc.gridx = 9;
      gbc.gridy = 2;
      gbc.gridwidth = 2;
      gbc.gridheight = 2;

      deleteButton = new Button( "Delete" );
      deleteButton.addActionListener( this );
      add( deleteButton, gbc );

      gbc.gridx = 9;
      gbc.gridy = 6;
      gbc.gridwidth = 2;
      gbc.gridheight = 2;

      addButton = new Button( "Add" );
      addButton.addActionListener( this );
      add( addButton, gbc );

      Panel breakpointTypeLabelPanel = new Panel();

      breakpointTypeChoice = new Choice();
      breakpointTypeChoice.add( addressChoiceString );
      breakpointTypeChoice.add( lineChoiceString );
      breakpointTypeLabelPanel.add( breakpointTypeChoice );

      Label breakpointTypeFieldLabel = new Label( ":" );

      breakpointTypeLabelPanel.add( breakpointTypeFieldLabel );

      gbc.anchor = GridBagConstraints.WEST;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 5, 5 );
      gbc.gridx = 0;
      gbc.gridy = 11;
      gbc.gridwidth = 5;
      gbc.gridheight = 2;

      add( breakpointTypeLabelPanel, gbc );

      gbc.anchor = GridBagConstraints.EAST;
      gbc.fill = GridBagConstraints.HORIZONTAL;
      gbc.insets = new Insets( 5, 0, 5, 5 );
      gbc.gridx = 5;
      gbc.gridy = 11;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      breakpointTypeText = new TextField( 10 );
      add( breakpointTypeText, gbc );

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  setVisible( false );
               }

            }

         );

/*      addFocusListener(

            new FocusAdapter()
            {

               public void focusGained( FocusEvent e )
               {

                  if ( programChanged != box.hasProgramChanged() )
                  {
                     System.out.println( "DEBUG ==> Breakpoints Display focus" );
                     refreshBreakpointList();
                  }

               }

            }

         );*/

      breakpointVector = new Vector();
//      programChanged = box.hasProgramChanged();

      setResizable( false );
      pack();
   }

   public void actionPerformed( ActionEvent evt )
   {
      Object eventSource = evt.getSource();

      if ( eventSource == addButton )
      {
         System.out.println( "DEBUG ==> Pressed Add button" );

         String type = breakpointTypeChoice.getSelectedItem();
         String text = breakpointTypeText.getText();
         int address = -1;

         System.out.println( "DEBUG ==> Choice: " + type );

         if ( type.equals( lineChoiceString ) )
         {
            int line = AssemblyInstruction.toWordInteger( text );

            System.out.println( "DEBUG ==> Entered line " + line );

            if ( line > -1 )
            {
               AssemblyResults results = box.getAssemblyResults();
               AssemblySourceLine srcLine = results.getSource().
                  getSourceLineByLineNumber( line );

               System.out.println( "DEBUG ==> Found line " + srcLine );

               if ( srcLine != null )
               {
                  address = srcLine.getAddress();
                  System.out.println( "DEBUG ==> Found address " + address );
               }

            }

         }
         else if ( type.equals( addressChoiceString ) )
         {
            address = AssemblyInstruction.toAddressInteger( text );

            System.out.println( "DEBUG ==> Entered address " + address );
         }

         Integer addressInteger = new Integer( address );

         if ( ( address > -1 ) && ( breakpointVector.indexOf(
            addressInteger ) == -1 ) )
         {
            breakpointVector.addElement( addressInteger );
            System.out.println( "DEBUG ==> Added breakpoint at address " +
               addressInteger );
            refreshBreakpointList();
         }

      }
      else if ( eventSource == deleteButton )
      {
         int[] selectedIndices = breakpointList.getSelectedIndexes();
         boolean itemDeleted = false;

         while ( selectedIndices.length > 0 )
         {
            String deleteItem = breakpointList.getItem( selectedIndices[
               0 ] );

            System.out.println( "DEBUG ==> List index to be deleted: " +
               selectedIndices[ 0 ] );
            System.out.println( "DEBUG ==> Item to be deleted: " +
               deleteItem );
            System.out.println( "DEBUG ==> Delete breakpoint at address " +
               ( Integer ) breakpointVector.elementAt( selectedIndices[
               0 ] ) );

            breakpointVector.removeElementAt( selectedIndices[ 0 ] );
            breakpointList.remove( selectedIndices[ 0 ] );
            selectedIndices = breakpointList.getSelectedIndexes();
            itemDeleted = true;
         }

//         if ( itemDeleted )
//         {
//            refreshBreakpointList();
//         }

      }

   }

   public boolean hasBreakpoint( int address )
   {

      if ( breakpointVector.isEmpty() )
      {
         return ( false );
      }
      else
      {
         return ( breakpointVector.indexOf( new Integer( address ) ) !=
            -1 );
      }

   }

   public void refreshBreakpointList()
   {
      breakpointList.removeAll();

      for ( int index = 0; index < breakpointVector.size(); index++ )
      {
//         AssemblyResults results = box.getAssemblyResults();
         int address = ( ( Integer ) breakpointVector.elementAt(
            index ) ).intValue();
         String breakpointListString = "Address " + address;
//         AssemblySourceLine srcLine = results.getSource().
//            getSourceLineByAddress( address );

//         programChanged = box.hasProgramChanged();

//         if ( ( srcLine != null ) && ( ! programChanged ) )
//         {
//            breakpointListString += " (Line " + srcLine.getLineNumber() +
//               ")";
//         }

         breakpointList.add( breakpointListString );
      }

   }

   public void removeAllBreakpoints()
   {
      breakpointVector.removeAllElements();
      breakpointList.removeAll();
   }

   public void disableComponents()
   {
      addButton.setEnabled( false );
      deleteButton.setEnabled( false );
   }

   public void enableComponents()
   {
      addButton.setEnabled( true );
      deleteButton.setEnabled( true );
   }

   private Box box;
   private CPU cpu;

   private java.awt.List breakpointList;
   private Button addButton;
   private Button deleteButton;
   private Choice breakpointTypeChoice;
   private TextField breakpointTypeText;

   // Vector containing breakpoints that are active
   private Vector breakpointVector;
//   private boolean programChanged;

   private static String lineChoiceString = "Line";
   private static String addressChoiceString = "Address";
}