import java.awt.*;
import java.awt.event.*;

public
class EditRegisterDialog
   extends Dialog
   implements ActionListener
{

   public EditRegisterDialog( Frame parent, String title, boolean modal,
      int reg )
   {
      this( parent, title, modal, reg, false );
   }

   public EditRegisterDialog( Frame parent, String title, boolean modal,
      int reg, boolean noCancel )
   {
      super( parent, title, modal );

      cpu = ( CPU ) parent;

      changeSuccess = false;

      String registerString = "";

      registerToEdit = reg;

      if ( reg == REG_AR )
      {
         registerString = "AR";
      }
      else if ( reg == REG_PC )
      {
         registerString = "PC";
      }
      else if ( reg == REG_DR )
      {
         registerString = "DR";
      }
      else if ( reg == REG_TR )
      {
         registerString = "TR";
      }
      else if ( reg == REG_IR )
      {
         registerString = "IR";
      }
      else if ( reg == REG_R )
      {
         registerString = "R";
      }
      else if ( reg == REG_AC )
      {
         registerString = "AC";
      }
      else if ( reg == REG_Z )
      {
         registerString = "Z";
      }
      else if ( reg == REG_SA )
      {
         registerString = "Start Address";
      }

      Label registerLabel = new Label( registerString + ":", Label.RIGHT );
//      registerLabel.setFont( new Font( "SansSerif", Font.BOLD, 12 ) );

      registerTextField = new TextField( 17 );

      okButton = new Button( "OK" );
      okButton.addActionListener( this );

      cancelButton = new Button( "Cancel" );
      cancelButton.addActionListener( this );

      Panel registerPanel = new Panel();

//      registerPanel.setLayout( new FlowLayout( FlowLayout.LEFT, 0, 0 ) );
      registerPanel.add( registerLabel );
      registerPanel.add( registerTextField );

      Panel registerButtonPanel = new Panel();

      registerButtonPanel.add( okButton );

      if ( ! noCancel )
      {
         registerButtonPanel.add( cancelButton );
      }

      setLayout( new GridLayout( 2, 1 ) );

      add( registerPanel );
      add( registerButtonPanel );

      if ( ! noCancel )
      {
         addWindowListener(

               new WindowAdapter()
               {

                  public void windowClosing( WindowEvent e )
                  {
                     dispose();
                  }

               }

            );

      }

      setResizable( false );
      pack();
   }

   public void actionPerformed( ActionEvent e )
   {
      Object eventSource = e.getSource();

      if ( eventSource == cancelButton )
      {
         dispose();
      }
      else if ( eventSource == okButton )
      {
         int input;

         switch ( registerToEdit )
         {

            case REG_AR:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x10000 ) )
               {
                  cpu.theBox.ARint = input;
                  cpu.theBox.AR = AssemblyInstruction.toNumberString(
                     cpu.theBox.ARint, 2, 16 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_PC:
            case REG_SA:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x10000 ) )
               {
                  cpu.theBox.PCint = input;
                  cpu.theBox.PC = AssemblyInstruction.toNumberString(
                     cpu.theBox.PCint, 2, 16 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_DR:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x100 ) )
               {
                  cpu.theBox.DRint = input;
                  cpu.theBox.DR = AssemblyInstruction.toNumberString(
                     cpu.theBox.DRint, 2, 8 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_TR:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x100 ) )
               {
                  cpu.theBox.TRint = input;
                  cpu.theBox.TR = AssemblyInstruction.toNumberString(
                     cpu.theBox.TRint, 2, 8 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_IR:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x100 ) )
               {
                  cpu.theBox.IRint = input;
                  cpu.theBox.IR = AssemblyInstruction.toNumberString(
                     cpu.theBox.IRint, 2, 8 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_R:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x100 ) )
               {
                  cpu.theBox.Rint = input;
                  cpu.theBox.R = AssemblyInstruction.toNumberString(
                     cpu.theBox.Rint, 2, 8 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_AC:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x100 ) )
               {
                  cpu.theBox.ACint = input;
                  cpu.theBox.AC = AssemblyInstruction.toNumberString(
                     cpu.theBox.ACint, 2, 8 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

            case REG_Z:
               input = AssemblyInstruction.toWordInteger(
                  registerTextField.getText() );

               if ( ( input > -1 ) && ( input < 0x2 ) )
               {
                  cpu.theBox.Zint = input;
                  cpu.theBox.Z = AssemblyInstruction.toNumberString(
                     cpu.theBox.Zint, 2, 1 );

                  cpu.canvasRepaint();

                  changeSuccess = true;
               }

               break;

         }

         if ( changeSuccess )
         {
            dispose();
         }
         else
         {
            ErrorDialog errorDialog = new ErrorDialog( cpu, "Error", true,
               "You entered an invalid value!" );

            Dimension screenSize = Toolkit.getDefaultToolkit().
               getScreenSize();
            Dimension errorDialogSize = errorDialog.getSize();
            Point errorDialogLocation = new Point( ( screenSize.width -
               errorDialogSize.width ) / 2, ( screenSize.height -
               errorDialogSize.height ) / 2 );

            errorDialog.setLocation( errorDialogLocation );
            errorDialog.setVisible( true );
         }

      }

   }

   private int registerToEdit;

   private boolean changeSuccess;

   private CPU cpu;

//   private Label registerLabel;
   private TextField registerTextField;
   private Button okButton;
   private Button cancelButton;

   public static final int REG_AR = 0;
   public static final int REG_PC = 1;
   public static final int REG_DR = 2;
   public static final int REG_TR = 3;
   public static final int REG_IR = 4;
   public static final int REG_R  = 5;
   public static final int REG_AC = 6;
   public static final int REG_Z  = 7;
   public static final int REG_SA  = 8;
}
