import java.awt.*;
import java.awt.event.*;

public
class ErrorDialog
   extends Dialog
   implements ActionListener
{

   public ErrorDialog( Frame parent, String title, boolean modal, String
      errorString )
   {
      super( parent, title, modal );

      setLayout( new GridBagLayout() );

      GridBagConstraints gbc = new GridBagConstraints();

      Label errorLabel = new Label( errorString, Label.CENTER );

      errorLabel.setFont( new Font( "SansSerif", Font.BOLD, 12 ) );

      gbc.anchor = GridBagConstraints.CENTER;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      add( errorLabel, gbc );

      okButton = new Button( "OK" );
      okButton.addActionListener( this );

      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = GridBagConstraints.REMAINDER;

      add( okButton, gbc );

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  dispose();
               }

            }

         );

      setResizable( false );
      pack();
   }

   public void actionPerformed( ActionEvent evt )
   {
      Object eventSource = evt.getSource();

      if ( eventSource == okButton )
      {
         dispose();
      }

   }

   private Button okButton;
}


