import java.awt.*;
import java.awt.event.*;

public
class FillMemoryDialog
   extends Dialog
   implements ActionListener
{

   public FillMemoryDialog( Frame parent, String title, boolean modal )
   {
      super( parent, title, modal );

      memory = ( Memory ) parent;

      setLayout( new GridBagLayout() );

      GridBagConstraints gbc = new GridBagConstraints();

      gbc.anchor = GridBagConstraints.WEST;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      Label tempLabel = new Label( "Address Range" );

      add( tempLabel, gbc );

      gbc.anchor = GridBagConstraints.WEST;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 0, 5, 5, 0 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.gridwidth = 2;
      gbc.gridheight = 2;

      tempLabel = new Label( "From:" );

      add( tempLabel, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 0, 0, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 2;
      gbc.gridy = 2;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      beginAddressTextField = new TextField( 17 );
      add( beginAddressTextField, gbc );

      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 0, 5, 5, 0 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 4;
      gbc.gridwidth = 1;
      gbc.gridheight = 2;

      tempLabel = new Label( "To:" );

      add( tempLabel, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 0, 0, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 1;
      gbc.gridy = 4;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      endAddressTextField = new TextField( 17 );
      add( endAddressTextField, gbc );

      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 5, 0 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 6;
      gbc.gridwidth = 2;
      gbc.gridheight = 2;

      tempLabel = new Label( "Data:" );

      add( tempLabel, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 5, 0, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 2;
      gbc.gridy = 6;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      dataTextField = new TextField( 17 );
      add( dataTextField, gbc );

      Panel buttonPanel = new Panel();

      okButton = new Button( "OK" );
      cancelButton = new Button( "Cancel" );

      buttonPanel.add( okButton );
      buttonPanel.add( cancelButton );

      gbc.anchor = GridBagConstraints.CENTER;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 0, 5, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 8;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = GridBagConstraints.REMAINDER;

      add( buttonPanel, gbc );

      okButton.addActionListener( this );
      cancelButton.addActionListener( this );

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  dispose();
               }

            }

         );

      setResizable( false );
      pack();
   }

   public void actionPerformed( ActionEvent e )
   {
      Object eventSource = e.getSource();

      if ( eventSource == okButton )
      {
         int beginAddress = AssemblyInstruction.toWordInteger(
            beginAddressTextField.getText() );
         int endAddress = AssemblyInstruction.toWordInteger(
            endAddressTextField.getText() );
         short data = AssemblyInstruction.toByteShort( dataTextField.
            getText() );

         if ( ( beginAddress >= 0 ) && ( beginAddress <= 0xffff ) && (
            endAddress >= 0 ) && ( endAddress <= 0xffff ) && ( beginAddress
            <= endAddress ) && ( data >= 0 ) && ( data <= 0xff ) )
         {

            for ( int address = beginAddress; address <= endAddress;
               address++ )
            {
               memory.write( address, data );
            }

            memory.repaint();
            dispose();
         }

      }
      else if ( eventSource == cancelButton )
      {
         dispose();
      }

   }

   private TextField beginAddressTextField;
   private TextField endAddressTextField;
   private TextField dataTextField;
   private Button okButton;
   private Button cancelButton;

   private Memory memory;
}
