import java.awt.*;
import java.awt.event.*;
import java.util.*;

public
class Memory
   extends Frame
   implements AdjustmentListener, ActionListener
{

   public Memory( Frame parent, String windowTitle )
   {
      super( windowTitle );
		
      CPUBox = ( CPU ) parent;

      clear();
				
      MenuBar mbar = new MenuBar();
      setMenuBar( mbar );
		
      Menu type = new Menu( "Type" );
      type.add( new MenuItem( "View memory in HEX" ) );
      type.add( new MenuItem( "View memory in BINARY" ) );

      editMemoryMenuItem = new MenuItem( "Edit Memory" );
      editMemoryMenuItem.addActionListener( this );

      fillMemoryMenuItem = new MenuItem( "Fill Memory" );
      fillMemoryMenuItem.addActionListener( this );

      clearMemoryMenuItem = new MenuItem( "Clear Memory" );
      clearMemoryMenuItem.addActionListener( this );

      editMenu = new Menu( "Edit" );
      editMenu.add( editMemoryMenuItem );
      editMenu.add( fillMemoryMenuItem );
      editMenu.add( clearMemoryMenuItem );

      Menu view = new Menu( "View" );
      view.add( new MenuItem( "Address 0000h - 07FFh (0 - 2047)" ) );
      view.add( new MenuItem( "Address 0800h - 0FFFh (2048 - 4095)" ) );
      view.add( new MenuItem( "Address 1000h - 17FFh (4096 - 6143)" ) );
      view.add( new MenuItem( "Address 1800h - 1FFFh (6144 - 8191)" ) );
      view.add( new MenuItem( "Address 2000h - 27FFh (8192 - 10239)" ) );
      view.add( new MenuItem( "Address 28FFh - 2FFFh (10240 - 12287)" ) );
      view.add( new MenuItem( "Address 3000h - 37FFh (12288 - 14335)" ) );
      view.add( new MenuItem( "Address 3800h - 3FFFh (14336 - 16383)" ) );
      view.add( new MenuItem( "Address 4000h - 47FFh (16384 - 18431)" ) );
      view.add( new MenuItem( "Address 4800h - 4FFFh (18432 - 20479)" ) );
      view.add( new MenuItem( "Address 5000h - 57FFh (20480 - 22527)" ) );
      view.add( new MenuItem( "Address 5800h - 5FFFh (22528 - 24575)" ) );
      view.add( new MenuItem( "Address 6000h - 67FFh (24576 - 26623)" ) );
      view.add( new MenuItem( "Address 6800h - 6FFFh (26624 - 28671)" ) );
      view.add( new MenuItem( "Address 7000h - 77FFh (28672 - 30719)" ) );
      view.add( new MenuItem( "Address 7800h - 7FFFh (30720 - 32767)" ) );
      view.add( new MenuItem( "Address 8000h - 87FFh (32768 - 34815)" ) );
      view.add( new MenuItem( "Address 8800h - 8FFFh (34816 - 36863)" ) );
      view.add( new MenuItem( "Address 9000h - 97FFh (36864 - 38911)" ) );
      view.add( new MenuItem( "Address 9800h - 9FFFh (38912 - 40959)" ) );
      view.add( new MenuItem( "Address A000h - A7FFh (40960 - 43007)" ) );
      view.add( new MenuItem( "Address A800h - AFFFh (43008 - 45055)" ) );
      view.add( new MenuItem( "Address B000h - B7FFh (45056 - 47103)" ) );
      view.add( new MenuItem( "Address B800h - BFFFh (47104 - 49151)" ) );
      view.add( new MenuItem( "Address C000h - C7FFh (49152 - 51199)" ) );
      view.add( new MenuItem( "Address C800h - CFFFh (51200 - 53247)" ) );
      view.add( new MenuItem( "Address D000h - D7FFh (53248 - 55295)" ) );
      view.add( new MenuItem( "Address D800h - DFFFh (55296 - 57343)" ) );
      view.add( new MenuItem( "Address E000h - E7FFh (57344 - 59391)" ) );
      view.add( new MenuItem( "Address E800h - EFFFh (59392 - 61439)" ) );
      view.add( new MenuItem( "Address F000h - F7FFh (61440 - 63487)" ) );
      view.add( new MenuItem( "Address F800h - FFFFh (63488 - 65535)" ) );
      view.addSeparator();
      view.add( new MenuItem( "Close Window" ) );

      mbar.add( view );
      mbar.add( editMenu );
      mbar.add( type );

      vert = new Scrollbar( Scrollbar.VERTICAL, 0, 0, 0, 669 );
      add( "East", vert );
	
      vert.addAdjustmentListener( this );

      top = 0;
      bottom = 2048;

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  setVisible( false );
               }

            }

         );

      setSize( 315, 295 );
   }

   public void adjustmentValueChanged( AdjustmentEvent ae )
   {
      scrollvalue = 15 * vert.getValue();
      repaint();
   }

   public boolean action( Event evtObj, Object arg )
   {

      if ( arg.equals( "Address 0000h - 07FFh (0 - 2047)" ) )
      { 
         top = 0;
         bottom = 2048;
         repaint();
         return ( true );
      }
      else if(arg.equals("Address 0800h - 0FFFh (2048 - 4095)"))
      {
			top=2048;
			bottom=4096;
			repaint();
			return true;
      }
      else if(arg.equals("Address 1000h - 17FFh (4096 - 6143)"))
      { 
			top=4096;
			bottom=6144;
			repaint();
			return true;
      }
      else if(arg.equals("Address 1800h - 1FFFh (6144 - 8191)"))
      {
			top=6144;
			bottom=8192;
			repaint();
			return true;
      }
      else if(arg.equals("Address 2000h - 27FFh (8192 - 10239)"))
      { 
			top=8192;
			bottom=10240;
			repaint();
			return true;
      }
      else if(arg.equals("Address 28FFh - 2FFFh (10240 - 12287)"))
      {
			top=10240;
			bottom=12288;
			repaint(); 
			return true;
      }
      else if(arg.equals("Address 3000h - 37FFh (12288 - 14335)"))
      { 
			top=12288;
			bottom=14336;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address 3800h - 3FFFh (14336 - 16383)"))
      {
			top=14336;
			bottom=16384;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address 4000h - 47FFh (16384 - 18431)"))
      { 
			top=16384;
			bottom=18432;
			repaint(); 
			return true;
      }
      else if(arg.equals("Address 4800h - 4FFFh (18432 - 20479)"))
      {
			top=18432;
			bottom=20480;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 5000h - 57FFh (20480 - 22527)"))
      { 
                        top=20480;
			bottom=22528;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 5800h - 5FFFh (22528 - 24575)"))
      {
			top=22528;
			bottom=24576;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address 6000h - 67FFh (24576 - 26623)"))
      {
			top=24576;
			bottom=26624;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 6800h - 6FFFh (26624 - 28671)"))
      { 
			top=26624;
			bottom=28672;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 7000h - 77FFh (28672 - 30719)"))
      {
			top=28672;
			bottom=30720;
			repaint();
			return true;
      }
      else if(arg.equals("Address 7800h - 7FFFh (30720 - 32767)"))
      { 
			top=30720;
			bottom=32768;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 8000h - 87FFh (32768 - 34815)"))
      {
			top=32768;
			bottom=34816;
			repaint();
			return true;
      }
      else if(arg.equals("Address 8800h - 8FFFh (34816 - 36863)"))
      {
			top=34816;
			bottom=36864;
			repaint();	
			return true;
      }
      else if(arg.equals("Address 9000h - 97FFh (36864 - 38911)"))
      { 
			top=36864;
			bottom=38912;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address 9800h - 9FFFh (38912 - 40959)"))
      {
			top=38912;
			bottom=40960;
			repaint();	
			return true;
      }
      else if(arg.equals("Address A000h - A7FFh (40960 - 43007)"))
      { 
			top=40960;
			bottom=43008;
			repaint();	
			return true;
      }
      else if(arg.equals("Address A800h - AFFFh (43008 - 45055)"))
      {
			top=43008;
			bottom=45056;
			repaint();	
			return true;
      }
      else if(arg.equals("Address B000h - B7FFh (45056 - 47103)"))
      {
			top=45056;
			bottom=47104;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address B800h - BFFFh (47104 - 49151)"))
      {
			top=47104;
			bottom=49152;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address C000h - C7FFh (49152 - 51199)"))
      { 
			top=49152;
			bottom=51200;
			repaint();	
			return true;
      }
      else if(arg.equals("Address C800h - CFFFh (51200 - 53247)"))
      {
			top=51200;
			bottom=53248;
			repaint();	
			return true;
      }
      else if(arg.equals("Address D000h - D7FFh (53248 - 55295)"))
      { 
			top=53248;
			bottom=55296;
			repaint();	
			return true;
      }
      else if(arg.equals("Address D800h - DFFFh (55296 - 57343)"))
      {
			top=55296;
			bottom=57344;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address E000h - E7FFh (57344 - 59391)"))
      {
			top=57344;
			bottom=59392;
			repaint();	
			return true;
      }
      else if(arg.equals("Address E800h - EFFFh (59392 - 61439)"))
      { 
			top=59392;
			bottom=61440;
			repaint();	
			return true;
      }
      else if(arg.equals("Address F000h - F7FFh (61440 - 63487)"))
      {
			top=61440;
			bottom=63488;
			repaint();	 
			return true;
      }
      else if(arg.equals("Address F800h - FFFFh (63488 - 65535)"))
      {
			top=63488;
			bottom=65536;
			repaint();	
			return true;
      }
      else if(arg.equals("Close Window"))
      {
                        setVisible( false );
			return true;
      }
      else if(arg.equals("View memory in HEX"))
      {
			showType = 1;
			repaint();
			return true;
      }
      else if(arg.equals("View memory in BINARY"))
      {
			showType = 0;
			repaint();
			return true;
      }
      else return false;

   }

   public void actionPerformed( ActionEvent e )
   {
      Object eventSource = e.getSource();

      if ( eventSource == editMemoryMenuItem )
      {
         editMemory = new EditMemoryDialog( this, "Edit Memory", true );

	 Dimension screenSize = Toolkit.getDefaultToolkit().
	    getScreenSize();
         Dimension editMemoryDialogSize = editMemory.getSize();
         Point editMemoryDialogLocation = new Point( ( screenSize.width -
            editMemoryDialogSize.width ) / 2, ( screenSize.height -
            editMemoryDialogSize.height ) / 2 );

         editMemory.setLocation( editMemoryDialogLocation );
         editMemory.setVisible( true );
      }
      else if ( eventSource == fillMemoryMenuItem )
      {
         fillMemory = new FillMemoryDialog( this, "Fill Memory", true );

	 Dimension screenSize = Toolkit.getDefaultToolkit().
	    getScreenSize();
         Dimension fillMemoryDialogSize = fillMemory.getSize();
         Point fillMemoryDialogLocation = new Point( ( screenSize.width -
            fillMemoryDialogSize.width ) / 2, ( screenSize.height -
            fillMemoryDialogSize.height ) / 2 );

         fillMemory.setLocation( fillMemoryDialogLocation );
         fillMemory.setVisible( true );
      }
      else if ( eventSource == clearMemoryMenuItem )
      {
         clear();
         repaint();
      }

   }

   public void paint( Graphics g )
   {
      Font boldFont = new Font( "SansSerif", Font.BOLD, 11 );
      Font plainFont = new Font( "SansSerif", Font.PLAIN, 11 );

      boolean binaryViewMode = ( showType == 0 );

      for ( int contentsIndex = top; contentsIndex < bottom; contentsIndex
         += 4 )
      {
         int yPosition = ( 5 * contentsIndex ) - scrollvalue + 65 - ( 5 *
            top );
         int nybbleStringBase = ( binaryViewMode ? 2 : 16 );
         int nybbleStringLength = ( binaryViewMode ? 4 : 1 );

         g.setFont( boldFont );
         g.drawString( contentsIndex + ":", 5, yPosition );

         for ( int columnCounter = 0; columnCounter < 4;
               columnCounter++ )
         {
            long upperNybble = ( contents[ contentsIndex + columnCounter ]
               & 0xf0 ) >> 4;
            long lowerNybble = contents[ contentsIndex + columnCounter ] &
               0xf;

            if ( ( contentsIndex + columnCounter ) == CPUBox.
               simulationStartNumber )
            {
               g.setFont( boldFont );
            }
            else
            {
               g.setFont( plainFont );
            }

            g.drawString( AssemblyInstruction.toNumberString( upperNybble,
               nybbleStringBase, nybbleStringLength ).toUpperCase() + "  "
               + AssemblyInstruction.toNumberString( lowerNybble, 
               nybbleStringBase, nybbleStringLength ).toUpperCase(), 47 + (
               62 * columnCounter ), yPosition );
         }

      }

   }

   public void clear()
   {

      for ( int index = 0; index < MEMORY_SIZE; index++ )
      {
         contents[ index ] = 0;
      }

   }

   public void dispose()
   {
      editMemory.dispose();
      fillMemory.dispose();
      super.dispose();
   }

   public short read( int address )
   {

      if ( ( address < 0 ) || ( address >= MEMORY_SIZE ) )
      {
         return ( -1 );
      }
      else
      {
         return ( contents[ address ] );
      }

   }

   public boolean write( int address, short data )
   {

      if ( ( address < 0 ) || ( address >= MEMORY_SIZE ) || ( data < 0 ) ||
         ( data > 0xff ) )
      {
         return ( false );
      }
      else
      {
         contents[ address ] = data;

         return ( true );
      }

   }

   public String[] readBinaryNybbleStringArray( int address )
   {
      return ( toBinaryNybbleStringArray( read( address ) ) );
   }

   public boolean writeBinaryNybbleStringArray( int address, String[]
      dataStringArray )
   {
      short data = fromBinaryNybbleStringArray( dataStringArray );
      
      return ( write( address, data ) );
   }

   public static short fromBinaryNybbleStringArray( String[] nybbleString )
   {

      if ( ( nybbleString != null ) && ( nybbleString.length == 2 ) )
      {

         try
         {
            int upperNybble = Integer.valueOf( nybbleString[ 0 ], 2 ).
               intValue();
            int lowerNybble = Integer.valueOf( nybbleString[ 1 ], 2 ).
               intValue();

            return ( ( short ) ( ( upperNybble * 0x10 ) + lowerNybble ) );
         }
         catch ( NumberFormatException e )
         {
            return ( -1 );
         }

      }
      else
      {
         return ( -1 );
      }

   }
            
   public static String[] toBinaryNybbleStringArray( short byteShort )
   {

      if ( ( byteShort >= 0 ) && ( byteShort <= 0xff ) )
      {
         String upperNybble = AssemblyInstruction.toNumberString( byteShort
            / 0x10, 2, 4 );
         String lowerNybble = AssemblyInstruction.toNumberString( byteShort
            % 0x10, 2, 4 );
         String[] binaryNybble = { upperNybble, lowerNybble };

         return ( binaryNybble );
      }
      else
      {
         return ( null );
      }

   }

   public void disableComponents()
   {

      if ( editMemory != null )
      {
         editMemory.dispose();
      }

      if ( fillMemory != null )
      {
         fillMemory.dispose();
      }

      editMenu.setEnabled( false );
      editMemoryMenuItem.setEnabled( false );
      fillMemoryMenuItem.setEnabled( false );
      clearMemoryMenuItem.setEnabled( false );
   }

   public void enableComponents()
   {
      editMenu.setEnabled( true );
      editMemoryMenuItem.setEnabled( true );
      fillMemoryMenuItem.setEnabled( true );
      clearMemoryMenuItem.setEnabled( true );
   }

   private int scrollvalue = 0; 
   private int showType = 0;
   private int top;
   private int bottom;

   private Scrollbar vert;

   private Menu editMenu;
   private MenuItem editMemoryMenuItem;
   private MenuItem fillMemoryMenuItem;
   private MenuItem clearMemoryMenuItem;

   private CPU CPUBox;
   private EditMemoryDialog editMemory;
   private FillMemoryDialog fillMemory;

   private short[] contents = new short[ MEMORY_SIZE ];

   public static final int MEMORY_SIZE = 65536;
}
