/*
 * Decompiled with CFR 0.152.
 */
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;

public class AssemblySourceLine {
    private String sourceString;
    private SubstringRange sourceSubstringRange;
    private SubstringRange[] sourceTokenArray;
    private int lineNumber;
    private int address;

    public AssemblySourceLine(String string, SubstringRange substringRange, int n) {
        this(string, substringRange, n, -1);
    }

    public AssemblySourceLine(String string, SubstringRange substringRange, int n, int n2) {
        this.sourceString = string;
        this.sourceSubstringRange = new SubstringRange(substringRange);
        this.setLineNumber(n);
        this.setAddress(n2);
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.toString()));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 65535);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(59);
        Vector<SubstringRange> vector = new Vector<SubstringRange>();
        int n3 = this.sourceSubstringRange.getBeginIndex();
        try {
            while (streamTokenizer.nextToken() == -3) {
                SubstringRange substringRange2 = this.findSourceTokenSubstringRange(streamTokenizer.sval, n3);
                vector.addElement(substringRange2);
                n3 = substringRange2.getEndIndex();
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
        }
        if (vector.size() > 0) {
            this.sourceTokenArray = new SubstringRange[vector.size()];
            vector.copyInto(this.sourceTokenArray);
        } else {
            this.sourceTokenArray = null;
        }
    }

    public String toString() {
        return this.sourceString.substring(this.sourceSubstringRange.getBeginIndex(), this.sourceSubstringRange.getEndIndex());
    }

    public SubstringRange getSubstringRange() {
        return new SubstringRange(this.sourceSubstringRange);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getAddress() {
        return this.address;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n > 0 ? n : 0;
    }

    public void setAddress(int n) {
        this.address = n >= 0 ? n : -1;
    }

    public String[] getSourceTokenStringArray() {
        if (this.sourceTokenArray != null) {
            String[] stringArray = new String[this.sourceTokenArray.length];
            int n = 0;
            while (n < this.sourceTokenArray.length) {
                stringArray[n] = this.sourceString.substring(this.sourceTokenArray[n].getBeginIndex(), this.sourceTokenArray[n].getEndIndex());
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public SubstringRange[] getSourceTokenSubstringRangeArray() {
        if (this.sourceTokenArray != null) {
            SubstringRange[] substringRangeArray = new SubstringRange[this.sourceTokenArray.length];
            System.arraycopy(this.sourceTokenArray, 0, substringRangeArray, 0, this.sourceTokenArray.length);
            return substringRangeArray;
        }
        return null;
    }

    public int sourceTokenLength() {
        if (this.sourceTokenArray != null) {
            return this.sourceTokenArray.length;
        }
        return 0;
    }

    public boolean ContainsLabel() {
        String[] stringArray = this.getSourceTokenStringArray();
        return this.IsLabel(stringArray[0]);
    }

    public String GetLabel() {
        if (this.getSourceTokenStringArray() != null) {
            String[] stringArray = this.getSourceTokenStringArray();
            if (this.IsLabel(stringArray[0])) {
                return stringArray[0];
            }
            return new String("");
        }
        return new String("");
    }

    private boolean IsLabel(String string) {
        return string.indexOf(58) != -1 && string.indexOf(58) == string.length() - 1 && string.length() > 1;
    }

    private SubstringRange findSourceTokenSubstringRange(String string, int n) {
        int n2 = this.sourceString.indexOf(string, n);
        int n3 = n2 + string.length();
        return new SubstringRange(n2, n3);
    }
}

