/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class Breakpoints
extends Frame
implements ActionListener {
    private Box box;
    private CPU cpu;
    private List breakpointList;
    private Button addButton;
    private Button deleteButton;
    private Choice breakpointTypeChoice;
    private TextField breakpointTypeText;
    private Vector breakpointVector;
    private static String lineChoiceString = "Line";
    private static String addressChoiceString = "Address";

    public Breakpoints(Box box, CPU cPU, String string) {
        super(string);
        this.box = box;
        this.cpu = cPU;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.gridheight = 2;
        Label label = new Label("Breakpoints:");
        label.setFont(new Font("SansSerif", 1, 12));
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.gridheight = 9;
        this.breakpointList = new List(5, true);
        this.add((Component)this.breakpointList, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.deleteButton = new Button("Delete");
        this.deleteButton.addActionListener(this);
        this.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.addButton = new Button("Add");
        this.addButton.addActionListener(this);
        this.add((Component)this.addButton, gridBagConstraints);
        Panel panel = new Panel();
        this.breakpointTypeChoice = new Choice();
        this.breakpointTypeChoice.add(addressChoiceString);
        this.breakpointTypeChoice.add(lineChoiceString);
        panel.add(this.breakpointTypeChoice);
        Label label2 = new Label(":");
        panel.add(label2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        this.add((Component)panel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        this.breakpointTypeText = new TextField(10);
        this.add((Component)this.breakpointTypeText, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Breakpoints.this.setVisible(false);
            }
        });
        this.breakpointVector = new Vector();
        this.setResizable(false);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            System.out.println("DEBUG ==> Pressed Add button");
            String string = this.breakpointTypeChoice.getSelectedItem();
            String string2 = this.breakpointTypeText.getText();
            int n = -1;
            System.out.println("DEBUG ==> Choice: " + string);
            if (string.equals(lineChoiceString)) {
                int n2 = AssemblyInstruction.toWordInteger(string2);
                System.out.println("DEBUG ==> Entered line " + n2);
                if (n2 > -1) {
                    AssemblyResults assemblyResults = this.box.getAssemblyResults();
                    AssemblySourceLine assemblySourceLine = assemblyResults.getSource().getSourceLineByLineNumber(n2);
                    System.out.println("DEBUG ==> Found line " + assemblySourceLine);
                    if (assemblySourceLine != null) {
                        n = assemblySourceLine.getAddress();
                        System.out.println("DEBUG ==> Found address " + n);
                    }
                }
            } else if (string.equals(addressChoiceString)) {
                n = AssemblyInstruction.toAddressInteger(string2);
                System.out.println("DEBUG ==> Entered address " + n);
            }
            Integer n3 = new Integer(n);
            if (n > -1 && this.breakpointVector.indexOf(n3) == -1) {
                this.breakpointVector.addElement(n3);
                System.out.println("DEBUG ==> Added breakpoint at address " + n3);
                this.refreshBreakpointList();
            }
        } else if (object == this.deleteButton) {
            int[] nArray = this.breakpointList.getSelectedIndexes();
            boolean bl = false;
            while (nArray.length > 0) {
                String string = this.breakpointList.getItem(nArray[0]);
                System.out.println("DEBUG ==> List index to be deleted: " + nArray[0]);
                System.out.println("DEBUG ==> Item to be deleted: " + string);
                System.out.println("DEBUG ==> Delete breakpoint at address " + (Integer)this.breakpointVector.elementAt(nArray[0]));
                this.breakpointVector.removeElementAt(nArray[0]);
                this.breakpointList.remove(nArray[0]);
                nArray = this.breakpointList.getSelectedIndexes();
                bl = true;
            }
        }
    }

    public boolean hasBreakpoint(int n) {
        if (this.breakpointVector.isEmpty()) {
            return false;
        }
        return this.breakpointVector.indexOf(new Integer(n)) != -1;
    }

    public void refreshBreakpointList() {
        this.breakpointList.removeAll();
        int n = 0;
        while (n < this.breakpointVector.size()) {
            int n2 = (Integer)this.breakpointVector.elementAt(n);
            String string = "Address " + n2;
            this.breakpointList.add(string);
            ++n;
        }
    }

    public void removeAllBreakpoints() {
        this.breakpointVector.removeAllElements();
        this.breakpointList.removeAll();
    }

    public void disableComponents() {
        this.addButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    public void enableComponents() {
        this.addButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
    }
}

