/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class EditRegisterDialog
extends Dialog
implements ActionListener {
    private int registerToEdit;
    private boolean changeSuccess;
    private CPU cpu;
    private TextField registerTextField;
    private Button okButton;
    private Button cancelButton;
    public static final int REG_AR = 0;
    public static final int REG_PC = 1;
    public static final int REG_DR = 2;
    public static final int REG_TR = 3;
    public static final int REG_IR = 4;
    public static final int REG_R = 5;
    public static final int REG_AC = 6;
    public static final int REG_Z = 7;
    public static final int REG_SA = 8;
    public static final int IO = 9;

    public EditRegisterDialog(Frame frame, String string, boolean bl, int n) {
        this(frame, string, bl, n, false);
    }

    public EditRegisterDialog(Frame frame, String string, boolean bl, int n, boolean bl2) {
        super(frame, string, bl);
        this.cpu = (CPU)frame;
        this.changeSuccess = false;
        String string2 = "";
        this.registerToEdit = n;
        if (n == 0) {
            string2 = "AR";
        } else if (n == 1) {
            string2 = "PC";
        } else if (n == 2) {
            string2 = "DR";
        } else if (n == 3) {
            string2 = "TR";
        } else if (n == 4) {
            string2 = "IR";
        } else if (n == 5) {
            string2 = "R";
        } else if (n == 6) {
            string2 = "AC";
        } else if (n == 7) {
            string2 = "Z";
        } else if (n == 8) {
            string2 = "Start Address";
        } else if (n == 9) {
            string2 = "I/O Port";
        }
        Label label = new Label(string2 + ":", 2);
        this.registerTextField = new TextField(17);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        Panel panel = new Panel();
        panel.add(label);
        panel.add(this.registerTextField);
        Panel panel2 = new Panel();
        panel2.add(this.okButton);
        if (!bl2) {
            panel2.add(this.cancelButton);
        }
        this.setLayout(new GridLayout(2, 1));
        this.add(panel);
        this.add(panel2);
        if (!bl2) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    EditRegisterDialog.this.dispose();
                }
            });
        }
        this.setResizable(false);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.okButton) {
            switch (this.registerToEdit) {
                case 0: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 65536) break;
                    CPU.theBox.ARint = n;
                    CPU.theBox.AR = AssemblyInstruction.toNumberString(CPU.theBox.ARint, 2, 16);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 1: 
                case 8: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 65536) break;
                    CPU.theBox.PCint = n;
                    CPU.theBox.PC = AssemblyInstruction.toNumberString(CPU.theBox.PCint, 2, 16);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 2: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.DRint = n;
                    CPU.theBox.DR = AssemblyInstruction.toNumberString(CPU.theBox.DRint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 3: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.TRint = n;
                    CPU.theBox.TR = AssemblyInstruction.toNumberString(CPU.theBox.TRint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 4: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.IRint = n;
                    CPU.theBox.IR = AssemblyInstruction.toNumberString(CPU.theBox.IRint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 5: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.Rint = n;
                    CPU.theBox.R = AssemblyInstruction.toNumberString(CPU.theBox.Rint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 6: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.ACint = n;
                    CPU.theBox.AC = AssemblyInstruction.toNumberString(CPU.theBox.ACint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.changeSuccess = true;
                    break;
                }
                case 7: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    if (n > -1 && n < 2) {
                        CPU.theBox.Zint = n;
                        CPU.theBox.Z = AssemblyInstruction.toNumberString(CPU.theBox.Zint, 2, 1);
                        this.cpu.canvasRepaint();
                        this.changeSuccess = true;
                    }
                }
                case 9: {
                    int n = AssemblyInstruction.toWordInteger(this.registerTextField.getText());
                    short s = (short)n;
                    if (n <= -1 || n >= 256) break;
                    CPU.theBox.IOint = n;
                    this.cpu.memoryBox.contents[65535] = s;
                    CPU.theBox.IO = AssemblyInstruction.toNumberString(CPU.theBox.IOint, 2, 8);
                    this.cpu.canvasRepaint();
                    this.cpu.memoryBox.repaint();
                    this.changeSuccess = true;
                }
            }
            if (this.changeSuccess) {
                this.dispose();
            } else {
                ErrorDialog errorDialog = new ErrorDialog((Frame)this.cpu, "Error", true, "You entered an invalid value!");
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dimension2 = errorDialog.getSize();
                Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                errorDialog.setLocation(point);
                errorDialog.setVisible(true);
            }
        }
    }
}

