/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Memory
extends Frame
implements AdjustmentListener,
ActionListener {
    private int scrollvalue = 0;
    private int showType = 0;
    private int top;
    private int bottom;
    private Scrollbar vert;
    private Menu editMenu;
    private MenuItem editMemoryMenuItem;
    private MenuItem fillMemoryMenuItem;
    private MenuItem clearMemoryMenuItem;
    private MenuItem editIOMenuItem;
    private MenuItem a2047;
    private MenuItem a4095;
    private MenuItem a6143;
    private MenuItem a8191;
    private MenuItem a10239;
    private MenuItem a12287;
    private MenuItem a14335;
    private MenuItem a16383;
    private MenuItem a18431;
    private MenuItem a20479;
    private MenuItem a22527;
    private MenuItem a24575;
    private MenuItem a26623;
    private MenuItem a28671;
    private MenuItem a30719;
    private MenuItem a32767;
    private MenuItem a34815;
    private MenuItem a36863;
    private MenuItem a38911;
    private MenuItem a40959;
    private MenuItem a43007;
    private MenuItem a45055;
    private MenuItem a47103;
    private MenuItem a49151;
    private MenuItem a51199;
    private MenuItem a53247;
    private MenuItem a55295;
    private MenuItem a57343;
    private MenuItem a59391;
    private MenuItem a61439;
    private MenuItem a63487;
    private MenuItem a65535;
    private MenuItem closeWin;
    private MenuItem viewHex;
    private MenuItem viewBin;
    private CPU CPUBox;
    private EditMemoryDialog editMemory;
    private FillMemoryDialog fillMemory;
    private EditMemoryDialog editIO;
    public short[] contents = new short[65536];
    public static final int MEMORY_SIZE = 65536;

    public Memory(Frame frame, String string) {
        super(string);
        this.CPUBox = (CPU)frame;
        this.clear();
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("Type");
        this.viewHex = new MenuItem("View memory in HEX");
        this.viewHex.addActionListener(this);
        menu.add(this.viewHex);
        this.viewBin = new MenuItem("View memory in BINARY");
        this.viewBin.addActionListener(this);
        menu.add(this.viewBin);
        this.editMemoryMenuItem = new MenuItem("Edit Memory");
        this.editMemoryMenuItem.addActionListener(this);
        this.fillMemoryMenuItem = new MenuItem("Fill Memory");
        this.fillMemoryMenuItem.addActionListener(this);
        this.clearMemoryMenuItem = new MenuItem("Clear Memory & I/O");
        this.clearMemoryMenuItem.addActionListener(this);
        this.editIOMenuItem = new MenuItem("Edit I/O Port");
        this.editIOMenuItem.addActionListener(this);
        this.editMenu = new Menu("Edit");
        this.editMenu.add(this.editMemoryMenuItem);
        this.editMenu.add(this.fillMemoryMenuItem);
        this.editMenu.add(this.clearMemoryMenuItem);
        this.editMenu.add(this.editIOMenuItem);
        Menu menu2 = new Menu("View");
        this.a2047 = new MenuItem("Address 0000h - 07FFh (0 - 2047)");
        this.a2047.addActionListener(this);
        menu2.add(this.a2047);
        this.a4095 = new MenuItem("Address 0800h - 0FFFh (2048 - 4095)");
        this.a4095.addActionListener(this);
        menu2.add(this.a4095);
        this.a6143 = new MenuItem("Address 1000h - 17FFh (4096 - 6143)");
        this.a6143.addActionListener(this);
        menu2.add(this.a6143);
        this.a8191 = new MenuItem("Address 1800h - 1FFFh (6144 - 8191)");
        this.a8191.addActionListener(this);
        menu2.add(this.a8191);
        this.a10239 = new MenuItem("Address 2000h - 27FFh (8192 - 10239)");
        this.a10239.addActionListener(this);
        menu2.add(this.a10239);
        this.a12287 = new MenuItem("Address 28FFh - 2FFFh (10240 - 12287)");
        this.a12287.addActionListener(this);
        menu2.add(this.a12287);
        this.a14335 = new MenuItem("Address 3000h - 37FFh (12288 - 14335)");
        this.a14335.addActionListener(this);
        menu2.add(this.a14335);
        this.a16383 = new MenuItem("Address 3800h - 3FFFh (14336 - 16383)");
        this.a16383.addActionListener(this);
        menu2.add(this.a16383);
        this.a18431 = new MenuItem("Address 4000h - 47FFh (16384 - 18431)");
        this.a18431.addActionListener(this);
        menu2.add(this.a18431);
        this.a20479 = new MenuItem("Address 4800h - 4FFFh (18432 - 20479)");
        this.a20479.addActionListener(this);
        menu2.add(this.a20479);
        this.a22527 = new MenuItem("Address 5000h - 57FFh (20480 - 22527)");
        this.a22527.addActionListener(this);
        menu2.add(this.a22527);
        this.a24575 = new MenuItem("Address 5800h - 5FFFh (22528 - 24575)");
        this.a24575.addActionListener(this);
        menu2.add(this.a24575);
        this.a26623 = new MenuItem("Address 6000h - 67FFh (24576 - 26623)");
        this.a26623.addActionListener(this);
        menu2.add(this.a24575);
        this.a28671 = new MenuItem("Address 6800h - 6FFFh (26624 - 28671)");
        this.a28671.addActionListener(this);
        menu2.add(this.a28671);
        this.a30719 = new MenuItem("Address 7000h - 77FFh (28672 - 30719)");
        this.a30719.addActionListener(this);
        menu2.add(this.a30719);
        this.a32767 = new MenuItem("Address 7800h - 7FFFh (30720 - 32767)");
        this.a32767.addActionListener(this);
        menu2.add(this.a32767);
        this.a34815 = new MenuItem("Address 8000h - 87FFh (32768 - 34815)");
        this.a34815.addActionListener(this);
        menu2.add(this.a34815);
        this.a36863 = new MenuItem("Address 8800h - 8FFFh (34816 - 36863)");
        this.a36863.addActionListener(this);
        menu2.add(this.a36863);
        this.a38911 = new MenuItem("Address 9000h - 97FFh (36864 - 38911)");
        this.a38911.addActionListener(this);
        menu2.add(this.a38911);
        this.a40959 = new MenuItem("Address 9800h - 9FFFh (38912 - 40959)");
        this.a40959.addActionListener(this);
        menu2.add(this.a40959);
        this.a43007 = new MenuItem("Address A000h - A7FFh (40960 - 43007)");
        this.a43007.addActionListener(this);
        menu2.add(this.a43007);
        this.a45055 = new MenuItem("Address A800h - AFFFh (43008 - 45055)");
        this.a45055.addActionListener(this);
        menu2.add(this.a45055);
        this.a47103 = new MenuItem("Address B000h - B7FFh (45056 - 47103)");
        this.a47103.addActionListener(this);
        menu2.add(this.a47103);
        this.a49151 = new MenuItem("Address B800h - BFFFh (47104 - 49151)");
        this.a49151.addActionListener(this);
        menu2.add(this.a49151);
        this.a51199 = new MenuItem("Address C000h - C7FFh (49152 - 51199)");
        this.a51199.addActionListener(this);
        menu2.add(this.a51199);
        this.a53247 = new MenuItem("Address C800h - CFFFh (51200 - 53247)");
        this.a53247.addActionListener(this);
        menu2.add(this.a53247);
        this.a55295 = new MenuItem("Address D000h - D7FFh (53248 - 55295)");
        this.a55295.addActionListener(this);
        menu2.add(this.a55295);
        this.a57343 = new MenuItem("Address D800h - DFFFh (55296 - 57343)");
        this.a57343.addActionListener(this);
        menu2.add(this.a57343);
        this.a59391 = new MenuItem("Address E000h - E7FFh (57344 - 59391)");
        this.a59391.addActionListener(this);
        menu2.add(this.a59391);
        this.a61439 = new MenuItem("Address E800h - EFFFh (59392 - 61439)");
        this.a61439.addActionListener(this);
        menu2.add(this.a61439);
        this.a63487 = new MenuItem("Address F000h - F7FFh (61440 - 63487)");
        this.a61439.addActionListener(this);
        menu2.add(this.a61439);
        this.a65535 = new MenuItem("Address F800h - FFFFh (63488 - 65535)");
        this.a65535.addActionListener(this);
        menu2.add(this.a65535);
        menu2.addSeparator();
        this.closeWin = new MenuItem("Close Window");
        this.closeWin.addActionListener(this);
        menu2.add(this.closeWin);
        menuBar.add(menu2);
        menuBar.add(this.editMenu);
        menuBar.add(menu);
        this.vert = new Scrollbar(1, 0, 0, 0, 670);
        this.add("East", this.vert);
        this.vert.addAdjustmentListener(this);
        this.top = 0;
        this.bottom = 2048;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Memory.this.setVisible(false);
            }
        });
        this.setSize(315, 295);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scrollvalue = 15 * this.vert.getValue();
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.a2047) {
            this.top = 0;
            this.bottom = 2048;
            this.repaint();
        } else if (object == this.a4095) {
            this.top = 2048;
            this.bottom = 4096;
            this.repaint();
        } else if (object == this.a6143) {
            this.top = 4096;
            this.bottom = 6144;
            this.repaint();
        } else if (object == this.a8191) {
            this.top = 6144;
            this.bottom = 8192;
            this.repaint();
        } else if (object == this.a10239) {
            this.top = 8192;
            this.bottom = 10240;
            this.repaint();
        } else if (object == this.a12287) {
            this.top = 10240;
            this.bottom = 12288;
            this.repaint();
        } else if (object == this.a14335) {
            this.top = 12288;
            this.bottom = 14336;
            this.repaint();
        } else if (object == this.a16383) {
            this.top = 14336;
            this.bottom = 16384;
            this.repaint();
        } else if (object == this.a18431) {
            this.top = 16384;
            this.bottom = 18432;
            this.repaint();
        } else if (object == this.a20479) {
            this.top = 18432;
            this.bottom = 20480;
            this.repaint();
        } else if (object == this.a22527) {
            this.top = 20480;
            this.bottom = 22528;
            this.repaint();
        } else if (object == this.a24575) {
            this.top = 22528;
            this.bottom = 24576;
            this.repaint();
        } else if (object == this.a26623) {
            this.top = 24576;
            this.bottom = 26624;
            this.repaint();
        } else if (object == this.a28671) {
            this.top = 26624;
            this.bottom = 28672;
            this.repaint();
        } else if (object == this.a30719) {
            this.top = 28672;
            this.bottom = 30720;
            this.repaint();
        } else if (object == this.a32767) {
            this.top = 30720;
            this.bottom = 32768;
            this.repaint();
        } else if (object == this.a34815) {
            this.top = 32768;
            this.bottom = 34816;
            this.repaint();
        } else if (object == this.a36863) {
            this.top = 34816;
            this.bottom = 36864;
            this.repaint();
        } else if (object == this.a38911) {
            this.top = 36864;
            this.bottom = 38912;
            this.repaint();
        } else if (object == this.a40959) {
            this.top = 38912;
            this.bottom = 40960;
            this.repaint();
        } else if (object == this.a43007) {
            this.top = 40960;
            this.bottom = 43008;
            this.repaint();
        } else if (object == this.a45055) {
            this.top = 43008;
            this.bottom = 45056;
            this.repaint();
        } else if (object == this.a47103) {
            this.top = 45056;
            this.bottom = 47104;
            this.repaint();
        } else if (object == this.a49151) {
            this.top = 47104;
            this.bottom = 49152;
            this.repaint();
        } else if (object == this.a51199) {
            this.top = 49152;
            this.bottom = 51200;
            this.repaint();
        } else if (object == this.a53247) {
            this.top = 51200;
            this.bottom = 53248;
            this.repaint();
        } else if (object == this.a55295) {
            this.top = 53248;
            this.bottom = 55296;
            this.repaint();
        } else if (object == this.a57343) {
            this.top = 55296;
            this.bottom = 57344;
            this.repaint();
        } else if (object == this.a59391) {
            this.top = 57344;
            this.bottom = 59392;
            this.repaint();
        } else if (object == this.a61439) {
            this.top = 59392;
            this.bottom = 61440;
            this.repaint();
        } else if (object == this.a63487) {
            this.top = 61440;
            this.bottom = 63488;
            this.repaint();
        } else if (object == this.a65535) {
            this.top = 63488;
            this.bottom = 65536;
            this.repaint();
        } else if (object == this.closeWin) {
            this.setVisible(false);
        } else if (object == this.viewHex) {
            this.showType = 1;
            this.repaint();
        } else if (object == this.viewBin) {
            this.showType = 0;
            this.repaint();
        } else if (object == this.editMemoryMenuItem) {
            this.editMemory = new EditMemoryDialog(this, "Edit Memory", true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.editMemory.getSize();
            Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.editMemory.setLocation(point);
            this.editMemory.setVisible(true);
        } else if (object == this.fillMemoryMenuItem) {
            this.fillMemory = new FillMemoryDialog(this, "Fill Memory", true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.fillMemory.getSize();
            Point point = new Point((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
            this.fillMemory.setLocation(point);
            this.fillMemory.setVisible(true);
        } else if (object == this.clearMemoryMenuItem) {
            this.clear();
            this.repaint();
        } else if (object == this.editIOMenuItem) {
            this.editMemory = new EditMemoryDialog(this, "Edit I/O Port", true);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension4 = this.editMemory.getSize();
            Point point = new Point((dimension.width - dimension4.width) / 2, (dimension.height - dimension4.height) / 2);
            this.editMemory.setLocation(point);
            this.editMemory.setVisible(true);
        }
    }

    public void paint(Graphics graphics) {
        Font font = new Font("SansSerif", 1, 11);
        Font font2 = new Font("SansSerif", 0, 11);
        boolean bl = this.showType == 0;
        int n = this.top;
        while (n < this.bottom) {
            int n2 = 5 * n - this.scrollvalue + 65 - 5 * this.top;
            int n3 = bl ? 2 : 16;
            int n4 = bl ? 4 : 1;
            graphics.setFont(font);
            graphics.drawString(n + ":", 5, n2);
            int n5 = 0;
            while (n5 < 4) {
                long l = (this.contents[n + n5] & 0xF0) >> 4;
                long l2 = this.contents[n + n5] & 0xF;
                if (n + n5 == this.CPUBox.simulationStartNumber) {
                    graphics.setFont(font);
                } else {
                    graphics.setFont(font2);
                }
                graphics.drawString(AssemblyInstruction.toNumberString(l, n3, n4).toUpperCase() + "  " + AssemblyInstruction.toNumberString(l2, n3, n4).toUpperCase(), 47 + 62 * n5, n2);
                ++n5;
            }
            n += 4;
        }
    }

    public void clear() {
        int n = 0;
        while (n < 65536) {
            this.contents[n] = 0;
            ++n;
        }
        CPU.theBox.IO = "00000000";
        this.CPUBox.canvasRepaint();
    }

    public void dispose() {
        this.editMemory.dispose();
        this.fillMemory.dispose();
        super.dispose();
    }

    public short read(int n) {
        if (n < 0 || n >= 65536) {
            return -1;
        }
        return this.contents[n];
    }

    public boolean write(int n, short s) {
        if (n < 0 || n >= 65536 || s < 0 || s > 255) {
            return false;
        }
        this.contents[n] = s;
        CPU.theBox.IOint = this.contents[65535];
        CPU.theBox.IO = AssemblyInstruction.toNumberString(CPU.theBox.IOint, 2, 8);
        this.CPUBox.canvasRepaint();
        return true;
    }

    public String[] readBinaryNybbleStringArray(int n) {
        return Memory.toBinaryNybbleStringArray(this.read(n));
    }

    public boolean writeBinaryNybbleStringArray(int n, String[] stringArray) {
        short s = Memory.fromBinaryNybbleStringArray(stringArray);
        return this.write(n, s);
    }

    public static short fromBinaryNybbleStringArray(String[] stringArray) {
        if (stringArray != null && stringArray.length == 2) {
            try {
                int n = Integer.valueOf(stringArray[0], 2);
                int n2 = Integer.valueOf(stringArray[1], 2);
                return (short)(n * 16 + n2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static String[] toBinaryNybbleStringArray(short s) {
        if (s >= 0 && s <= 255) {
            String string = AssemblyInstruction.toNumberString(s / 16, 2, 4);
            String string2 = AssemblyInstruction.toNumberString(s % 16, 2, 4);
            String[] stringArray = new String[]{string, string2};
            return stringArray;
        }
        return null;
    }

    public void disableComponents() {
        if (this.editMemory != null) {
            this.editMemory.dispose();
        }
        if (this.fillMemory != null) {
            this.fillMemory.dispose();
        }
        this.editMenu.setEnabled(false);
        this.editMemoryMenuItem.setEnabled(false);
        this.fillMemoryMenuItem.setEnabled(false);
        this.clearMemoryMenuItem.setEnabled(false);
    }

    public void enableComponents() {
        this.editMenu.setEnabled(true);
        this.editMemoryMenuItem.setEnabled(true);
        this.fillMemoryMenuItem.setEnabled(true);
        this.clearMemoryMenuItem.setEnabled(true);
    }
}

