import java.io.*;
import java.util.*;

public
class AssemblySourceProgram
{

   public AssemblySourceProgram( String source )
   {
      sourceString = source;

      StreamTokenizer parser = new StreamTokenizer( new StringReader( 
         source ) );

      parser.resetSyntax();
      parser.wordChars( '\u0000', '\u0009' );
      parser.wordChars( '\u000b', '\u000c' );
      parser.wordChars( '\u000e', '\uffff' );
      parser.whitespaceChars( '\r', '\r' );
      parser.whitespaceChars( '\n', '\n' );
      parser.eolIsSignificant( true );

      Vector lineVector = new Vector();
      String lineString = "";
      int searchIndex = 0;
      int lineNumber = parser.lineno();

      try
      {

         while ( parser.nextToken() != StreamTokenizer.TT_EOF )
         {

            if ( parser.ttype == StreamTokenizer.TT_WORD )
            {
               lineString = parser.sval;
            }
            else if ( parser.ttype == StreamTokenizer.TT_EOL )
            {
               AssemblySourceLine line = findSourceLine( lineString,
                  searchIndex, lineNumber );

               lineVector.addElement( line );

               if ( line.sourceTokenLength() > 0 )
               {
                  empty = true;
               }

               lineString = "";
               lineNumber = parser.lineno();
               searchIndex = line.getSubstringRange().getEndIndex();

               if ( searchIndex == sourceString.indexOf( "\r\n",
                  searchIndex ) )
               {
                  searchIndex += 2;
               }
               else
               {
                  searchIndex++;
               }

            }
               
         }

      }
      catch ( Exception e )
      {
         System.out.println( "Caught exception: " + e );
      }

      if ( lineString != "" )
      {
         lineNumber = parser.lineno();
         lineVector.addElement( findSourceLine( lineString, searchIndex,
            lineNumber ) );
      }

      sourceLineArray = new AssemblySourceLine[ lineVector.size() ];
      lineVector.copyInto( sourceLineArray );
   }

   public AssemblySourceLine getSourceLineByLineNumber( int line )
   {

      if ( ( line > 0 ) && ( line <= sourceLineArray.length ) )
      {
         return ( sourceLineArray[ line - 1 ] );
      }
      else
      {
         return ( null );
      }

   }

   public AssemblySourceLine getSourceLineByAddress( int address )
   {

      if ( address >= 0 )
      {

         for ( int index = 0; index < sourceLineArray.length; index++ )
         {

            if ( address == sourceLineArray[ index ].getAddress() )
            {
               return ( sourceLineArray[ index ] );
            }

         }

         return ( null );
      }
      else
      {
         return ( null );
      }

   }

   public void setSourceLineAddressByLineNumber( int address, int line )
   {

      if ( ( line > 0 ) && ( line <= sourceLineArray.length ) )
      {
         sourceLineArray[ line - 1 ].setAddress( address );
      }

   }

   public int sourceLineLength()
   {
      return ( sourceLineArray.length );
   }

   public boolean isEmpty()
   {
      return ( empty );
   }

   private AssemblySourceLine findSourceLine( String sourceLine, int
      searchIndex, int line )
   {
      int beginIndex = sourceString.indexOf( sourceLine, searchIndex );
      int endIndex = beginIndex + sourceLine.length();
      SubstringRange range = new SubstringRange( beginIndex, endIndex );

      return ( new AssemblySourceLine( sourceString, range, line ) );
   }

   private AssemblySourceLine[] sourceLineArray;
   private String sourceString;
   private boolean empty = true;
}
