//import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
//import java.io.*;
import java.net.*;

public
class Box
   extends java.applet.Applet
   implements ActionListener
{
   // Declare variables
	String AR = new String("0000000000000000");    //declare register values
	String PC = new String("0000000000000000");
	String DR = new String("00000000");
	String TR = new String("00000000");
	String IR = new String("00000000");
	String R  = new String("00000000");
	String AC = new String("00000000");
	String Z  = new String("0");

	String IO = new String("00000000");

	long ARint=0;
	long PCint=0;
	long DRint=0;
	long TRint=0;
	long IRint=0;
	long Rint=0;
	long ACint=0;
	long Zint=0;

        long IOint=0;

   public void init()
   {
      //initialize gui components
      //FlowLayout flo = new FlowLayout( FlowLayout.CENTER, 10, 30 );
      //setLayout( flo );
      this.setBackground(Color.white);
      this.setLayout(new FlowLayout());
      Panel Buttons = new Panel();
      this.add(Buttons);
      Panel BoxCU = new Panel();
      this.add(BoxCU);

      Buttons.setLayout(new GridLayout(10, 1, 1, 3));
      BoxCU.setLayout(new BorderLayout());    

      //add components to screen
      programBox = new TextArea( 18, 36 );

      BoxCU.add( programBox, BorderLayout.NORTH);
      programBox.requestFocus();

      Buttons.add( label);    
      Buttons.add( memoryLocation);
      //memoryLocation.requestFocus();
      memoryLocation.setText("0");
      memoryLocation.setVisible( true );
      memoryLocation.setEditable( true );	

      //add( space2);

      BoxCU.add( cuType, BorderLayout.WEST );
      BoxCU.add( hardWiredCU, BorderLayout.CENTER );
      BoxCU.add( microCodedCU, BorderLayout.EAST);

      //add( space3 );
      //add( space );
      Buttons.add( assembleButton );
      Buttons.add( viewCPUButton );
      Buttons.add( viewTraceButton );
      Buttons.add( viewMemoryButton );
      //add( viewALUButton );
      //Buttons.add( viewControlUnitButton );
      Buttons.add( clearMemoryButton );
      Buttons.add( viewBreakpointsButton );
      Buttons.add( helpButton );
      Buttons.add( aboutButton );

      assembleButton.addActionListener( this );

      viewTraceButton.setEnabled( true );
      viewTraceButton.addActionListener( this );

      viewCPUButton.addActionListener( this );

      viewMemoryButton.addActionListener( this );

//      viewALUButton.addActionListener( this );

      viewControlUnitButton.addActionListener( this );

      clearMemoryButton.addActionListener( this );

      viewBreakpointsButton.addActionListener( this );

      helpButton.addActionListener( this );
      
      aboutButton.addActionListener( this );

      // Define object and pass this
      CPUBox = new CPU( this, "RSCPU System Architecture" );

      hardWiredCU.addItemListener(

	    new ItemListener()
	    {

	       public void itemStateChanged( ItemEvent e )
	       {

		  if ( ( ! CPUBox.isRunning() ) && ( hardWiredCU.
		     getState() ) )
		  {
			if (debug) {
                     System.out.println( "DEBUG ==> hw cu selected" );
			}

                     if ( CPUBox.mcu.isShowing() )
		     {
			CPUBox.controlUnit.setVisible( true );
                        CPUBox.mcu.setVisible( false );
		     }

                     CPUBox.controlUnit.setActive( true );
                     CPUBox.mcu.setActive( false );

		     CPUBox.setControlUnitType( CPU.CU_HARDWIRED );
		  }

	       }

	    }

	 );
		  
      microCodedCU.addItemListener(

	    new ItemListener()
	    {

	       public void itemStateChanged( ItemEvent e )
	       {

		  if ( ( ! CPUBox.isRunning() ) && ( microCodedCU.
		     getState() ) )
		  {

			if (debug) {
                     System.out.println( "DEBUG ==> mc cu selected" );
			}

		     if ( CPUBox.controlUnit.isShowing() )
		     {
                        CPUBox.controlUnit.setVisible( false );
                        CPUBox.mcu.setVisible( true );
		     }

                     CPUBox.controlUnit.setActive( false );
                     CPUBox.mcu.setActive( true );

		     CPUBox.setControlUnitType( CPU.CU_MICROCODED );
		  }

	       }

	    }

	 );

   }

   public void stop()
   {
//      CPUBox.hideAll();
//      if ( resultsDialog != null )
//      {
//         resultsDialog.dispose();
//      }

	if (debug) {
	System.out.println( "Box.stop()" );
	}
   }

   public void destroy()
   {
      CPUBox.dispose();

      if ( resultsDialog != null )
      {
         resultsDialog.dispose();
      }

	if (debug) {	
	System.out.println( "Box.destroy()" );
	}
   }

   public void paint( Graphics g )
   {
      Font f = new Font( "SansSerif", Font.BOLD, 12 );
      g.setFont( f );
      g.drawString("Enter Code =>", 50,20);

	if (debug) {
	System.out.println( "Box.paint()" );
	}
   }

   public void actionPerformed( ActionEvent event )
   {
      Object eventSource = event.getSource();
	
	if (debug) {
	System.out.println( "Box.actionPerformed()" + eventSource );
	}

      if ( eventSource == assembleButton )
      {

	 if ( ! CPUBox.isRunning() )
	 {
	    int assemblyStartLocation = AssemblyInstruction.toWordInteger(
	       memoryLocation.getText() );

	    if ( assemblyStartLocation != -1 )
	    {

               if ( ( resultsDialog != null ) && ( resultsDialog.
		  isShowing() ) )
	       {
                  resultsDialog.dispose();
	       }
               /*String Txt=programBox.getText();
               Txt.replaceAll("<html>\n","");
               Txt.replaceAll("</html>\n","");
               Txt.replaceAll("<font color='red'>","");
               Txt.replaceAll("</font>","");
               programBox.setText(Txt);
               */
                       
               results = Assembler.assemble( programBox.
                  getText(), assemblyStartLocation, this, CPUBox, CPUBox.
                  getMemory() );

               AssemblyError[] errors = results.getErrors();

               if(errors.length>0){
                programBox.select(FindNthRowStart(errors[ 0 ].getLineNumber(),programBox.getText()),FindNthRowEnd(errors[ 0 ].getLineNumber(),programBox.getText())+1);
               }
               
               resultsDialog = new AssemblyResultsDialog( getFrame(),
                  "Assembly Results", false, results );
	
 	       traceDialog = new TraceResults( getFrame(), "Trace Results"); 

	       Dimension screenSize = Toolkit.getDefaultToolkit().
		  getScreenSize();
               Dimension resultsDialogSize = resultsDialog.getSize();
               Point resultsDialogLocation = new Point( ( screenSize.width
                  - resultsDialogSize.width ) / 2, ( screenSize.height -
                  resultsDialogSize.height ) / 2 );

               resultsDialog.setLocation( resultsDialogLocation );
               resultsDialog.setVisible( true );
	       CPUBox.getBreakpoints().refreshBreakpointList();

               traceDialog.setLocation( resultsDialogLocation );

     	         TraceResults.traceBox.append("Trace of program:                  ");
    	         TraceResults.traceBox.append(newline);
//     	         TraceResults.traceBox.append("Instrs./Cycle | RTL Statement | Registers' Status  ");	    

/*		 if (CPUBox.blank)
		 {
      	         TraceResults.traceBox.append("		R		AC		Z");	  
		 }
		 else
		 {
     	         TraceResults.traceBox.append("		AR		PC		DR		TR		IR		R		AC		Z");	    
		 }
*/
    	         TraceResults.traceBox.append(newline);
    	         TraceResults.traceBox.append(newline);

	    }
	    else
	    {
	       showStatus( "Invalid memory location!" );
	    }

	 }
	 else
	 {
	    showStatus( "CPU is running!" );
	 }

      }
      else if ( eventSource == viewTraceButton )
      {

         if ( resultsDialog != null )
	 {
	    // Opens trace results window
            traceDialog.setVisible( true );	        	
	 }
	 else
	 {
	    showStatus( "No results to report!" );
	 }

      }
      else if ( eventSource == viewCPUButton )
      {
	 // Opens CPU window
	 CPUBox.setLocation(0,0);
	 CPUBox.setVisible( true );
      }
      else if ( eventSource == viewMemoryButton )
      {
	 // Opens memory window
         CPUBox.getMemory().setLocation( 20, 20 );
	 CPUBox.getMemory().setVisible( true );
      }
//      else if ( eventSource == viewALUButton )
//      {
	 // Opens alu window
//         CPUBox.aluBox.setLocation( 568, 295 );
//         CPUBox.aluBox.setVisible( true );
//      }
      else if ( eventSource == viewControlUnitButton )
      {

	 if ( selectCU.getSelectedCheckbox().equals( hardWiredCU ) )
	 {
	    // Opens hardwired control unit window
	    // CPUBox.controlUnit.setLocation( 700, 200 );
	    // Kills other CU window if it exists
            CPUBox.mcu.setVisible( false );
            CPUBox.mcu.setActive( false );
	    // Displays the Hardwired CU
	    CPUBox.controlUnit.setVisible( true );
            CPUBox.controlUnit.setActive( true );
	 }
	 else if ( selectCU.getSelectedCheckbox().equals(
	    microCodedCU ) )
	 {
	    // Opens microcoded control unit window
	    //CPUBox.mcu.setLocation( 700, 200 );
	    // Kills other CU window if it exists
	    CPUBox.controlUnit.setVisible( false );
            CPUBox.controlUnit.setActive( false );
	    // Displays the MicroCoded CU
            CPUBox.mcu.setVisible( true );
            CPUBox.mcu.setActive( true );
	 }

      }
      else if ( eventSource == clearMemoryButton )
      {

         if ( ! CPUBox.isRunning() )
         {
            Memory memory = CPUBox.getMemory();

            // Clears memory contents
            memory.clear();

            if ( memory.isShowing() )
            {
               memory.repaint();
            }

         }

      }
      else if ( eventSource == viewBreakpointsButton )
      {
	 // Opens breakpoints window
	 CPUBox.getBreakpoints().setLocation(40, 40);
	 CPUBox.getBreakpoints().setVisible( true );
      }
      else if ( eventSource == helpButton )
      {
         // Opens help window
         URL codeBaseURL = getCodeBase();
         URL helpURL;

         try
         {
            helpURL = new URL( codeBaseURL.toString() + "help/index.html" );
            getAppletContext().showDocument( helpURL, "_blank" );
         }
         catch ( Exception e ) { }


      }
      else if (eventSource == aboutButton)
      {
              new AboutDialogue().show();
      }

   }

   public AssemblyResults getAssemblyResults()
   {
	if (debug) {
	System.out.println( "Box.AssemblyResults() of class AssemblyResults" );
	}

      return ( results );
   }

   public CPU getCPU()
   {
	if (debug) {
	System.out.println( "Box.getCPU() of class CPU" );
	}

      return ( CPUBox );
   }

   public void disableComponents()
   {

	if (debug) {
	System.out.println( "Box.disableComponents()" );
	}

      assembleButton.setEnabled( false );
      hardWiredCU.setEnabled( false );
      microCodedCU.setEnabled( false );
      clearMemoryButton.setEnabled( false );

   }

   public void enableComponents()
   {

	if (debug) {
	System.out.println( "Box.enableComponents()" );
	}

      assembleButton.setEnabled( true );
      hardWiredCU.setEnabled( true );
      microCodedCU.setEnabled( true );
      clearMemoryButton.setEnabled( true );

   }

   public Frame getFrame()
   {
	if (debug) {
	System.out.println( "Box.getFrame() of class Frame" );
	}

      Component c = this;
      Frame f = null;

      while ( ( c = c.getParent() ) != null )
      {

         if ( c instanceof Frame )
         {
            f = ( Frame ) c;
         }

      }

      return ( f );

   }
   
   public int FindNthRowStart(int N,String Text){
           if(N==1){
                   return 0;
           }else{
                   int i=-1;
                   int j=1;
                   while(j!=N){
                           i=Text.indexOf("\n",i+1);
                           j++;
                   }
                   return i+1;
           }
   }
           

   public int FindNthRowEnd(int N,String Text){
                   int i=-1;
                   int j=1;
                   while(j!=N+1){
                           i=Text.indexOf("\n",i+1);
                           j++;
                   }
                   if(i==-1){
                        return Text.length()-1;
                   }else{
                        return i-1;
                   }
   }   
  
   public CheckboxGroup selectCU = new CheckboxGroup();
   public Checkbox hardWiredCU = new Checkbox( "Hardwired", true, selectCU );
   public Checkbox microCodedCU = new Checkbox( "Microprogrammed", false, selectCU );

   public Button assembleButton = new Button( "       Assemble      " );
   public Button viewTraceButton = new Button( "  Trace Results  " );

   private TextArea programBox;

   private Button viewCPUButton = new Button( "   View System   " );
   private Button viewMemoryButton = new Button( " View Memory & I/O " );

   private Button helpButton = new Button( "  Help  " );
   private Button aboutButton = new Button( "  About  " );

//   private Button viewALUButton = new Button( "View ALU" );

   private Button viewControlUnitButton = new Button( "View Control Unit" );
   private Button clearMemoryButton = new Button( "  Clear Memory & I/O  " );

   private Button viewBreakpointsButton = new Button( "View Breakpoints" );

   private Label label = new Label( "Memory Location:" );
   private Label space = new Label( "" );
   private Label space2 = new Label( "                    " );
   private Label cuType = new Label( "Control Unit Type" );
   private Label space3 = new Label( "        " );

   private TextField memoryLocation = new TextField( 5 );

   // Results of the assembly process
   private AssemblyResults results;
   private AssemblyResultsDialog resultsDialog = null;

   public TraceResults traceDialog;

   // Declare object of type CPU, from CPU.class
   private CPU CPUBox;

   //boolean that controls debug statements during operation true=debug stmnts false=none
   public boolean debug=false;


   static String newline = System.getProperty("line.separator");
   
   class AboutDialogue extends javax.swing.JFrame implements HyperlinkListener {
    
    /** Creates new form About */
    public AboutDialogue() {
        initComponents();
        this.setSize(new java.awt.Dimension(500, 350));
        this.setBackground(Color.white);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension DialogSize = getSize();
        Point DialogLocation = new Point( ( screenSize.width
                  - DialogSize.width ) / 2, ( screenSize.height -
                  DialogSize.height ) / 2 );

        setLocation( DialogLocation );
    }
    
    //Listens for hyperlink clicks
    public void hyperlinkUpdate(HyperlinkEvent event) {
    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        try
         {
            getAppletContext().showDocument( event.getURL(), "_blank" );
         }
         catch ( Exception e ) { }
    }
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        AboutLabel = new javax.swing.JLabel();
        LowerPanel = new javax.swing.JPanel();
        OkButton = new javax.swing.JButton();
        CentralPane = new javax.swing.JScrollPane();
        MainText = new javax.swing.JEditorPane();

        setTitle("About The Relatively Simple Computer System Simulator");
        setBackground(Color.white);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        AboutLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        AboutLabel.setText("About The Relatively Simple Computer System Simulator");
        AboutLabel.setMaximumSize(new java.awt.Dimension(41, 55));
        AboutLabel.setMinimumSize(new java.awt.Dimension(41, 55));
        AboutLabel.setPreferredSize(new java.awt.Dimension(41, 35));
        AboutLabel.setOpaque(false);
        AboutLabel.setBackground(Color.white);
        getContentPane().add(AboutLabel, java.awt.BorderLayout.NORTH);

        LowerPanel.setPreferredSize(new java.awt.Dimension(10, 45));
        LowerPanel.setOpaque(false);
        LowerPanel.setBackground(Color.white);
        OkButton.setText("Ok");
        OkButton.setPreferredSize(new java.awt.Dimension(100, 26));
        OkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OkButtonActionPerformed(evt);
            }
        });

        LowerPanel.add(OkButton);

        getContentPane().add(LowerPanel, java.awt.BorderLayout.SOUTH);

        CentralPane.setPreferredSize(new java.awt.Dimension(177, 150));
        CentralPane.getViewport().setOpaque(false);
        String AboutText="<html>\n<body><b>The Relatively Simple Computer System Simulator</b><br><br>Copyright 2001-2003, New Jersey Institute of Technology, Newark, NJ, USA<br><br>\n";
        AboutText+="This program and its source code are made freely available under<br> the terms of the GNU General Public License.  Terms<br> of this license can be found at <a href='http://www.gnu.org'>www.gnu.org</a>.<br><br>\n";
        AboutText+="The latest version of this program and its source code, as well as<br> other simulators developed for use with the textbook <i>Computer Systems<br> Organization and Architecture</i>, can be found at <a href='http://www.awl.com/carpinelli'>www.awl.com/carpinelli</a>.<br><br>\n";
        AboutText+="Development of this program was funded in part by the National<br> Science Foundation through the <a href='http://www.gatewaycoalition.org'>Gateway Engineering Education Coalition</a>.<br> Development was also supported by the United States Department of Education through the <a href='http://mcnair.njit.edu/'>Ronald E. McNair Postbaccalaureate Achievement Program</a> at the New Jersey Institute of Technology.<br><br>\n";
        AboutText+="Developers: Fabio Jaramillo, Aleksandr Livshits, and John D. Carpinelli.\n</body></html>";
        MainText.setEditable(false);
        MainText.setContentType("text/html");
        MainText.setText(AboutText);
        MainText.setCaretPosition(0);
        //MainText.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        MainText.setOpaque(false);
        MainText.setBackground(Color.white);
        MainText.addHyperlinkListener(this);
        CentralPane.setViewportView(MainText);
        

        getContentPane().add(CentralPane, java.awt.BorderLayout.CENTER);

        pack();
    }

    private void OkButtonActionPerformed(java.awt.event.ActionEvent evt) {
        // Add your handling code here:
        this.hide();
    }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        System.exit(0);
    }
    
    
    // Variables declaration - do not modify
    private javax.swing.JButton OkButton;
    private javax.swing.JPanel LowerPanel;
    private javax.swing.JLabel AboutLabel;
    private javax.swing.JScrollPane CentralPane;
    private javax.swing.JEditorPane MainText;
    // End of variables declaration
    
  }
}