import java.awt.*;
import java.awt.event.*;

public
class EditMemoryDialog
   extends Dialog
   implements ActionListener
{

   public EditMemoryDialog( Frame parent, String title, boolean modal )
   {
      super( parent, title, modal );

      memory = ( Memory ) parent;

      setLayout( new GridBagLayout() );

      GridBagConstraints gbc = new GridBagConstraints();

      gbc.anchor = GridBagConstraints.WEST;
      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 5, 5, 5, 0 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 0;
      gbc.gridwidth = 2;
      gbc.gridheight = 2;


      Label tempLabel = new Label( "Address:" );


      add( tempLabel, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 5, 0, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 2;
      gbc.gridy = 0;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      addressTextField = new TextField( 17 );
      add( addressTextField, gbc );

      gbc.fill = GridBagConstraints.NONE;
      gbc.insets = new Insets( 0, 5, 5, 0 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 2;
      gbc.gridwidth = 1;
      gbc.gridheight = 2;

      tempLabel = new Label( "Data:" );
	
      add( tempLabel, gbc );

      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 5, 0, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 1;
      gbc.gridy = 2;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = 2;

      dataTextField = new TextField( 17 );
      add( dataTextField, gbc );

      Panel buttonPanel = new Panel();

      okButton = new Button( "OK" );
      cancelButton = new Button( "Cancel" );

      buttonPanel.add( okButton );
      buttonPanel.add( cancelButton );

      gbc.anchor = GridBagConstraints.CENTER;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.insets = new Insets( 0, 5, 5, 5 );
      gbc.weightx = 0;
      gbc.weighty = 0;
      gbc.gridx = 0;
      gbc.gridy = 4;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbc.gridheight = GridBagConstraints.REMAINDER;

      add( buttonPanel, gbc );

      okButton.addActionListener( this );
      cancelButton.addActionListener( this );

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  dispose();
               }

            }

         );

      setResizable( false );
      pack();
   
    if ( title == "Edit I/O Port" )
      {	
        addressTextField.setEditable(false); 
        addItem("65535");
      }
	
   }

   public void actionPerformed( ActionEvent e )
   {
      Object eventSource = e.getSource();

      if ( eventSource == okButton )
      {
         int address = AssemblyInstruction.toWordInteger( addressTextField.
            getText() );
         short data = AssemblyInstruction.toByteShort( dataTextField.
            getText() );

         if ( ( address >= 0 ) && ( address <= 0xffff ) && ( data >= 0 ) &&
            ( data <= 0xff ) )
         {
            memory.write( address, data );
            memory.repaint();
            dispose();
         }

      }
      else if ( eventSource == cancelButton )
      {
         dispose();
      }

   }
   void addItem(String newWord)
   {
      String t = addressTextField.getText();
      addressTextField.setText(newWord);
   }

   private TextField addressTextField;
   private TextField dataTextField;
   private Button okButton;
   private Button cancelButton;

   private Memory memory;
}
