import java.awt.*;
import java.awt.event.*;

public
class McodeControlUnit
   extends Frame
   implements ActionListener
{
   private static final int COND_MASK = 0x60000000;
   private static final int BT_MASK = 0x10000000;
   private static final int OPER_MASK = 0x0fffffc0;
   private static final int ARPC_MASK = 0x08000000;
   private static final int ARIN_MASK = 0x04000000;
   private static final int ARDT_MASK = 0x02000000;
   private static final int PCIN_MASK = 0x01000000;
   private static final int PCDT_MASK = 0x00800000;
   private static final int DRM_MASK = 0x00400000;
   private static final int DRAC_MASK = 0x00200000;
   private static final int IRDR_MASK = 0x00100000;
   private static final int RAC_MASK = 0x00080000;
   private static final int ZALU_MASK = 0x00040000;
   private static final int TRDR_MASK = 0x00020000;
   private static final int ACDR_MASK = 0x00010000;
   private static final int ACR_MASK = 0x00008000;
   private static final int PLUS_MASK = 0x00004000;
   private static final int MINU_MASK = 0x00002000;
   private static final int ACIN_MASK = 0x00001000;
   private static final int ACZO_MASK = 0x00000800;
   private static final int AND_MASK = 0x00000400;
   private static final int OR_MASK = 0x00000200;
   private static final int XOR_MASK = 0x00000100;
   private static final int NOT_MASK = 0x00000080;
   private static final int MDR_MASK = 0x00000040;
   private static final int ADDR_MASK = 0x0000003f;

   private static final int COND_1 = 0x00000000;
   private static final int COND_Z = 0x20000000;
   private static final int COND_NOT_Z = 0x40000000;
   private static final int COND_X = 0x60000000;

   private static final int BT_JUMP = 0x00000000;
   private static final int BT_MAP = 0x10000000;

   private static final int OPER_ARPC = 0x08000000;
   private static final int OPER_ARIN = 0x04000000;
   private static final int OPER_ARDT = 0x02000000;
   private static final int OPER_PCIN = 0x01000000;
   private static final int OPER_PCDT = 0x00800000;
   private static final int OPER_DRM = 0x00400000;
   private static final int OPER_DRAC = 0x00200000;
   private static final int OPER_IRDR = 0x00100000;
   private static final int OPER_RAC = 0x00080000;
   private static final int OPER_ZALU = 0x00040000;
   private static final int OPER_TRDR = 0x00020000;
   private static final int OPER_ACDR = 0x00010000;
   private static final int OPER_ACR = 0x00008000;
   private static final int OPER_PLUS = 0x00004000;
   private static final int OPER_MINU = 0x00002000;
   private static final int OPER_ACIN = 0x00001000;
   private static final int OPER_ACZO = 0x00000800;
   private static final int OPER_AND = 0x00000400;
   private static final int OPER_OR = 0x00000200;
   private static final int OPER_XOR = 0x00000100;
   private static final int OPER_NOT = 0x00000080;
   private static final int OPER_MDR = 0x00000040;

   private static final int ADDR_X = 0x0000003f;

   public McodeControlUnit( CPU parent, String title )
   {
      super( title );

      cpu = parent;
      active = false;
      skipAnimation = false;

      currentDotEnabled[ 0 ] = false;
      currentDotEnabled[ 1 ] = false;
      currentDotEnabled[ 2 ] = false;
      currentDotEnabled[ 3 ] = false;

      reset();

      MenuBar mb = new MenuBar();

      fileMenu = new Menu( "File" );

      closeWindowMenuItem = new MenuItem( "Close Window" );
      closeWindowMenuItem.addActionListener( this );
      fileMenu.add( closeWindowMenuItem );

      mb.add( fileMenu );

      setMenuBar( mb );

//      mcuCanvasScrollPane =

//         new ScrollPane()
//         {

//            public Dimension getPreferredSize()
//            {
//               Dimension preferredSize = mcuCanvas.getPreferredSize();

//               preferredSize.height += getHScrollbarHeight();
//               preferredSize.width += getVScrollbarWidth();

//               return ( preferredSize );
//            }

//         };

//      mcuCanvasScrollPane.add( mcuCanvas );
//      add( mcuCanvasScrollPane );
      add( mcuCanvas );

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent evt )
               {
                  setVisible( false );
               }

            }

         );

      pack();
   }

   public boolean getSkipAnimation()
   {
      return ( skipAnimation );
   }

   public void setSkipAnimation( boolean skip )
   {
      skipAnimation = skip;
   }

   public void reset()
   {
      clear();

      addressRegister = 0;
      updateCurrentAddress();
      updateCurrentOperations();
      updateCurrentSignals();
      updateConditionMuxSelect();
      updateConditionMuxSignals();
      updateLogicBTInput();
      updateLogicConditionInput();
      updateLogicSelect();

      updateIRMap();
      updateAddressMuxSignals();
      updateAddressMux();

      justUpdatedCurrentAddress = false;

      animationIndex = 0;

      animUpdCurrAddrDone = false;
      animUpdCurrOperDone = false;
      animUpdCurrLogSelBTDone = false;
      animUpdCurrLogSelCondDone = false;
      animUpdAddrMuxDone = false;
      animUpdIRMapDone = false;
   }

   public void clear()
   {
      hw1Enabled = false;
      zEnabled = false;
      notZEnabled = false;
      clkEnabled = false;

      irPathEnabled = false;

      currAddrP1Enabled = false;
      nextAddrEnabled = false;
      irMapEnabled = false;

      currentARPC = false;
      currentARIN = false;
      currentARDT = false;
      currentPCIN = false;
      currentPCDT = false;
      currentDRM = false;
      currentDRAC = false;
      currentIRDR = false;
      currentRAC = false;
      currentZALU = false;
      currentTRDR = false;
      currentACDR = false;
      currentACR = false;
      currentPLUS = false;
      currentMINU = false;
      currentACIN = false;
      currentACZO = false;
      currentAND = false;
      currentOR = false;
      currentXOR = false;
      currentNOT = false;
      currentMDR = false;

      setDot( 0, false, null );
      setDot( 1, false, null );
      setDot( 2, false, null );
      setDot( 3, false, null );
   }

   public void canvasRepaint()
   {
      mcuCanvas.repaint();
   }

   public void canvasRepaint( int tm )
   {
      mcuCanvas.repaint( tm );
   }

   public void executeCycle()
   {

      if ( skipAnimation || ( ! active ) || ( ! isShowing() ) )
      {
         animationIndex = 0;

         clear();

         cpu.setCurrentCLK( true );
         clkEnabled = true;

         if ( ! justUpdatedCurrentAddress )
         {
            updateAddressRegister();
            updateCurrentAddress();
         }

         updateCurrentOperations();
         updateCurrentSignals();

         updateConditionMuxSelect();
         updateConditionMuxSignals();
         updateLogicBTInput();
         updateLogicConditionInput();
         updateLogicSelect();
         updateAddressMuxSignals();
         updateAddressMux();

         animUpdCurrAddrDone = false;
         animUpdCurrOperDone = false;
         animUpdCurrLogSelBTDone = false;
         animUpdCurrLogSelCondDone = false;
         animUpdAddrMuxDone = false;

         justUpdatedCurrentAddress = false;

         cpu.setStallAnimationCounter( false );
      }
      else
      {
         cpu.setStallAnimationCounter( ! executeAnimationCycle() );
         canvasRepaint();
      }

   }

   public byte updateIRMap()
   {

      if ( cpu.theBox.IRint == AssemblyInstruction.opcodeEND )
      {
         irMap = ( byte ) ( ( AssemblyInstruction.opcodeNOP & 0x0f ) <<
            2 );
      }
      else
      {
         irMap = ( byte ) ( ( cpu.theBox.IRint & 0x0f ) << 2 );
      }

      return ( irMap );
   }

   public byte updateConditionMuxSelect()
   {
      int currentMC = microcode[ currentAddress ];
      int currentCond = currentMC & COND_MASK;

      if ( currentCond == COND_1 )
      {
         conditionMuxSelect = 0;
      }
      else if ( currentCond == COND_Z )
      {
         conditionMuxSelect = 1;
      }
      else if ( currentCond == COND_NOT_Z )
      {
         conditionMuxSelect = 2;
      }
      else
      {
         conditionMuxSelect = -1;
      }

      return ( conditionMuxSelect );
   }

   public void updateConditionMuxSignals()
   {

      if ( conditionMuxSelect == 0 )
      {
         hw1Enabled = true;
         zEnabled = false;
         notZEnabled = false;
      }
      else if ( conditionMuxSelect == 1 )
      {
         hw1Enabled = false;
         zEnabled = true;
         notZEnabled = false;
      }
      else if ( conditionMuxSelect == 2 )
      {
         hw1Enabled = false;
         zEnabled = false;
         notZEnabled = true;
      }
      else
      {
         hw1Enabled = false;
         zEnabled = false;
         notZEnabled = false;
      }

   }

   public boolean updateLogicBTInput()
   {
      int currentMC = microcode[ currentAddress ];
      int currentBT = currentMC & BT_MASK;

      if ( currentBT == BT_JUMP )
      {
         logicBTInput = false;
      }
      else
      {
         logicBTInput = true;
      }

      return ( logicBTInput );
   }

   public boolean updateLogicConditionInput()
   {

      if ( conditionMuxSelect == 0 )
      {
         // Hardwired 1
         logicConditionInput = true;
      }
      else if ( conditionMuxSelect == 1 )
      {
         // Calculate Z

         if ( cpu.theBox.Zint == 0 )
         {
            logicConditionInput = false;
         }
         else
         {
            logicConditionInput = true;
         }

      }
      else if ( conditionMuxSelect == 2 )
      {
         // Calculate /Z

         if ( cpu.theBox.Zint == 0 )
         {
            logicConditionInput = true;
         }
         else
         {
            logicConditionInput = false;
         }

      }
      else
      {
         logicConditionInput = false;
      }

      return ( logicConditionInput );
   }

   public byte updateLogicSelect()
   {

      if ( ( ! logicBTInput ) && ( ! logicConditionInput ) )
      {
         logicSelect = 0;
      }
      else if ( ( ! logicBTInput ) && logicConditionInput )
      {
         logicSelect = 1;
      }
      else if ( logicBTInput )
      {
         logicSelect = 2;
      }

      return ( logicSelect );
   }

   public void updateAddressMuxSignals()
   {

      if ( logicSelect == 0 )
      {
         currAddrP1Enabled = true;
         nextAddrEnabled = false;
         irMapEnabled = false;
      }
      else if ( logicSelect == 1 )
      {
         currAddrP1Enabled = false;
         nextAddrEnabled = true;
         irMapEnabled = false;
      }
      else if ( logicSelect == 2 )
      {
         currAddrP1Enabled = false;
         nextAddrEnabled = false;
         irMapEnabled = true;
      }

   }

   public byte updateAddressMux()
   {

      if ( logicSelect == 0 )
      {
         // Current address + 1
         addressMux = ( byte ) ( addressRegister + 1 );
      }
      else if ( logicSelect == 1 )
      {
         // Get address from microcode

         int currentMC = microcode[ currentAddress ];
         int currentNextAddress = currentMC & ADDR_MASK;

         addressMux = ( byte ) currentNextAddress;
      }
      else if ( logicSelect == 2 )
      {
         // Get address from IR map

         int currentMC = microcode[ currentAddress ];
         int currentNextAddress = currentMC & ADDR_MASK;

         addressMux = irMap;
      }

      return ( addressMux );
   }

   public byte updateAddressRegister()
   {
      return ( addressRegister = addressMux );
   }

   public byte updateCurrentAddress()
   {
      return ( currentAddress = addressRegister );
   }

   public void actionPerformed( ActionEvent evt )
   {
      Object eventSource = evt.getSource();

      if ( eventSource == closeWindowMenuItem )
      {
         setVisible( false );
      }

   }

   public int updateCurrentOperations()
   {
      int currentMC = microcode[ currentAddress ];

      currentOperations = currentMC & OPER_MASK;

      if ( ( currentOperations & ARPC_MASK ) == ARPC_MASK )
      {
         currentARPC = true;
      }
      else
      {
         currentARPC = false;
      }

      if ( ( currentOperations & ARIN_MASK ) == ARIN_MASK )
      {
         currentARIN = true;
      }
      else
      {
         currentARIN = false;
      }

      if ( ( currentOperations & ARDT_MASK ) == ARDT_MASK )
      {
         currentARDT = true;
      }
      else
      {
         currentARDT = false;
      }

      if ( ( currentOperations & PCIN_MASK ) == PCIN_MASK )
      {
         currentPCIN = true;
      }
      else
      {
         currentPCIN = false;
      }

      if ( ( currentOperations & PCDT_MASK ) == PCDT_MASK )
      {
         currentPCDT = true;
      }
      else
      {
         currentPCDT = false;
      }

      if ( ( currentOperations & DRM_MASK ) == DRM_MASK )
      {
         currentDRM = true;
      }
      else
      {
         currentDRM = false;
      }

      if ( ( currentOperations & DRAC_MASK ) == DRAC_MASK )
      {
         currentDRAC = true;
      }
      else
      {
         currentDRAC = false;
      }

      if ( ( currentOperations & IRDR_MASK ) == IRDR_MASK )
      {
         currentIRDR = true;
      }
      else
      {
         currentIRDR = false;
      }

      if ( ( currentOperations & RAC_MASK ) == RAC_MASK )
      {
         currentRAC = true;
      }
      else
      {
         currentRAC = false;
      }

      if ( ( currentOperations & ZALU_MASK ) == ZALU_MASK )
      {
         currentZALU = true;
      }
      else
      {
         currentZALU = false;
      }

      if ( ( currentOperations & TRDR_MASK ) == TRDR_MASK )
      {
         currentTRDR = true;
      }
      else
      {
         currentTRDR = false;
      }

      if ( ( currentOperations & ACDR_MASK ) == ACDR_MASK )
      {
         currentACDR = true;
      }
      else
      {
         currentACDR = false;
      }

      if ( ( currentOperations & ACR_MASK ) == ACR_MASK )
      {
         currentACR = true;
      }
      else
      {
         currentACR = false;
      }

      if ( ( currentOperations & PLUS_MASK ) == PLUS_MASK )
      {
         currentPLUS = true;
      }
      else
      {
         currentPLUS = false;
      }

      if ( ( currentOperations & MINU_MASK ) == MINU_MASK )
      {
         currentMINU = true;
      }
      else
      {
         currentMINU = false;
      }

      if ( ( currentOperations & ACIN_MASK ) == ACIN_MASK )
      {
         currentACIN = true;
      }
      else
      {
         currentACIN = false;
      }

      if ( ( currentOperations & ACZO_MASK ) == ACZO_MASK )
      {
         currentACZO = true;
      }
      else
      {
         currentACZO = false;
      }

      if ( ( currentOperations & AND_MASK ) == AND_MASK )
      {
         currentAND = true;
      }
      else
      {
         currentAND = false;
      }

      if ( ( currentOperations & OR_MASK ) == OR_MASK )
      {
         currentOR = true;
      }
      else
      {
         currentOR = false;
      }

      if ( ( currentOperations & XOR_MASK ) == XOR_MASK )
      {
         currentXOR = true;
      }
      else
      {
         currentXOR = false;
      }

      if ( ( currentOperations & NOT_MASK ) == NOT_MASK )
      {
         currentNOT = true;
      }
      else
      {
         currentNOT = false;
      }

      if ( ( currentOperations & MDR_MASK ) == MDR_MASK )
      {
         currentMDR = true;
      }
      else
      {
         currentMDR = false;
      }

      return ( currentOperations );
   }

   public void updateCurrentSignals()
   {
      cpu.setCurrentARLOAD( currentARPC | currentARDT );
      cpu.setCurrentARINC( currentARIN );
      cpu.setCurrentPCLOAD( currentPCDT );
      cpu.setCurrentPCINC( currentPCIN );
      cpu.setCurrentPCBUS( currentARPC );
      cpu.setCurrentDRHBUS( currentARDT | currentPCDT );
      cpu.setCurrentDRLBUS( currentACDR | currentMDR );
      cpu.setCurrentDRLOAD( currentDRM | currentDRAC );
      cpu.setCurrentTRLOAD( currentTRDR );
      cpu.setCurrentTRBUS( currentARDT | currentPCDT );
      cpu.setCurrentIRLOAD( currentIRDR );
      cpu.setCurrentRLOAD( currentRAC );
      cpu.setCurrentRBUS( currentACR | currentPLUS | currentMINU |
         currentAND | currentOR | currentXOR );
      cpu.setCurrentACLOAD( currentACDR | currentACR | currentPLUS |
         currentMINU | currentACIN | currentACZO | currentAND | currentOR |
         currentXOR | currentNOT );
      cpu.setCurrentACBUS( currentDRAC | currentRAC );
      cpu.setCurrentALUS( currentACDR | currentACR | currentPLUS |
         currentMINU | currentACIN | currentACZO | currentAND | currentOR |
         currentXOR | currentNOT );
      cpu.setCurrentZLOAD( currentPLUS | currentMINU | currentACIN |
         currentACZO | currentAND | currentOR | currentXOR | currentNOT );
      cpu.setCurrentWRITE( currentMDR );
      cpu.setCurrentBUSMEM( currentMDR );
      cpu.setCurrentREAD( currentDRM );
      cpu.setCurrentMEMBUS( currentDRM );
   }

   public boolean executeAnimationCycle()
   {

      if ( ! animUpdCurrAddrDone )
      {
         animUpdCurrAddrDone = animUpdCurrAddr();
         System.out.println( "DEBUG ==> animUpdCurrAddrDone: " +
            animUpdCurrAddrDone );
      }

      if ( ! animUpdCurrOperDone )
      {
         animUpdCurrOperDone = animUpdCurrOper();
         System.out.println( "DEBUG ==> animUpdCurrOperDone: " +
            animUpdCurrOperDone );
      }

      if ( ! animUpdCurrLogSelBTDone )
      {
         animUpdCurrLogSelBTDone = animUpdCurrLogSelBT();
         System.out.println( "DEBUG ==> animUpdCurrLogSelBTDone: " +
            animUpdCurrLogSelBTDone );
      }

      if ( ! animUpdCurrLogSelCondDone )
      {
         animUpdCurrLogSelCondDone = animUpdCurrLogSelCond();
         System.out.println( "DEBUG ==> animUpdCurrLogSelCondDone: " +
            animUpdCurrLogSelCondDone );
      }

      if ( ! animUpdAddrMuxDone )
      {
         animUpdAddrMuxDone = animUpdAddrMux();
         System.out.println( "DEBUG ==> animUpdAddrMuxDone: " +
            animUpdAddrMuxDone );
      }

      if ( animUpdCurrAddrDone && animUpdCurrOperDone && 
         animUpdCurrLogSelBTDone && animUpdCurrLogSelCondDone &&
         animUpdAddrMuxDone )
      {
         justUpdatedCurrentAddress = false;

         animationIndex = 0;

         animUpdCurrAddrDone = false;
         animUpdCurrOperDone = false;
         animUpdCurrLogSelBTDone = false;
         animUpdCurrLogSelCondDone = false;
         animUpdAddrMuxDone = false;

         // Anim sequence done
         return ( true );
      }
      else
      {
         animationIndex++;

         // Anim sequence not done
         return ( false );
      }

   }

   public boolean animUpdCurrAddr()
   {

      if ( animationIndex == 0 )
      {
         Point pt = new Point( 195, 150 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 1 )
      {
         Point pt = new Point( 195, 185 );

         setDot( 0, true, pt );

         cpu.setCurrentCLK( true );
         clkEnabled = true;

         updateAddressRegister();
      }
      else if ( animationIndex == 2 )
      {
         Point pt = new Point( 195, 220 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 3 )
      {
         Point pt = new Point( 195, 260 );

         setDot( 0, true, pt );

         updateCurrentAddress();
         justUpdatedCurrentAddress = true;
      }
      else if ( animationIndex == 4 )
      {
         setDot( 0, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdCurrOper()
   {

      if ( animationIndex == 4 )
      {
         Point pt = new Point( 208, 320 );

         setDot( 3, true, pt );
      }
      else if ( animationIndex == 5 )
      {
         Point pt = new Point( 208, 375 );

         setDot( 3, true, pt );

         updateCurrentOperations();
         updateCurrentSignals();
      }
      else if ( animationIndex == 6 )
      {
         setDot( 3, false, null );

         // Animation sequence done
         return ( true );
      }


      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdCurrLogSelBT()
   {

      if ( animationIndex == 4 )
      {
         Point pt = new Point( 175, 320 );

         setDot( 1, true, pt );
      }
      else if ( animationIndex == 5 )
      {
         Point pt = new Point( 175, 365 );

         setDot( 1, true, pt );
      }
      else if ( animationIndex == 6 )
      {
         Point pt = new Point( 10, 365 );

         setDot( 1, true, pt );
      }
      else if ( animationIndex == 7 )
      {
         Point pt = new Point( 10, 244 );

         setDot( 1, true, pt );
      }
      else if ( animationIndex == 8 )
      {
         Point pt = new Point( 10, 123 );

         setDot( 1, true, pt );
      }
      else if ( animationIndex == 9 )
      {
         Point pt = new Point( 45, 123 );

         setDot( 1, true, pt );

         updateLogicBTInput();
         updateLogicSelect();
         updateAddressMuxSignals();
      }
      else if ( animationIndex == 10 )
      {
         setDot( 1, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdCurrLogSelCond()
   {

      if ( animationIndex == 4 )
      {
         Point pt = new Point( 145, 320 );

         setDot( 2, true, pt );
      }
      else if ( animationIndex == 5 )
      {
         Point pt = new Point( 145, 350 );

         setDot( 2, true, pt );
      }
      else if ( animationIndex == 6 )
      {
         Point pt = new Point( 75, 350 );

         setDot( 2, true, pt );
      }
      else if ( animationIndex == 7 )
      {
         Point pt = new Point( 75, 270 );

         setDot( 2, true, pt );

         updateConditionMuxSelect();
         updateConditionMuxSignals();
      }
      else if ( animationIndex == 8 )
      {
         Point pt = new Point( 75, 210 );

         setDot( 2, true, pt );
      }
      else if ( animationIndex == 9 )
      {
         Point pt = new Point( 75, 155 );

         setDot( 2, true, pt );

         updateLogicConditionInput();
         updateLogicSelect();
         updateAddressMuxSignals();
      }
      else if ( animationIndex == 10 )
      {
         setDot( 2, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdAddrMux()
   {

      if ( logicSelect == 0 )
      {
         // Current address + 1
         return ( animUpdAddrMuxCAP1() );
      }
      else if ( logicSelect == 1 )
      {
         // Get address from microcode
         return ( animUpdAddrMuxMC() );
      }
      else
      {
         // Get address from IR map
         return ( animUpdAddrMuxIR() );
      }

   }

   public boolean animUpdAddrMuxCAP1()
   {

      if ( animationIndex == 10 )
      {
         Point pt = new Point( 195, 220 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 11 )
      {
         Point pt = new Point( 195, 242 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 12 )
      {
         Point pt = new Point( 300, 242 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 13 )
      {
         Point pt = new Point( 300, 182 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 14 )
      {
         Point pt = new Point( 300, 152 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 15 )
      {
         Point pt = new Point( 300, 85 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 16 )
      {
         Point pt = new Point( 240, 85 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 17 )
      {
         Point pt = new Point( 240, 100 );

         setDot( 0, true, pt );

         updateAddressMux();
      }
      else if ( animationIndex == 18 )
      {
         setDot( 0, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdAddrMuxMC()
   {

      if ( animationIndex == 10 )
      {
         Point pt = new Point( 242, 320 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 11 )
      {
         Point pt = new Point( 242, 365 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 12 )
      {
         Point pt = new Point( 325, 365 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 13 )
      {
         Point pt = new Point( 325, 65 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 14 )
      {
         Point pt = new Point( 195, 65 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 15 )
      {
         Point pt = new Point( 195, 100 );

         setDot( 0, true, pt );

         updateAddressMux();
      }
      else if ( animationIndex == 16 )
      {
         setDot( 0, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public boolean animUpdAddrMuxIR()
   {

      if ( animationIndex == 10 )
      {
         Point pt = new Point( 150, 65 );

         setDot( 0, true, pt );
      }
      else if ( animationIndex == 11 )
      {
         Point pt = new Point( 150, 100 );

         setDot( 0, true, pt );

         updateAddressMux();
      }
      else if ( animationIndex == 12 )
      {
         setDot( 0, false, null );

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public void executeUpdIRMapCycle()
   {

      if ( animationIndex == 0 )
      {
         animationIndex = 9;
      }

      if ( ! animUpdIRMapDone )
      {
         animUpdIRMapDone = animUpdIRMap();
      }

      if ( ! animUpdAddrMuxDone )
      {
         animUpdAddrMuxDone = animUpdAddrMuxIR();
      }

      if ( animUpdIRMapDone && animUpdAddrMuxDone )
      {
         animUpdIRMapDone = false;
         animUpdAddrMuxDone = false;

         animationIndex = 0;
      }
      else
      {
         animationIndex++;
      }

      if ( ! skipAnimation )
      {
         canvasRepaint();
      }

   }

   public boolean animUpdIRMap()
   {

      if ( animationIndex == 9 )
      {
         irPathEnabled = true;

         updateIRMap();
      }
      else if ( animationIndex == 10 )
      {
         irPathEnabled = false;

         // Animation sequence done
         return ( true );
      }

      // Animation sequence not done
      return ( false );
   }

   public void setDot( int index, boolean enabled, Point pt )
   {
      oldDotEnabled[ index ] = currentDotEnabled[ index ];
      currentDotEnabled[ index ] = enabled;

      if ( enabled )
      {
         oldDotLocation[ index ] = currentDotLocation[ index ];
         currentDotLocation[ index ] = pt;
      }

   }

   public void setCLKEnabled( boolean clk )
   {
      clkEnabled = clk;
   }

   public boolean getCLKEnabled()
   {
      return ( clkEnabled );
   }

   public void setActive( boolean b )
   {
      active = b;
   }

   public boolean getActive()
   {
      return ( active );
   }

   private CPU cpu;

   private byte irMap;
   private byte addressMux;
   private byte addressRegister;
   private byte logicSelect;
   private byte conditionMuxSelect;
   private int currentOperations;
   private byte currentAddress;

   private boolean currentARPC;
   private boolean currentARIN;
   private boolean currentARDT;
   private boolean currentPCIN;
   private boolean currentPCDT;
   private boolean currentDRM;
   private boolean currentDRAC;
   private boolean currentIRDR;
   private boolean currentRAC;
   private boolean currentZALU;
   private boolean currentTRDR;
   private boolean currentACDR;
   private boolean currentACR;
   private boolean currentPLUS;
   private boolean currentMINU;
   private boolean currentACIN;
   private boolean currentACZO;
   private boolean currentAND;
   private boolean currentOR;
   private boolean currentXOR;
   private boolean currentNOT;
   private boolean currentMDR;

   private boolean conditionMuxOutput;
   private boolean logicBTInput;
   private boolean logicConditionInput;

   private boolean hw1Enabled;
   private boolean zEnabled;
   private boolean notZEnabled;
   private boolean clkEnabled;

   private boolean irPathEnabled;

   private boolean nextAddrEnabled;
   private boolean currAddrP1Enabled;
   private boolean irMapEnabled;

   private boolean[] oldDotEnabled = new boolean[ 4 ];
   private boolean[] currentDotEnabled = new boolean[ 4 ];
   private Point[] oldDotLocation = new Point[ 4 ];
   private Point[] currentDotLocation = new Point[ 4 ];

   private boolean skipAnimation;
   private boolean justUpdatedCurrentAddress;

   private int animationIndex;

   private boolean animUpdCurrAddrDone;
   private boolean animUpdCurrOperDone;
   private boolean animUpdCurrLogSelBTDone;
   private boolean animUpdCurrLogSelCondDone;
   private boolean animUpdAddrMuxDone;
   private boolean animUpdIRMapDone;

   private boolean active;

   private int[] microcode =
      {
         COND_1 | BT_JUMP | 0x01,                               // NOP1
         COND_1 | BT_JUMP | OPER_ARPC | 0x02,                   // FETCH1
         COND_1 | BT_JUMP | OPER_PCIN | OPER_DRM | 0x03,        // FETCH2
         COND_X | BT_MAP | OPER_ARPC | OPER_IRDR | ADDR_X,      // FETCH3
         COND_1 | BT_JUMP | OPER_ARIN | OPER_PCIN | OPER_DRM
            | 0x05,                                             // LDAC1
         COND_1 | BT_JUMP | OPER_PCIN | OPER_DRM | OPER_TRDR
            | 0x06,                                             // LDAC2
         COND_1 | BT_JUMP | OPER_ARDT | 0x07,                   // LDAC3
         COND_1 | BT_JUMP | OPER_DRM | 0x21,                    // LDAC4
         COND_1 | BT_JUMP | OPER_ARIN | OPER_PCIN | OPER_DRM
            | 0x09,                                             // STAC1
         COND_1 | BT_JUMP | OPER_PCIN | OPER_DRM | OPER_TRDR
            | 0x0a,                                             // STAC2
         COND_1 | BT_JUMP | OPER_ARDT | 0x0b,                   // STAC3
         COND_1 | BT_JUMP | OPER_DRAC | 0x22,                   // STAC4
         COND_1 | BT_JUMP | OPER_RAC | 0x01,                    // MVAC1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ACR | 0x01,                    // MOVR1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ARIN | OPER_DRM | 0x15,        // JUMP1
         COND_1 | BT_JUMP | OPER_DRM | OPER_TRDR | 0x16,        // JUMP2
         COND_1 | BT_JUMP | OPER_PCDT | 0x01,                   // JUMP3
         -1,
         COND_NOT_Z | BT_JUMP | 0x29,                           // JMPZ1
         COND_1 | BT_JUMP | OPER_ARIN | OPER_DRM | 0x1a,        // JMPZY1
         COND_1 | BT_JUMP | OPER_DRM | OPER_TRDR | 0x1b,        // JMPZY2
         COND_1 | BT_JUMP | OPER_PCDT | 0x01,                   // JMPZY3
         COND_Z | BT_JUMP | 0x2d,                               // JPNZ1
         COND_1 | BT_JUMP | OPER_ARIN | OPER_DRM | 0x1e,        // JPNZY1
         COND_1 | BT_JUMP | OPER_DRM | OPER_TRDR | 0x1f,        // JPNZY2
         COND_1 | BT_JUMP | OPER_PCDT | 0x01,                   // JPNZY3
         COND_1 | BT_JUMP | OPER_ZALU | OPER_PLUS | 0x01,       // ADD1
         COND_1 | BT_JUMP | OPER_ACDR | 0x01,                   // LDAC5
         COND_1 | BT_JUMP | OPER_MDR | 0x01,                    // STAC5
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_MINU | 0x01,       // SUB1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_ACIN | 0x01,       // INAC1
         COND_1 | BT_JUMP | OPER_PCIN | 0x2a,                   // JMPZN1
         COND_1 | BT_JUMP | OPER_PCIN | 0x01,                   // JMPZN2
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_ACZO | 0x01,       // CLAC1
         COND_1 | BT_JUMP | OPER_PCIN | 0x2e,                   // JPNZN1
         COND_1 | BT_JUMP | OPER_PCIN | 0x01,                   // JPNZN2
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_AND | 0x01,        // AND1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_OR | 0x01,         // OR1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_XOR | 0x01,        // XOR1
         -1,
         -1,
         -1,
         COND_1 | BT_JUMP | OPER_ZALU | OPER_NOT | 0x01,        // NOT1
         -1,
         -1
      };

   private Menu fileMenu;
   private MenuItem closeWindowMenuItem;

   private ScrollPane mcuCanvasScrollPane;

   private Canvas mcuCanvas =

      new Canvas()
      {

         public Dimension getPreferredSize()
         {
            return ( getMinimumSize() );
         }

         public Dimension getMinimumSize()
         {
            return ( new Dimension( 335, 460 ) );
         }

         public void invalidate()
         {
            super.invalidate();
            offScreenImage = null;
         }

         public void update( Graphics g )
         {
            paint( g );
         }

         public void paint( Graphics g )
         {

            if ( offScreenImage == null )
            {
               offScreenImage = createImage( 335, 460 );
            }

            Graphics offScreenGraphics = offScreenImage.getGraphics();

            offScreenGraphics.setClip( g.getClip() );

            offScreenGraphics.setColor( getBackground() );
            offScreenGraphics.fillRect( 0, 0, 335, 500 );

            Font bld = new Font( "SansSerif", Font.BOLD, 12 );
            Font bits = new Font( "SansSerif", Font.PLAIN, 11 );
            Font f3 = new Font( "SansSerif", Font.PLAIN, 9 );

            offScreenGraphics.setFont( f3 );

            offScreenGraphics.setColor( Color.black );

            offScreenGraphics.drawRect(45,95,60,60);          //Logic

            offScreenGraphics.drawRect(45,210,60,60);          //Z_MUX
            offScreenGraphics.drawString("S",72,265);          // S on Z_Mux

            offScreenGraphics.drawRect(125,185,140,35);        //Register

            offScreenGraphics.drawRect(125,260,140,60);        //Microcode Memory

            offScreenGraphics.drawRect(125,100,140,50);        //Addr_MUX

            offScreenGraphics.drawRect(285,152,30,30);         //INC

            offScreenGraphics.drawRect(125,35,50,30);          //MAP

            offScreenGraphics.drawLine(150,65,150,100);       // MAP to Addr_MUX
            offScreenGraphics.drawLine(150,100,145,95);       // Arrow
            offScreenGraphics.drawLine(150,100,155,95);       // Arrow

            offScreenGraphics.drawLine(195,150,195,185);       // Addr_MUX to Register
            offScreenGraphics.drawLine(195,185,190,180);       // Arrow
            offScreenGraphics.drawLine(195,185,200,180);       // Arrow

            offScreenGraphics.drawLine(195,220,195,260);       // Register to Micro Memory
            offScreenGraphics.fillOval(194,240,4,4);
            offScreenGraphics.drawLine(195,260,190,255);       // Arrow
            offScreenGraphics.drawLine(195,260,200,255);       // Arrow

            offScreenGraphics.drawLine(194,242,300,242);       // Register_out to INC
            offScreenGraphics.drawLine(300,242,300,182);
            offScreenGraphics.drawLine(300,182,295,187);       // Arrow
            offScreenGraphics.drawLine(300,182,305,187);       // Arrow

            offScreenGraphics.drawLine(300,152,300,85);       // INC to Addr_MUX
            offScreenGraphics.drawLine(300,85,240,85);       // INC to Addr_MUX
            offScreenGraphics.drawLine(240,85,240,100);       // INC to Addr_MUX
            offScreenGraphics.drawLine(240,100,235,95);       // Arrow
            offScreenGraphics.drawLine(240,100,245,95);       // Arrow

            offScreenGraphics.drawLine(75,155,75,210);         // Logic to Z_MUX
            offScreenGraphics.drawLine(75,155,70,160);         // Arrow
            offScreenGraphics.drawLine(75,155,80,160);         // Arrow

            offScreenGraphics.drawString("Cond.",132,319);
            offScreenGraphics.drawString("BT",170,319);
            offScreenGraphics.drawString("mOPs",195,319);
            offScreenGraphics.drawString("ADDR",230,319);

            offScreenGraphics.drawLine(75,270,75,350);         // Z_MUX to Micro Memory
            offScreenGraphics.drawLine(75,350,145,350);                // Z_MUX to Micro Memory
            offScreenGraphics.drawLine(145,350,145,320);       // Z_MUX to Micro Memory
            offScreenGraphics.drawLine(75,270,70,275);
            offScreenGraphics.drawLine(75,270,80,275);

            offScreenGraphics.drawLine(175,365,175,320);       // Logic to Micro Memory
            offScreenGraphics.drawLine(175,365,10,365);                // Logic to Micro Memory
            offScreenGraphics.drawLine(10,365,10,123);         // Logic to Micro Memory
            offScreenGraphics.drawLine(10,123,45,123);         // Logic to Micro Memory
            offScreenGraphics.drawLine(45,123,40,118);
            offScreenGraphics.drawLine(45,123,40,128);

            offScreenGraphics.drawLine(105,115,125,115);       // Logic to Addr_MUX S0
            offScreenGraphics.drawLine(125,115,120,110);       // Arrow
            offScreenGraphics.drawLine(125,115,120,120);       // Arrow

            offScreenGraphics.drawLine(105,140,125,140);       // Logic to Addr_MUX S1
            offScreenGraphics.drawLine(125,140,120,135);       // Arrow
            offScreenGraphics.drawLine(125,140,120,145);       // Arrow

            offScreenGraphics.drawLine(208,320,208,375);       // Micro-ops
            offScreenGraphics.drawLine(208,375,203,370);       // Arrow
            offScreenGraphics.drawLine(208,375,213,370);       // Arrow

            offScreenGraphics.drawLine(242,365,242,320);       // Micro Memory to Addr_MUX
            offScreenGraphics.drawLine(242,365,325,365);       // Micro Memory to Addr_MUX
            offScreenGraphics.drawLine(325,365,325,65);       // Micro Memory to Addr_MUX
            offScreenGraphics.drawLine(325,65,195,65);       // Micro Memory to Addr_MUX
            offScreenGraphics.drawLine(195,65,195,100);       // Micro Memory to Addr_MUX
            offScreenGraphics.drawLine(195,100,190,95);       // Arrow
            offScreenGraphics.drawLine(195,100,200,95);       // Arrow

            offScreenGraphics.drawString("S1",129,120);                // S0 on Addr_MUX
            offScreenGraphics.drawString("S0",129,144);                // S1 on Addr_MUX

            paintIRPath( offScreenGraphics );
            paintAddressMuxSignals( offScreenGraphics );
            paintClock( offScreenGraphics );
            paintConditionMuxSignals( offScreenGraphics );
            paintCurrentSignals( offScreenGraphics );

            offScreenGraphics.setFont( bld );

            offScreenGraphics.setColor( Color.black );
            offScreenGraphics.drawString("+1",292,172);
            offScreenGraphics.drawString("MAP",138,50);
            offScreenGraphics.drawString("REGISTER",165,202);
            offScreenGraphics.drawString("Microcode",165,274);
            offScreenGraphics.drawString("Memory",171,288);
            offScreenGraphics.drawString("MUX",67,243);                // Z_Mux label
            offScreenGraphics.drawString("MUX",183,129);       // Addr_Mux label
            offScreenGraphics.drawString("Logic",60,130);      // Logic label

            offScreenGraphics.setFont( bits );

            paintIRMapValue( offScreenGraphics );
            paintAddressRegisterValue( offScreenGraphics );
            paintCurrentConditionValue( offScreenGraphics );
            paintCurrentBTValue( offScreenGraphics );
            paintCurrentNextAddressValue( offScreenGraphics );
            paintAddressMuxValue( offScreenGraphics );
            paintUpperLogicSelectValue( offScreenGraphics );
            paintLowerLogicSelectValue( offScreenGraphics );

            paintDots( offScreenGraphics );

            g.drawImage( offScreenImage, 0, 0, this );   // used for double buffering

            offScreenGraphics.dispose();
         }

         public void paintIRPath( Graphics g )
         {
            g.setColor( irPathEnabled ? Color.red : Color.black );
            g.drawString( "IR[3..0]00", 129, 15 );

            g.drawLine(150,20,150,35);         // IR_Input to MAP
            g.drawLine(150,35,145,30);         // Arrow
            g.drawLine(150,35,155,30);         // Arrow
         }

         public void paintAddressMuxValue( Graphics g )
         {
            g.drawString( AssemblyInstruction.toNumberString( addressMux, 2,
               6 ), 178, 145 );
         }

         public void paintUpperLogicSelectValue( Graphics g )
         {
            g.drawString( AssemblyInstruction.toNumberString( ( 
               logicSelect & 0x2 ) >> 1, 2, 1 ), 97, 120 );
         }

         public void paintLowerLogicSelectValue( Graphics g )
         {
            g.drawString( AssemblyInstruction.toNumberString( 
               logicSelect & 0x1, 2, 1 ), 97, 144 );
         }

         public void paintAddressRegisterValue( Graphics g )
         {
            g.drawString( AssemblyInstruction.toNumberString(
               addressRegister, 2, 6 ), 178, 216 );
         }

         public void paintCurrentNextAddressValue( Graphics g )
         {
            int currentMC = microcode[ currentAddress ];
            int currentNextAddress = currentMC & ADDR_MASK;

            if ( currentNextAddress == ADDR_X )
            {
               g.drawString( "XXXXXX", 222, 308 );
            }
            else
            {
               g.drawString( AssemblyInstruction.toNumberString(
                  currentNextAddress, 2, 6 ), 226, 308 );
            }

         }

         public void paintCurrentBTValue( Graphics g )
         {
            int currentMC = microcode[ currentAddress ];
            int currentBT = currentMC & BT_MASK;

            g.drawString( AssemblyInstruction.toNumberString(
               currentBT >> 28, 2, 1 ), 173, 308 );
         }

         public void paintCurrentConditionValue( Graphics g )
         {
            int currentMC = microcode[ currentAddress ];
            int currentCondition = currentMC & COND_MASK;

            if ( currentCondition == COND_X )
            {
               g.drawString( "XX", 138, 308 );
            }
            else
            {
               g.drawString( AssemblyInstruction.toNumberString(
                  currentCondition >> 29, 2, 2 ), 138, 308 );
            }

         }

         public void paintIRMapValue( Graphics g )
         {
            g.drawString( AssemblyInstruction.toNumberString(
               irMap, 2, 6 ), 133, 63 );
         }

         public void paintCurrentSignals( Graphics g )
         {
            g.setColor( currentARPC ? Color.red : Color.black );
            g.drawString( "ARPC", 140, 385);      //Micro-OPs

            g.setColor( currentARIN ? Color.red : Color.black );
            g.drawString("ARIN",140,395);

            g.setColor( currentARDT ? Color.red : Color.black );
            g.drawString("ARDT",140,405);

            g.setColor( currentPCIN ? Color.red : Color.black );
            g.drawString("PCIN",140,415);

            g.setColor( currentPCDT ? Color.red : Color.black );
            g.drawString("PCDT",140,425);

            g.setColor( currentDRM ? Color.red : Color.black );
            g.drawString("DRM",175,385);

            g.setColor( currentDRAC ? Color.red : Color.black );
            g.drawString("DRAC",175,395);

            g.setColor( currentIRDR ? Color.red : Color.black );
            g.drawString("IRDR",175,405);

            g.setColor( currentRAC ? Color.red : Color.black );
            g.drawString("RAC",175,415);

            g.setColor( currentZALU ? Color.red : Color.black );
            g.drawString("ZALU",175,425);

            g.setColor( currentTRDR ? Color.red : Color.black );
            g.drawString("TRDR",175,435);

            g.setColor( currentACDR ? Color.red : Color.black );
            g.drawString("ACDR",216,385);

            g.setColor( currentACR ? Color.red : Color.black );
            g.drawString("ACR",216,395);

            g.setColor( currentPLUS ? Color.red : Color.black );
            g.drawString("PLUS",216,405);

            g.setColor( currentMINU ? Color.red : Color.black );
            g.drawString("MINU",216,415);

            g.setColor( currentACIN ? Color.red : Color.black );
            g.drawString("ACIN",216,425);

            g.setColor( currentACZO ? Color.red : Color.black );
            g.drawString("ACZO",216,435);

            g.setColor( currentAND ? Color.red : Color.black );
            g.drawString("AND",252,385);

            g.setColor( currentOR ? Color.red : Color.black );
            g.drawString("OR",252,395);

            g.setColor( currentXOR ? Color.red : Color.black );
            g.drawString("XOR",252,405);

            g.setColor( currentNOT ? Color.red : Color.black );
            g.drawString("NOT",252,415);

            g.setColor( currentMDR ? Color.red : Color.black );
            g.drawString("MDR",252,425);
         }

         public void paintConditionMuxSignals( Graphics g )
         {
            g.setColor( hw1Enabled ? Color.red : Color.black );
            g.drawString( "0", 49, 225 );          // 0 on Z_Mux
            g.drawLine( 45, 221, 31, 221 );         // Input 0 on Z_MUX
            g.drawString( "1", 24, 225 );          // 1 on Z_Mux

            g.setColor( zEnabled ? Color.red : Color.black );
            g.drawString( "1", 49, 245 );          // 1 on Z_Mux
            g.drawLine( 45, 241, 31, 241 );         // Input 1 on Z_MUX
            g.drawString( "Z", 24, 245 );          // Z on Z_Mux

            g.setColor( notZEnabled ? Color.red : Color.black );
            g.drawString( "2", 49, 265 );          // 2 on Z_Mux
            g.drawLine( 45, 262, 31, 262 );         // Input 2 on Z_MUX
            g.drawString( "Z", 24, 265 );          // /Z on Z_Mux
            g.drawString( "/", 20, 265 );          // /Z on Z_Mux
         }

         public void paintAddressMuxSignals( Graphics g )
         {
            g.setColor( currAddrP1Enabled ? Color.red : Color.black );
            g.drawString( "0", 239, 112 );         // 0 on Addr_MUX

            g.setColor( nextAddrEnabled ? Color.red : Color.black );
            g.drawString( "1", 195, 112 );         // 1 on Addr_MUX

            g.setColor( irMapEnabled ? Color.red : Color.black );
            g.drawString( "2", 148, 112 );         // 2 on Addr_MUX
         }

         public void paintClock( Graphics g )
         {
            g.setColor( clkEnabled ? Color.red : Color.black );
            g.drawString("CLK",132,240);
            g.drawLine(140,230,140,220);       // Clock
            g.drawLine(140,215,137,220);       // Clock
            g.drawLine(140,215,143,220);       // Clock
         }

         public void paintDots( Graphics g )
         {
            g.setColor( Color.red );

            for ( int index = 0; index < currentDotLocation.length;
               index++ )
            {

               if ( currentDotEnabled[ index ] )
               {
                  g.fillRect( currentDotLocation[ index ].x - 3,
                     currentDotLocation[ index ].y - 3, 7, 7 );
               }

            }

         }

         private Image offScreenImage = null;
      };

}
