import java.awt.*;
import java.awt.event.*;
import java.util.*;

public
class Memory
   extends Frame
   implements AdjustmentListener, ActionListener
{

   public Memory( Frame parent, String windowTitle )
   {
      super( windowTitle );
		
      CPUBox = ( CPU ) parent;

      clear();
				
      MenuBar mbar = new MenuBar();
      setMenuBar( mbar );
		
      Menu type = new Menu( "Type" );
      
      viewHex = new MenuItem( "View memory in HEX" );
      viewHex.addActionListener(this);
      type.add( viewHex );

      viewBin = new MenuItem( "View memory in BINARY" );
      viewBin.addActionListener(this);
      type.add( viewBin );

      editMemoryMenuItem = new MenuItem( "Edit Memory" );
      editMemoryMenuItem.addActionListener( this );

      fillMemoryMenuItem = new MenuItem( "Fill Memory" );
      fillMemoryMenuItem.addActionListener( this );

      clearMemoryMenuItem = new MenuItem( "Clear Memory & I/O" );
      clearMemoryMenuItem.addActionListener( this );

      editIOMenuItem = new MenuItem("Edit I/O Port");
      editIOMenuItem.addActionListener( this );

      editMenu = new Menu( "Edit" );
      editMenu.add( editMemoryMenuItem );
      editMenu.add( fillMemoryMenuItem );
      editMenu.add( clearMemoryMenuItem );
      editMenu.add( editIOMenuItem );

      Menu view = new Menu( "View" );
      
      a2047 = new MenuItem( "Address 0000h - 07FFh (0 - 2047)" );	      
      a2047.addActionListener(this); 	
      view.add( a2047 );

      a4095 = new MenuItem( "Address 0800h - 0FFFh (2048 - 4095)" );	
      a4095.addActionListener(this);
      view.add( a4095 );
 
      a6143 = new MenuItem( "Address 1000h - 17FFh (4096 - 6143)" );
      a6143.addActionListener(this); 	
      view.add( a6143 );

      a8191 = new MenuItem( "Address 1800h - 1FFFh (6144 - 8191)" );	
      a8191.addActionListener(this);
      view.add( a8191 );

      a10239 = new MenuItem( "Address 2000h - 27FFh (8192 - 10239)" );
      a10239.addActionListener(this);
      view.add( a10239 );

      a12287 = new MenuItem( "Address 28FFh - 2FFFh (10240 - 12287)" );
      a12287.addActionListener(this);
      view.add( a12287 );

      a14335 = new MenuItem( "Address 3000h - 37FFh (12288 - 14335)" );
      a14335.addActionListener(this);
      view.add( a14335 );

      a16383 = new MenuItem( "Address 3800h - 3FFFh (14336 - 16383)" );
      a16383.addActionListener(this);
      view.add( a16383 );

      a18431 = new MenuItem( "Address 4000h - 47FFh (16384 - 18431)" );
      a18431.addActionListener(this);
      view.add( a18431 );

      a20479 = new MenuItem( "Address 4800h - 4FFFh (18432 - 20479)" );
      a20479.addActionListener(this);
      view.add( a20479 );

      a22527 = new MenuItem( "Address 5000h - 57FFh (20480 - 22527)" );
      a22527.addActionListener(this);
      view.add( a22527 );

      a24575 = new MenuItem( "Address 5800h - 5FFFh (22528 - 24575)" );
      a24575.addActionListener(this);
      view.add( a24575 );

      a26623 = new MenuItem( "Address 6000h - 67FFh (24576 - 26623)" ); 
      a26623.addActionListener(this);
      view.add( a24575 );

      a28671 = new MenuItem( "Address 6800h - 6FFFh (26624 - 28671)" );
      a28671.addActionListener(this);
      view.add( a28671 );

      a30719 = new MenuItem( "Address 7000h - 77FFh (28672 - 30719)" );
      a30719.addActionListener(this);
      view.add( a30719 );

      a32767 = new MenuItem( "Address 7800h - 7FFFh (30720 - 32767)" );
      a32767.addActionListener(this);
      view.add( a32767 );

      a34815 = new MenuItem( "Address 8000h - 87FFh (32768 - 34815)" );
      a34815.addActionListener(this); 
      view.add( a34815 );

      a36863 = new MenuItem( "Address 8800h - 8FFFh (34816 - 36863)" );
      a36863.addActionListener(this);
      view.add( a36863 );

      a38911 = new MenuItem( "Address 9000h - 97FFh (36864 - 38911)" );
      a38911.addActionListener(this);
      view.add( a38911 );

      a40959 = new MenuItem( "Address 9800h - 9FFFh (38912 - 40959)" );
      a40959.addActionListener(this);
      view.add( a40959 );

      a43007 = new MenuItem( "Address A000h - A7FFh (40960 - 43007)" );
      a43007.addActionListener(this); 	
      view.add( a43007 );

      a45055 = new MenuItem( "Address A800h - AFFFh (43008 - 45055)" );
      a45055.addActionListener(this);
      view.add( a45055 );

      a47103 = new MenuItem( "Address B000h - B7FFh (45056 - 47103)" );
      a47103.addActionListener(this);
      view.add( a47103 );

      a49151 = new MenuItem( "Address B800h - BFFFh (47104 - 49151)" );
      a49151.addActionListener(this);
      view.add( a49151 );

      a51199 = new MenuItem( "Address C000h - C7FFh (49152 - 51199)" );
      a51199.addActionListener(this);
      view.add( a51199 );

      a53247 = new MenuItem("Address C800h - CFFFh (51200 - 53247)" );
      a53247.addActionListener(this);
      view.add( a53247 );

      a55295 = new MenuItem( "Address D000h - D7FFh (53248 - 55295)" );	
      a55295.addActionListener(this);
      view.add( a55295 );

      a57343 = new MenuItem( "Address D800h - DFFFh (55296 - 57343)" );
      a57343.addActionListener(this);
      view.add( a57343 );

      a59391 = new MenuItem( "Address E000h - E7FFh (57344 - 59391)" );
      a59391.addActionListener(this);
      view.add( a59391 );

      a61439 = new MenuItem( "Address E800h - EFFFh (59392 - 61439)" );
      a61439.addActionListener(this);
      view.add( a61439 );

      a63487 = new MenuItem( "Address F000h - F7FFh (61440 - 63487)" );
      a61439.addActionListener(this);
      view.add( a61439 );

      a65535 = new MenuItem( "Address F800h - FFFFh (63488 - 65535)" );
      a65535.addActionListener(this);
      view.add( a65535 );

      view.addSeparator();

      closeWin = new MenuItem( "Close Window" );
      closeWin.addActionListener(this); 
      view.add( closeWin );

      mbar.add( view );
      mbar.add( editMenu );
      mbar.add( type );

      vert = new Scrollbar( Scrollbar.VERTICAL, 0, 0, 0, 670 );
      add( "East", vert );
	
      vert.addAdjustmentListener( this );

      top = 0;
      bottom = 2048;

      addWindowListener(

            new WindowAdapter()
            {

               public void windowClosing( WindowEvent e )
               {
                  setVisible( false );
               }

            }

         );

      setSize( 315, 295 );
   }

   public void adjustmentValueChanged( AdjustmentEvent ae )
   {
      scrollvalue = 15 * vert.getValue();
      repaint();
   }

   public void actionPerformed( ActionEvent e )
   {
      Object eventSource = e.getSource();

      if (eventSource == a2047 ) 
      { 
         top = 0;
         bottom = 2048;
         repaint();

      }
      else if (eventSource == a4095)
      {
			top=2048;
			bottom=4096;
			repaint();

      }
      else if (eventSource == a6143)
      { 
			top=4096;
			bottom=6144;
			repaint();

      }
      else if (eventSource == a8191)
      {
			top=6144;
			bottom=8192;
			repaint();

      }	
      else if(eventSource == a10239)
      { 
			top=8192;
			bottom=10240;
			repaint();

      }
      else if(eventSource == a12287)
      {
			top=10240;
			bottom=12288;
			repaint(); 

      }
      else if(eventSource == a14335)
      { 
			top=12288;
			bottom=14336;
			repaint();	 

      }
      else if(eventSource == a16383)
      {
			top=14336;
			bottom=16384;
			repaint();	 

      }
      else if(eventSource == a18431)
      { 
			top=16384;
			bottom=18432;
			repaint(); 

      }
      else if(eventSource == a20479)
      {
			top=18432;
			bottom=20480;
			repaint();	

      }
      else if(eventSource == a22527)
      { 
                        top=20480;
			bottom=22528;
			repaint();	

      }
      else if(eventSource == a24575)
      {
			top=22528;
			bottom=24576;
			repaint();	 

      }
      else if(eventSource == a26623)
      {
			top=24576;
			bottom=26624;
			repaint();	

      }
      else if(eventSource == a28671)
      { 
			top=26624;
			bottom=28672;
			repaint();	

      }
      else if(eventSource == a30719)
      {
			top=28672;
			bottom=30720;
			repaint();

      }
      else if(eventSource == a32767)
      { 
			top=30720;
			bottom=32768;
			repaint();	

      }
      else if(eventSource == a34815)
      {
			top=32768;
			bottom=34816;
			repaint();

      }
      else if(eventSource == a36863)
      {
			top=34816;
			bottom=36864;
			repaint();	

      }
      else if(eventSource == a38911)
      { 
			top=36864;
			bottom=38912;
			repaint();	 

      }
      else if(eventSource == a40959)
      {
			top=38912;
			bottom=40960;
			repaint();	

      }
      else if(eventSource == a43007)
      { 
			top=40960;
			bottom=43008;
			repaint();	

      }
      else if(eventSource == a45055)
      {
			top=43008;
			bottom=45056;
			repaint();	

      }
      else if(eventSource == a47103)
      {
			top=45056;
			bottom=47104;
			repaint();	 

      }
      else if(eventSource == a49151)
      {
			top=47104;
			bottom=49152;
			repaint();	 

      }
      else if(eventSource == a51199)
      { 
			top=49152;
			bottom=51200;
			repaint();	

      }
      else if(eventSource == a53247)
      {
			top=51200;
			bottom=53248;
			repaint();	

      }
      else if(eventSource == a55295)
      { 
			top=53248;
			bottom=55296;
			repaint();	

      }
      else if(eventSource == a57343)
      {
			top=55296;
			bottom=57344;
			repaint();	 

      }
      else if(eventSource == a59391)
      {
			top=57344;
			bottom=59392;
			repaint();	

      }
      else if(eventSource == a61439)
      { 
			top=59392;
			bottom=61440;
			repaint();	

      }
      else if(eventSource == a63487)
      {
			top=61440;
			bottom=63488;
			repaint();	 

      }
      else if(eventSource == a65535)
      {
			top=63488;
			bottom=65536;
			repaint();	

      }
      else if(eventSource == closeWin)
      {
                        setVisible( false );

      }
      else if(eventSource == viewHex)
      {
			showType = 1;
			repaint();

      }
      else if(eventSource == viewBin)
      {
			showType = 0;
			repaint();

      }
      else if ( eventSource == editMemoryMenuItem )
      {
         editMemory = new EditMemoryDialog( this, "Edit Memory", true );

	 Dimension screenSize = Toolkit.getDefaultToolkit().
	    getScreenSize();
         Dimension editMemoryDialogSize = editMemory.getSize();
         Point editMemoryDialogLocation = new Point( ( screenSize.width -
            editMemoryDialogSize.width ) / 2, ( screenSize.height -
            editMemoryDialogSize.height ) / 2 );

         editMemory.setLocation( editMemoryDialogLocation );
         editMemory.setVisible( true );
      }
      else if ( eventSource == fillMemoryMenuItem )
      {
         fillMemory = new FillMemoryDialog( this, "Fill Memory", true );

	 Dimension screenSize = Toolkit.getDefaultToolkit().
	    getScreenSize();
         Dimension fillMemoryDialogSize = fillMemory.getSize();
         Point fillMemoryDialogLocation = new Point( ( screenSize.width -
            fillMemoryDialogSize.width ) / 2, ( screenSize.height -
            fillMemoryDialogSize.height ) / 2 );

         fillMemory.setLocation( fillMemoryDialogLocation );
         fillMemory.setVisible( true );
      }
      else if ( eventSource == clearMemoryMenuItem )
      {
         clear();
         repaint();
      }
      else if ( eventSource == editIOMenuItem )
      {
         editMemory = new EditMemoryDialog( this, "Edit I/O Port", true );

	 Dimension screenSize = Toolkit.getDefaultToolkit().
	    getScreenSize();
         Dimension editMemoryDialogSize = editMemory.getSize();
         Point editMemoryDialogLocation = new Point( ( screenSize.width -
            editMemoryDialogSize.width ) / 2, ( screenSize.height -
            editMemoryDialogSize.height ) / 2 );

         editMemory.setLocation( editMemoryDialogLocation );
         editMemory.setVisible( true );
      }	 
   }

   public void paint( Graphics g )
   {
      Font boldFont = new Font( "SansSerif", Font.BOLD, 11 );
      Font plainFont = new Font( "SansSerif", Font.PLAIN, 11 );

      boolean binaryViewMode = ( showType == 0 );

      for ( int contentsIndex = top; contentsIndex < bottom; contentsIndex += 4 )
      {
         int yPosition = ( 5 * contentsIndex ) - scrollvalue + 65 - ( 5 * top );
         int nybbleStringBase = ( binaryViewMode ? 2 : 16 );
         int nybbleStringLength = ( binaryViewMode ? 4 : 1 );

         g.setFont( boldFont );
         g.drawString( contentsIndex + ":", 5, yPosition );

         for ( int columnCounter = 0; columnCounter < 4; columnCounter++ )
         {
            long upperNybble = ( contents[ contentsIndex + columnCounter ]
               & 0xf0 ) >> 4;
            long lowerNybble = contents[ contentsIndex + columnCounter ] &
               0xf;

            if ( ( contentsIndex + columnCounter ) == CPUBox.simulationStartNumber )
            {
               g.setFont( boldFont );
            }
            else
            {
               g.setFont( plainFont );
            }

            g.drawString( AssemblyInstruction.toNumberString( upperNybble,
               nybbleStringBase, nybbleStringLength ).toUpperCase() + "  "
               + AssemblyInstruction.toNumberString( lowerNybble, 
               nybbleStringBase, nybbleStringLength ).toUpperCase(), 47 + (
               62 * columnCounter ), yPosition );
         }

      }

   }

   public void clear()
   {

      for ( int index = 0; index < MEMORY_SIZE; index++ )
      {
         contents[ index ] = 0;
      }
  
    CPU.theBox.IO = "00000000";   
    CPUBox.canvasRepaint();
   }

   public void dispose()
   {
      editMemory.dispose();
      fillMemory.dispose();
      super.dispose();
   }

   public short read( int address )
   {

      if ( ( address < 0 ) || ( address >= MEMORY_SIZE ) )
      {
         return ( -1 );
      }
      else
      {
         return ( contents[ address ] );
      }

   }

   public boolean write( int address, short data )
   {

      if ( ( address < 0 ) || ( address >= MEMORY_SIZE ) || ( data < 0 ) ||
         ( data > 0xff ) )
      {
         return ( false );
      }
      else
      {
         contents[ address ] = data;
         CPU.theBox.IOint = contents[65535];
         CPU.theBox.IO = AssemblyInstruction.toNumberString(CPU.theBox.IOint,2,8);
	 CPUBox.canvasRepaint();
         return ( true );
      }

   }

   public String[] readBinaryNybbleStringArray( int address )
   {
      return ( toBinaryNybbleStringArray( read( address ) ) );
   }

   public boolean writeBinaryNybbleStringArray( int address, String[]
      dataStringArray )
   {
      short data = fromBinaryNybbleStringArray( dataStringArray );
      
      return ( write( address, data ) );
   }

   public static short fromBinaryNybbleStringArray( String[] nybbleString )
   {

      if ( ( nybbleString != null ) && ( nybbleString.length == 2 ) )
      {

         try
         {
            int upperNybble = Integer.valueOf( nybbleString[ 0 ], 2 ).
               intValue();
            int lowerNybble = Integer.valueOf( nybbleString[ 1 ], 2 ).
               intValue();

            return ( ( short ) ( ( upperNybble * 0x10 ) + lowerNybble ) );
         }
         catch ( NumberFormatException e )
         {
            return ( -1 );
         }

      }
      else
      {
         return ( -1 );
      }

   }
            
   public static String[] toBinaryNybbleStringArray( short byteShort )
   {

      if ( ( byteShort >= 0 ) && ( byteShort <= 0xff ) )
      {
         String upperNybble = AssemblyInstruction.toNumberString( byteShort
            / 0x10, 2, 4 );
         String lowerNybble = AssemblyInstruction.toNumberString( byteShort
            % 0x10, 2, 4 );
         String[] binaryNybble = { upperNybble, lowerNybble };

         return ( binaryNybble );
      }
      else
      {
         return ( null );
      }

   }

   public void disableComponents()
   {

      if ( editMemory != null )
      {
         editMemory.dispose();
      }

      if ( fillMemory != null )
      {
         fillMemory.dispose();
      }

      editMenu.setEnabled( false );
      editMemoryMenuItem.setEnabled( false );
      fillMemoryMenuItem.setEnabled( false );
      clearMemoryMenuItem.setEnabled( false );
   }

   public void enableComponents()
   {
      editMenu.setEnabled( true );
      editMemoryMenuItem.setEnabled( true );
      fillMemoryMenuItem.setEnabled( true );
      clearMemoryMenuItem.setEnabled( true );
   }

   private int scrollvalue = 0; 
   private int showType = 0;
   private int top;
   private int bottom;

   private Scrollbar vert;

   private Menu editMenu;
   private MenuItem editMemoryMenuItem;
   private MenuItem fillMemoryMenuItem;
   private MenuItem clearMemoryMenuItem;
   private MenuItem editIOMenuItem;

   private MenuItem a2047, a4095, a6143, a8191, a10239, a12287, a14335, a16383, a18431;
   private MenuItem a20479, a22527, a24575, a26623, a28671, a30719, a32767, a34815, a36863;
   private MenuItem a38911, a40959, a43007, a45055, a47103, a49151, a51199, a53247;
   private MenuItem a55295, a57343, a59391, a61439, a63487, a65535; 

   private MenuItem closeWin, viewHex, viewBin;

   private CPU CPUBox;
   private EditMemoryDialog editMemory;
   private FillMemoryDialog fillMemory;
   private EditMemoryDialog editIO;

   public short[] contents = new short[ MEMORY_SIZE ];

   public static final int MEMORY_SIZE = 65536;
}
