/****(c) 2020. A. Gerbessiotis. See ../KAagcopy.txt ****/
/*******************************************************/
#include <mpi.h>
#define AIBEGIN(X)         ( MPI_Init(&argc,&argv), mpi_basetime=MPI_Wtime() )
#define AIEND()            ( MPI_Barrier(MPI_COMM_WORLD),MPI_Finalize() )
#define AIABORT(X)         ( MPI_Abort(MPI_COMM_WORLD, __LINE__ ) )
#define AIBSPINIT(X,Y,Z)   {;}
#define AITIME()           (MPI_Wtime()-mpi_basetime)
#define AIPID()            ((mpi_pid==-1)?(MPI_Comm_rank(MPI_COMM_WORLD,\
                                       &mpi_pid),mpi_pid):mpi_pid)
#define AINPROCS()         ((mpi_nprocs==-1)?(MPI_Comm_size(MPI_COMM_WORLD,\
                                       &mpi_nprocs),mpi_nprocs):mpi_nprocs)    

#define AIPUT(X,Y,Z,W,R)   MPI_Put((char *)(Y), (R), MPI_CHAR, (X),(W),\
                                                (R), MPI_CHAR, win)
#define AIGET(X,Y,W,Z,R)   MPI_Get((char *)(Z), (R), MPI_CHAR, (X),(W),\
                                                (R), MPI_CHAR, win)
#define AIHPPUT(X,Y,Z,W,R) MPI_Put((char *)(Y), (R), MPI_CHAR, (X),(W),\
                                                (R), MPI_CHAR, win)
#define AIHPGET(X,Y,W,Z,R) MPI_Get((char *)(Z), (R), MPI_CHAR, (X),(W),\
                                                (R), MPI_CHAR, win )

#define AIREGISTER(X,Y)    MPI_Win_create((char *)(X), (Y), 1,\
                                   MPI_INFO_NULL,MPI_COMM_WORLD,&win)  
#define AIDEREGISTER(X)    MPI_Win_free(&win)  
#define AICOMMIT()	   {;}
#define AICOMSTART()       MPI_Win_fence(0,win)
#define AICOMEND()         MPI_Win_fence(0,win)
#define AIBARRIER()        MPI_Barrier(MPI_COMM_WORLD)
#define AISYNC()           MPI_Win_fence(0,win),MPI_Barrier(MPI_COMM_WORLD) 

#define AIMPUT(X,Y,Z,W,R)   MPI_Put((char *)(Y),(R),MPI_CHAR,(X),(W),\
                                                (R),MPI_CHAR,aiw[ais((void *)Z)])
#define AIMGET(X,Y,W,Z,R)   MPI_Get((char *)(Z),(R),MPI_CHAR,(X),(W),\
                                                (R),MPI_CHAR,aiw[ais((void *)Y)])
#define AIMHPPUT(X,Y,Z,W,R) MPI_Put((char *)(Y),(R),MPI_CHAR,(X),(W),\
                                                (R),MPI_CHAR,aiw[ais((void *)Z)]) 
#define AIMHPGET(X,Y,W,Z,R) MPI_Get((char *)(Z),(R),MPI_CHAR,(X),(W),\
                                                (R),MPI_CHAR,aiw[ais((void *)Y)])

#define AIMREGISTER(X,Y)   MPI_Win_create((char *)(X),(Y),1,MPI_INFO_NULL,\
                                              MPI_COMM_WORLD,&aiw[aii((void*)X)]) 
#define AIMDEREGISTER(X)   MPI_Win_free(&aiw[aid(X)])
#define AIMCOMMIT()	   {;}
#define AIMCOMSTART(Z)     MPI_Win_fence(0,aiw[ais((void *)Z)])
#define AIMCOMEND(Z)       MPI_Win_fence(0,aiw[ais((void *)Z)])
#define AIMBARRIER()       MPI_Barrier(MPI_COMM_WORLD)
#define AIMSYNC()          {;}  /* WHY ???? */

/*
 * #define AIPUT         bsp_put          #define AIMPUT         bsp_put
 * #define AIGET         bsp_get          #define AIMGET         bsp_get
 * #define AIHPPUT       bsp_hpput        #define AIMHPPUT       bsp_hpput
 * #define AIHPGET       bsp_hpget        #define AIMHPGET       bsp_hpget
 * #define AIREGISTER    bsp_push_reg     #define AIMREGISTER    bsp_push_reg
 * #define AIDEREGISTER  bsp_pop_reg      #define AIMDEREGISTER  bsp_pop_reg
 * #define AICOMMIT()    bsp_sync()       #define AIMCOMMIT()    bsp_sync()
 * #define AICOMSTART()  {;}              #define AIMCOMSTART(Z) {;}
 * #define AICOMEND()    bsp_sync()       #define AIMCOMEND(Z)   bsp_sync()
 * #define AIBARRIER()   bsp_sync()       #define AIMBARRIER()   bsp_sync()
 * #define AISYNC()      bsp_sync()       #define AIMSYNC()      bsp_sync()
 */

extern MPI_Comm comm;
extern MPI_Win  win;
extern MPI_Win  aiw[];    /* window */
extern void*    bspmpi[];
extern int bspmpi_max ;
extern int bspmpi_first;
extern int bspmpicur_max ;
extern int mpi_pid ;
extern int mpi_nprocs ;
extern double mpi_bsp_l ;
extern double mpi_bsp_g ;
extern double mpi_basetime;

int  ais (void *); /* search */
int  aii (void *); /* insert */
int  aid (void *); /* delete */
