/****(c) 2020. A. Gerbessiotis & C. Siniolakis. See KAagcscp.txt ****/
/********************************************************************/
#include <memory.h>
#include <stdlib.h>
#include "avgaii.h"
#include "prdx.h"

#define power2(X)  ((int)((unsigned int)(1)<<(X)))

int ceilinglgbase2(int x) 
{
  register int l;
  if (x <= 1) {
    return(0);
  }
  else {
    x--;l=1;
    while (x>1) {
      x=(x>>1);
      l++;
    }
    return(l);
  }
}

int bspbtndat (idata *src,idata *t,int n) /* t=bitonic(src,n per proc) */
{
  idata *aux1,*aux2;
  register int  nprocs,pid,pit,size;
  register int  i,offset,mid,np,flag,ii,jj,kk;
  size=sizeof(idata);
  if ((n <= 0)||(size <= 0)) { 
    t=NULL; return n;
  }
  pid=AIPID(); nprocs=AINPROCS();
  aux1=(void*) malloc(n*size);
  aux2=(void*) malloc(n*size);
  AIREGISTER((char*)aux2,n*size);  
  AICOMMIT(); 
  memcpy(t,src,n*size);
  np=(int)power2((int )ceilinglgbase2((int )nprocs));
  i=2; 
  while (i <= np){
    offset=(int)power2((int)ceilinglgbase2(i)-1); 
    mid=i*FLOOR(pid,i)+(i-offset);
    flag =TRUE;
    while (offset > 0){
      if (flag){ 
       pit=(mid<<1)-pid-1; 
       flag=FALSE; 
      }
      else 
       pit=(pid<mid)?(pid+offset):(pid-offset);

      AICOMSTART();
      if ((pit >= 0 ) && (pit < nprocs)){
        AIHPPUT(pit,t,aux2,0,n*size); 
      }
      AICOMEND();
      if ((pit >= 0 ) && (pit < nprocs)){
         if (pid < mid){
           ii=jj=kk=0;
           while(kk<n){
              if (t[ii]<aux2[jj]){
                aux1[kk]=t[ii];ii++;kk++;
              }
              else {
                aux1[kk]=aux2[jj];jj++;kk++;
              }
           }
         }
         else  {
           ii=jj=kk=n-1; 
           while(kk>=0){
              if(aux2[ii]>=t[jj]){
                aux1[kk] = aux2[ii]; ii--;kk--;
              }
              else {
                aux1[kk] = t[jj]; jj--;kk--;
              }
           }
         }
         memcpy(t,aux1,n*size);
      } 
      offset=(offset>>1);
      mid=(pid<mid)?(mid-offset):(mid+offset); 
    }
    i=(i<<1);
  } 
  AIDEREGISTER(aux2); 
  free((void*)aux2); free((void*)aux1);   
  return(n);    
} 
