/****(c) 2020. A. Gerbessiotis. See ../KAagcopy.txt ****/
/*******************************************************/
#include <memory.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>


void i32rdx4(unsigned int *src,int n)
{
  unsigned int *des;
  int   cnt[256];
  register int          i,r;
  register int          j,idx;
  
  if (n <= 1) return;
  des= (unsigned int *) malloc(n*sizeof(unsigned int));
  r = 256;
  memset(cnt,0,r*sizeof(int)); 
  for (j=0;j<n;j++) cnt[src[j] & 0x000000FF]++; 
  for (i=1;i<r;i++) cnt[i] += cnt[i-1];
  for (j=n-1;j>=0;j--) {
      idx= --cnt[src[j] & 0x000000FF]; 
      des[idx]=src[j];
  }

  r = 256;
  memset(cnt,0,r*sizeof(int)); 
  for (j=0;j<n;j++)  cnt[(des[j] >> 8) & 0x000000FF ]++;
  for (i=1;i<r;i++) cnt[i] += cnt[i-1];
  for (j=n-1;j>=0;j--) {
      idx = --cnt[(des[j] >> 8) &  0x000000FF];
      src[idx] = des[j];
  }

  r = 256;
  memset(cnt,0,r*sizeof(int)); 
  for (j=0;j<n;j++)  cnt[(src[j] >> 16) & 0x000000FF ]++;
  for (i=1;i<r;i++) cnt[i] += cnt[i-1];
  for (j=n-1;j>=0;j--) {
      idx = --cnt[(src[j] >> 16) & 0x000000FF ];
      des[idx] = src[j];
  }

  r = 256;
  memset(cnt,0,r*sizeof(int)); 
  for (j=0;j<n;j++)  cnt[des[j] >> 24]++;
  for (i=1;i<r;i++) cnt[i] += cnt[i-1];
  for (j=n-1;j>=0;j--) {
      idx = --cnt[des[j] >> 24];
      src[idx] = des[j];
  }

  free((void *)des);
}
