/****(c) 2020. A. Gerbessiotis. See ../KAagcopy.txt ****/
/*******************************************************/
#include <memory.h>
#include <stdlib.h>
#include "avgaii.h"
#include "prdx.h"
#include <stdio.h>

#ifdef DEBUG_OETS
#define ELMNTS 8
void puint(idata *inp,int n,char *s,int debug)
{
 register int i,j,pid,nprocs;
 pid=AIPID();
 nprocs=AINPROCS();


  for(j=0;j<nprocs;j++) {
    AIBARRIER();
    if ((pid == j) &&(1==debug)) {
       fprintf(stdout,"[%2d]:%4s ",pid,s);
       for(i=0;i<ELMNTS;i++){
         fprintf(stdout,"%10d,", (idata) inp[i]);
       }
       fprintf(stdout,"...\n          ");
       for(i=n-ELMNTS;i<n;i++){
          fprintf(stdout,"%10d,", (idata) inp[i]);
       }
       fprintf(stdout,"\n");
       fflush(stdout);
    }
    AIBARRIER();
  }
}
#endif


void i32rdx4  (idata *, int )                               ;

#define M_alloc(x,y) (x)=(void *) malloc((y)*sizeof(char));

/* odd-even-based transposition sort for (sorted) lists */
/* n is the per processor integers ; assume n*nprocs is total*/
/* oid is 0 or 1  , pidmo is pid minus 1 */
int bspoets (idata *src,int n)
{
  idata    *aux0,*aux1;
  register int  nprocs,oid,pidmo,pid,size;
  register int  i,ii,jj,kk;
  size=sizeof(idata);
  if ((n <= 0)||(size <= 0)) { 
    return n;
  }
  i32rdx4(src,n);
  pid=AIPID(); nprocs=AINPROCS(); 
  oid=LEFT(pid,2); pidmo= nprocs-1;
  M_alloc(aux0,n*size); M_alloc(aux1,n*size);
  AIMREGISTER((char*)aux0,n*size);  
  AIMCOMMIT(); 
  AIMREGISTER((char*)aux1,n*size);  
  AIMCOMMIT(); 

  for(i=0;i<nprocs;i++) {

    if  (LEFT(i,2)==0) {   /* even iteration*/
      AIMCOMSTART((char*)aux1);
        if (( oid == 0) && ( pid < pidmo))
          AIMHPPUT(pid+1,src,aux1,0,n*size);
      AIMCOMEND((char*)aux1);

      AIMCOMSTART((char*)aux0);
        if (( oid == 1) && ( pid< nprocs))
          AIMHPPUT(pid-1,src,aux0,0,n*size);
      AIMCOMEND((char*)aux0);
#ifdef DEBUG_OETS
      AIBARRIER();
      if (oid==0) puint(aux0,n,"0 aux0",1);        /*******/
      if (oid==1) puint(aux1,n,"1 aux1",1);        /*******/
#endif
      if (( oid == 0) && ( pid < pidmo)) {
           ii=jj=kk=0;
           while(kk<n){
              if (src[ii]<= aux0[jj]){
                aux1[kk]=src[ii];ii++;kk++;
              }
              else {
                aux1[kk]=aux0[jj];jj++;kk++;
              }
           }
           memcpy(src,aux1,n*size);
      }
      if (( oid == 1) && ( pid < nprocs)) {
           ii=jj=kk=n-1;
           while(kk>=0){
              if (src[jj]>=aux1[ii]){
                aux0[kk]=src[jj];jj--;kk--;
              }
              else {
                aux0[kk]=aux1[ii];ii--;kk--;
              }
           }
           memcpy(src,aux0,n*size);
      }
     AIBARRIER();
#ifdef DEBUG_OETS
     puint(src,n,"src even",1);
#endif
    }       /* even iteration processing ends   here */
    else {  /* odd  iteration processing starts here */
      AIMCOMSTART((char*)aux0);
        if (( oid == 1) && ( pid < pidmo))
          AIMHPPUT(pid+1,src,aux0,0,n*size);
      AIMCOMEND((char*)aux0);
/*
      AI1BARRIER();
*/
      AIMCOMSTART((char*)aux1);
        if (( oid == 0) && ( pid < nprocs) && (pid > 0))
          AIMHPPUT(pid-1,src,aux1,0,n*size);
      AIMCOMEND((char*)aux1);
      AIBARRIER();  /* IS IT REALLY NEEDED ????????????????????????????? */
      if (( oid == 1) && ( pid < pidmo)) {
           ii=jj=kk=0;
           while(kk<n){
              if (src[ii]<= aux1[jj]){
                aux0[kk]=src[ii];ii++;kk++;
              }
              else {
                aux0[kk]=aux1[jj];jj++;kk++;
              }
           }
           memcpy(src,aux0,n*size);
      }
      if (( oid == 0) && ( pid < nprocs) && ( pid > 0)) {
           ii=jj=kk=n-1;
           while(kk>=0){
              if (src[jj]>=aux0[ii]){
                aux1[kk]=src[jj];jj--;kk--;
              }
              else {
                aux1[kk]=aux0[ii];ii--;kk--;
              }
           }
           memcpy(src,aux1,n*size);
      }
      AIBARRIER();  /* IS IT REALLY NEEDED ????????????????????????????? */
#ifdef DEBUG_OETS
      puint(src,n,"src  odd",1);
#endif
    }

   }
  AIMDEREGISTER((char*)aux1);  
  AIMDEREGISTER((char*)aux0);  
  free((void*)aux1); free((void*)aux0);
  return(n);
}





