/****(c) 2020. A. Gerbessiotis. See ../KAagcopy.txt ****/
/*******************************************************/
#include <string.h>
#include <stdlib.h>
#include "prdx.h"
#include "psrtai.h"
#include "seqo.h"
#define 	Mask(x, sbit, nbits) ((x >> sbit) & ~(UINT_MAX << nbits))

#define  VFF  256
#define  SIZE 1



void i21ins(idata *keys, int n)
{
 register idata *ip, *jp;
 register idata tmp;

 if (n <=1) return;

 for(jp=keys+1; jp<(keys+n); jp++) {
   tmp=*jp;
   ip=jp-1;
   while ( (ip>=keys) && ( *ip > tmp )) {
     *(ip+1) = *(ip);
     ip-=1;
   }
   *(ip+1)=tmp;
 }
}

void i22ins(idata *keys, int n)
{
 register idata *ip, *jp;
 register idata tmp;

 if (n <=1) return;

 for(jp=keys+1; jp<(keys+n); jp++) {
   tmp=*jp;
   for(ip=jp;ip > keys && (*(ip-1) > tmp); ip--){
     *(ip) = *(ip-1);
   }
   *(ip)=tmp;
 }
}


void A52dbh   (idata *keys, int n, int l,int r)
{
 register idata split,tmp;
 register int i,j;

 if (n<=1) return;
 i=l;j=r;
#if   SPLITTER == MIDDLE_KEY
 split=keys[(l+r)/2];
#elif SPLITTER == FIRST_KEY
 split=keys[l];
#elif SPLITTER == RANDOM_KEY
 split=keys[l+GRANDOM((r-l+1))];
#endif

 do {
   while (keys[i]<split) i++;
   while (split<keys[j]) j--;
   if (i <= j ) {
     tmp=keys[i];
     keys[i]=keys[j];
     keys[j]=tmp;
     i++;j--;
   }
 } while (i <= j);

 if (l < j) {
   if ((j-l) < THRESI16) {
     BASEI(&keys[l],(j-l+1));
   }
   else {
     A52dbh   (keys,n,l,j);
   }
 }
 if (i < r) {
   if ((r-i) < THRESI16) {
      BASEI  (&keys[i],(r-i+1));
   }
   else {
      A52dbh   (keys,n,i,r);
   }
 }
}

void i52dbh  (idata *keys, int n)
{
 if (n <= 1) return;
#if SPLITTER == RANDOM_KEY
 GSRANDOM();
#endif
 A52dbh   (keys,n,0,n-1);
}

void i63fbcm(idata *keys, int   n,int l,int r)
{
  register int  i,j;
  register idata pr,pm,tmp;

  if (n <= 1) return ;
  pr=keys[r];
#if SPLITTER == MIDDLE_KEY
  pm = keys[((l+r)/2 )];
#elif SPLITTER == FIRST_KEY
  pm = keys[l];
#elif SPLITTER == RANDOM_KEY
  pm = keys[(l+GRANDOM((r-l+1)))];
#endif
  tmp=pm;
  pm=pr;
  pr=tmp;
  i=l-1; 
  j=l  ; 
  for(j=l;j<r;j++) {
    if (keys[j]<=keys[r]) {
       i++;
       tmp=keys[j];
       keys[j]=keys[i];
       keys[i]=tmp;
    }
  }
  i++;
  tmp=keys[r];
  keys[r]=keys[i];
  keys[i]=tmp;

  if ((i-l) < THRESI16)
     BASEI(&keys[l],(i-l));
  else
     i63fbcm(&keys[l],i-l,0,i-l-1);
  if ((r-i) < THRESI16)
     BASEI(&keys[(i+1)],(r-i));
   else
     i63fbcm(&keys[(i+1)],r-i,0,r-i-1);

}
           
void i63fbc(idata *keys, int n)
{
  if (n <= 1) return ;
#if SPLITTER == RANDOM_KEY
 GSRANDOM();
#endif
  i63fbcm(keys,n,0,n-1);
}

void i30mi (idata *akeys,int n)
{
  register idata *DES,*SRC;
  register int M;
  register idata *temp,*tmp, *s, *t;
  register int  i,j,k,ii,jj,a,b;
  register idata *keys= akeys;

  if (n<=1) return;
  temp=(idata*)malloc(n*sizeof(idata));

  a=n/TMERGEI;b=TMERGEI;
  for(j=0;j<a;j++,keys+=b) {
      BASEI (keys,TMERGEI);
  }
  if (a*TMERGEI < n)
    BASEI (keys,n-a*TMERGEI);

  keys=akeys; /* recover original keys */

  s=keys;t=temp;
  for(a=TMERGEI;a<n;a=(a+a)) { 
     for(b=0;b<n;b+=(a+a)) {
         ii=MIN((b+(a+a)),n);jj=MIN((b+a),n);      
         i=jj;j=b;k=b;                        
         while ((i<ii)&&(j<jj)) {
           if (*(s+i) < *(s+j)) {
              *(t+k)=*(s+i);
              i++; k++;
           }
           else {
              *(t+k)= *(s+j);
              j++;k++;
           }
         }
         if (i<ii) IMEMCPY((t+k),(s+i),(ii-i));    
         if (j<jj) IMEMCPY((t+k),(s+j),(jj-j));
     }
     tmp=s;s=t;t=tmp;
  }

  if (s!=keys) IMEMCPY(keys,s,(n)); 

  free((void *)temp);
}


void o32rdx4(unsigned int *inp,int n)
{
  register unsigned int *out, *ii, *end;
  register int i,j,k;
  unsigned int c[VFF];

  if (n <= 1) return;
  out= (unsigned int *) malloc(n*sizeof(unsigned int));


  /* ROUND-1 */
  end= inp+n*SIZE;
  memset(c,0,VFF*sizeof(int)); 
  for (ii=inp; ii< end; ii+=SIZE) {
     c[(*ii) & 0x000000FF]++; 
  } 
  for (j=1;j<VFF;j++) c[j] += c[j-1];

  for (ii=end-SIZE,i=n-1;i>=0;i--,ii-=SIZE) {
      k= --c[*ii & 0x000000FF]; 
      out[k]=*ii;
  }
  /* ROUND-2 */
  end= out+n*SIZE;
  memset(c,0,VFF*sizeof(int)); 
  for (ii=out; ii< end; ii+=SIZE) {
     c[(*ii >> 8) & 0x000000FF]++; 
  } 
  for (j=1;j<VFF;j++) c[j] += c[j-1];

  for (ii=end-SIZE,i=n-1;i>=0;i--,ii-=SIZE) {
      k= --c[(*ii>>8) & 0x000000FF]; 
      inp[k]=*ii;
  }
  /* ROUND-3 */
  end= inp+n*SIZE;
  memset(c,0,VFF*sizeof(int)); 
  for (ii=inp; ii< end; ii+=SIZE) {
     c[(*ii >>16) & 0x000000FF]++; 
  } 
  for (j=1;j<VFF;j++) c[j] += c[j-1];

  for (ii=end-SIZE,i=n-1;i>=0;i--,ii-=SIZE) {
      k= --c[(*ii>>16) & 0x000000FF]; 
      out[k]=*ii;
  }
  /* ROUND-3 */
  end= out+n*SIZE;
  memset(c,0,VFF*sizeof(int)); 
  for (ii=out; ii< end; ii+=SIZE) {
     c[(*ii >>24) ]++; 
  } 
  for (j=1;j<VFF;j++) c[j] += c[j-1];

  for (ii=end-SIZE,i=n-1;i>=0;i--,ii-=SIZE) {
      k= --c[(*ii>>24) ]; 
      inp[k]=*ii;
  }

  free((void *)out);
}



/****Copyright (c) 1997-1998,2000-2003  
 **** Constantionos J. Siniolakis and  Alexandros V. Gerbessiotis
 ****  Sequential Merging
 **** All rights reserved.
 ****Permission to use, copy, modify, and distribute this software,
 ****and to incorporate it, in whole or in part, into
 ****other software,is hereby granted without fee, provided that
 ****  (1) the above copyright notice and this permission
 ****      notice appear in all copies of the source code, and
 ****      the above copyright notice appear in clearly visible
 ****      form on all supporting documentation and distribution
 ****      media, and
 ****     (2) any redistribution of the software, in original
 ****         or modified form, be without fee and subject to
 ****         these same conditions.
 ****   No guarantee, whatsoever, is offered that the code works as
 ****   advertised or is absent of any, even damaging,
 ****   side-effects. Use this code at your own personal risk.
 ****/
/*
#define MEMCPY(XX,YY,SS)  {DES=(XX);SRC=(YY);M=(SS); do {*DES++=*SRC++;} while (--M); }
*/

void    mergedat2(idata *src1,idata *src2,int m,int k)
{
register idata *temp,*tmp,*first1,*last1,*first2,*last2;
register idata *s1,*s2;
register int t;
/*
register int M;
register idata *SRC,*DES;
*/

  tmp = (idata  *) malloc((m+k)*sizeof(idata));
  first1=src1;first2=src2;
  last1 =&src1[m];
  last2 =&src2[k];
  temp=tmp;

  for (; first1 != last1 && first2 != last2; temp++)
      if (*first2<*first1) {
        *temp=*first2;
        first2++;
      }
      else {
        *temp=*first1;
        first1++;
      }
  if ( first1 != last1) {
        for(s1=temp,s2=first1,t=last1-first1;0<t;++s1,++s2,--t)
          *s1=*s2;
/*
         MEMCPY(temp,first1,(last1-first1)*sizeof(idata));
         MEMCPY(temp,first1,(last1-first1));
*/
  }
  if ( first2 != last2) {
         for(s1=temp,s2=first2,t=last2-first2;0<t;++s1,++s2,--t)
          *s1=*s2;
/*
         MEMCPY(temp,first2,(last2-first2)*sizeof(idata));
         MEMCPY(temp,first2,(last2-first2));
*/
}

  memcpy(src1,tmp,m*sizeof(idata)) ;
  memcpy(src2,&tmp[m],k*sizeof(idata)) ;
/*
  MEMCPY(src1,tmp,m) ;
  MEMCPY(src2,&tmp[m],k) ;
  MEMCPY(src1,tmp,m*sizeof(idata)) ;
  MEMCPY(src2,&tmp[m],k*sizeof(idata)) ;
         for(s1=src1,s2=tmp,t=m;0<t;++s1,++s2,--t)
          *s1=*s2;
         for(s1=src2,s2=&tmp[m],t=k;0<t;++s1,++s2,--t)
          *s1=*s2;
*/
  free((void *)tmp);
}

void    mergedat2x(idata *src1,idata *src2,int m,int k)
{
register idata *temp;
register idata *tmp,*first1,*last1,*first2,*last2;

  tmp = (idata  *) malloc((m+k)*sizeof(idata));
  first1=src1;first2=src2;
  last1 =&src1[m];
  last2 =&src2[k];
  temp=tmp;

  for (; first1 != last1 && first2 != last2; temp++)
      if (*first2<*first1) {
        *temp=*first2;
        first2++;
      }
      else {
        *temp=*first1;
        first1++;
      }
  if ( first1 != last1)
         memcpy(temp,first1,(last1-first1)*sizeof(idata));
  if ( first2 != last2)
         memcpy(temp,first2,(last2-first2)*sizeof(idata));

  memcpy(src1,tmp,m*sizeof(idata)) ;
  memcpy(src2,&tmp[m],k*sizeof(idata)) ;

  free((void *)tmp);
}

void    mergedat(idata  *src1, idata  *src2, int m, int k)
{
 idata  *temp;
 register int i,j,l;
 register idata a,b;

#ifdef SANITY_CHECK
  if ((m <= 0)  && (k <= 0))  return ;
#endif
  temp = (idata  *) malloc((m+k)*sizeof(idata));

#ifdef SANITY_CHECK
  check_if_null((void *)temp,"mergedat","temp");
#endif

  i=j=l=0;
  for(;((i<m) && (j<k));l++) {
    a=src1[i]; b=src2[j];
    if (a<b) {
     temp[l]=a;i++;
    }
    else {
     temp[l]=b;j++;
    }
  }

  if (i <m) memcpy(&temp[l],&src1[i], (m-i)*sizeof(idata)) ;
  if (j <k) memcpy(&temp[l],&src2[j], (k -j)*sizeof(idata)) ;

  memcpy(src1, temp, m * sizeof(idata)) ;
  memcpy(src2, &temp[m], k * sizeof(idata)) ;

  free((void *)temp);
}

int      searchbdat (idata *key,idata *tbl,int n)
{
 register int    l=0,r=(n-1),m,res;
 register idata  re;

 m=(n-1)>>1;
 re=*key;
 while (l <= r) {
    res = ((re < tbl[m])?-1:(( re== tbl[m])?0:1));
    if (res <= 0) r = m - 1;
       else       l = m + 1;
    m = (l+r)>>1;
 }
 return(l);
}

int searchbgen (record *key,idata *tbl,int n,
                  int prl,int (*ncompare) () )
{
        register int    l=0,r=(n-1),m;
        register idata   res,re;
       register int k,i,p;

        m= (n-1)>>1;
        k=key->key; i =key->id; p=key->pid;

        while (l <= r) {
/*
          res = -ncompare(&tbl[m],key,prl,m);
*/
          re= k-tbl[m]; 
          res = ((re!=(idata)0)?re:((prl == p) ?
                             (i-m):
                             (p-prl)));
          if (res > 0) l=m+1;
            else       r=m-1;
          m =(l+r)>>1;
        }
        return(l);
}

  int comparerec(const void   *l, const void *r)
{
  register int i;
  record *left,*right;
  left=(record *)l; right=(record *)r;
  i= (left->key)-(right->key); 
  if (i==0) {
   return(( (left->pid == right->pid)?
            (left->id - right->id):
            (left->pid - right->pid)
         ));
  } 
  return(i);
/*
 if (i!=0) {
    return(i);
 } 
   return(( (left->pid == right->pid)?
            (left->id - right->id):
            (left->pid - right->pid)
         ));
 return( (i!=0) ? i :
            ( (left->pid == right->pid)?
            (left->id - right->id):
            (left->pid - right->pid)
         ));
*/
}
  /*We also perform a binary search of splitters into the
    input keys. We need a separate compare function */
/* comparison function for binary searching */
int bcompare(idata *left,record *right,int pidl,int idl)
{
  register int i;
/* We should have used the func function for comparison here */
  i= *left - right->key;
  if (i==0) {
    return(( (pidl == right->pid)?
             (idl -  right->id):
             (pidl -  right->pid)
          ));
  } 
  else {
    return(i);
  }
/*
  if (i!=0){
    return(i);
  } 
  else {
    return(( (pidl == right->pid)?
             (idl -  right->idl):
             (pidl -  right->pid)
          ));
  }
  return (  (i!=0) ? i :
            ((pidl == right->pid)?
             (idl -  right->idl):
             (pidl -  right->pid))
         );
*/
}

void qqsort (void *akeys,int n,int size,int (*compare)(const void*,const void*) )
{
   qsort(akeys,(size_t) n, (size_t) size, compare);
}

